/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.BlockCargoManager;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.containers.ContainerCargo;
import vswe.stevescarts.containers.slots.ISlotExplosions;
import vswe.stevescarts.containers.slots.SlotArrow;
import vswe.stevescarts.containers.slots.SlotBridge;
import vswe.stevescarts.containers.slots.SlotBuilder;
import vswe.stevescarts.containers.slots.SlotCake;
import vswe.stevescarts.containers.slots.SlotCargo;
import vswe.stevescarts.containers.slots.SlotChest;
import vswe.stevescarts.containers.slots.SlotFertilizer;
import vswe.stevescarts.containers.slots.SlotFirework;
import vswe.stevescarts.containers.slots.SlotFuel;
import vswe.stevescarts.containers.slots.SlotMilker;
import vswe.stevescarts.containers.slots.SlotSapling;
import vswe.stevescarts.containers.slots.SlotSeed;
import vswe.stevescarts.containers.slots.SlotTorch;
import vswe.stevescarts.helpers.CargoItemSelection;
import vswe.stevescarts.helpers.ComponentTypes;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.helpers.storages.TransferManager;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.init.StevesCartsModules;

public class TileEntityCargo
extends TileEntityManager
implements MenuProvider {
    public static ArrayList<CargoItemSelection> itemSelections;
    public int[] target;
    public ArrayList<SlotCargo> cargoSlots;
    public int lastLayout = -1;
    private TransferManager latestTransferToBeUsed;
    protected final SimpleContainerData dataAccess = new SimpleContainerData(16){

        public int m_6413_(int id) {
            return switch (id) {
                case 0 -> TileEntityCargo.this.layoutType;
                case 1 -> TileEntityCargo.this.color[0];
                case 2 -> TileEntityCargo.this.color[1];
                case 3 -> TileEntityCargo.this.color[2];
                case 4 -> TileEntityCargo.this.color[3];
                case 5 -> {
                    if (TileEntityCargo.this.toCart[0]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 6 -> {
                    if (TileEntityCargo.this.toCart[1]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 7 -> {
                    if (TileEntityCargo.this.toCart[2]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 8 -> {
                    if (TileEntityCargo.this.toCart[3]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 9 -> TileEntityCargo.this.target[0];
                case 10 -> TileEntityCargo.this.target[1];
                case 11 -> TileEntityCargo.this.target[2];
                case 12 -> TileEntityCargo.this.target[3];
                case 13 -> {
                    if (TileEntityCargo.this.doReturn[0]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 14 -> {
                    if (TileEntityCargo.this.doReturn[1]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 15 -> {
                    if (TileEntityCargo.this.doReturn[2]) {
                        yield 1;
                    }
                    yield 0;
                }
                case 16 -> {
                    if (TileEntityCargo.this.doReturn[3]) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> throw new IllegalArgumentException("Invalid index: " + id);
            };
        }

        public void m_8050_(int p_221477_1_, int p_221477_2_) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int m_6499_() {
            return 17;
        }
    };

    public TileEntityCargo(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.CARGO_MANAGER_TILE.get(), blockPos, blockState);
        this.target = new int[]{0, 0, 0, 0};
    }

    public static void loadSelectionSettings() {
        itemSelections = new ArrayList<CargoItemSelection>();
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_ALL, Slot.class, new ItemStack((ItemLike)ModItems.CARTS.get(), 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_ENGINE, SlotFuel.class, new ItemStack((ItemLike)ModItems.MODULES.get(StevesCartsModules.COAL_ENGINE).get())));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_RAILER, SlotBuilder.class, new ItemStack((ItemLike)Items.f_41964_)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_STORAGE, SlotChest.class, new ItemStack((ItemLike)Blocks.f_50087_, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_TORCHES, SlotTorch.class, new ItemStack((ItemLike)Blocks.f_50081_, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_EXPLOSIVES, ISlotExplosions.class, ComponentTypes.DYNAMITE.getItemStack()));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_ARROWS, SlotArrow.class, new ItemStack((ItemLike)Items.f_42412_, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_BRIDGE, SlotBridge.class, new ItemStack((ItemLike)Blocks.f_50076_, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_SEEDS, SlotSeed.class, new ItemStack((ItemLike)Items.f_42404_, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_FERTILIZER, SlotFertilizer.class, new ItemStack((ItemLike)Items.f_42499_, 1)));
        itemSelections.add(new CargoItemSelection(null, null, ItemStack.f_41583_));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_SAPLINGS, SlotSapling.class, new ItemStack((ItemLike)Blocks.f_50746_, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_FIREWORK, SlotFirework.class, new ItemStack((ItemLike)Items.f_42688_, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_BUCKETS, SlotMilker.class, new ItemStack((ItemLike)Items.f_42446_, 1)));
        itemSelections.add(new CargoItemSelection(Localization.GUI.CARGO.AREA_CAKES, SlotCake.class, new ItemStack((ItemLike)Items.f_42502_, 1)));
    }

    @Override
    protected void updateLayout() {
        if (this.cargoSlots != null && this.lastLayout != this.layoutType) {
            for (SlotCargo slot : this.cargoSlots) {
                slot.updatePosition();
            }
            this.lastLayout = this.layoutType;
        }
    }

    @Override
    protected boolean isTargetValid(TransferManager transfer) {
        return this.target[transfer.getSetting()] >= 0 && this.target[transfer.getSetting()] < itemSelections.size();
    }

    @Override
    protected void receiveClickData(int packetid, int id, int dif) {
        if (packetid == 1) {
            int[] target = this.target;
            int n = id;
            target[n] = target[n] + dif;
            if (this.target[id] >= itemSelections.size()) {
                this.target[id] = 0;
            } else if (this.target[id] < 0) {
                this.target[id] = itemSelections.size() - 1;
            }
            if (this.color[id] - 1 == this.getSide()) {
                this.reset();
            }
            if (itemSelections.get(this.target[id]).getValidSlot() == null && dif != 0) {
                this.receiveClickData(packetid, id, dif);
            }
        }
    }

    public int getAmount(int id) {
        int val = this.getAmountId(id);
        switch (val) {
            case 1: 
            case 7: {
                return 1;
            }
            case 2: 
            case 9: {
                return 3;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
            case 8: {
                return 2;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    public int getAmountType(int id) {
        int val = this.getAmountId(id);
        if (val == 0) {
            return 0;
        }
        if (val <= 6) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getAmountCount() {
        return 11;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.setWorkload(compoundTag.m_128445_("workload"));
        for (int i = 0; i < 4; ++i) {
            this.target[i] = compoundTag.m_128445_("target" + i);
        }
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128344_("workload", (byte)this.getWorkload());
        for (int i = 0; i < 4; ++i) {
            compoundTag.m_128344_("target" + i, (byte)this.target[i]);
        }
    }

    @Override
    public void receivePacket(int id, byte[] data, Player player) {
        if (id == 0) {
            byte railID = data[0];
            boolean bl = this.toCart[railID] = !this.toCart[railID];
            if (this.color[railID] - 1 == this.getSide()) {
                this.reset();
            }
        } else if (id == 4) {
            byte railID = data[0];
            if (this.color[railID] != 5) {
                this.doReturn[this.color[railID] - 1] = !this.doReturn[this.color[railID] - 1];
            }
        } else if (id == 5) {
            byte difference = data[0];
            this.layoutType += difference;
            if (this.layoutType > 2) {
                this.layoutType = 0;
            } else if (this.layoutType < 0) {
                this.layoutType = 2;
            }
            this.reset();
        } else {
            byte railsAndDifferenceCombined = data[0];
            int railID2 = railsAndDifferenceCombined & 3;
            int k = (railsAndDifferenceCombined & 4) >> 2;
            int difference2 = k == 0 ? 1 : -1;
            if (id == 2) {
                int n;
                int[] amount = this.amount;
                int n2 = n = railID2;
                amount[n2] = amount[n2] + difference2;
                if (this.amount[railID2] >= this.getAmountCount()) {
                    this.amount[railID2] = 0;
                } else if (this.amount[railID2] < 0) {
                    this.amount[railID2] = this.getAmountCount() - 1;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else if (id == 3) {
                int n2;
                if (this.color[railID2] != 5) {
                    boolean willStillExist = false;
                    for (int side = 0; side < 4; ++side) {
                        if (side == railID2 || this.color[railID2] != this.color[side]) continue;
                        willStillExist = true;
                        break;
                    }
                    if (!willStillExist) {
                        this.doReturn[this.color[railID2] - 1] = false;
                    }
                }
                int[] color = this.color;
                int n = n2 = railID2;
                color[n] = color[n] + difference2;
                if (this.color[railID2] > 5) {
                    this.color[railID2] = 1;
                } else if (this.color[railID2] < 1) {
                    this.color[railID2] = 5;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else {
                this.receiveClickData(id, railID2, difference2);
            }
        }
    }

    @Override
    protected boolean doTransfer(TransferManager transfer) {
        Class<SlotCargo> toValid;
        AbstractContainerMenu toCont;
        MenuProvider toInv;
        Class<SlotCargo> fromValid;
        AbstractContainerMenu fromCont;
        MenuProvider fromInv;
        Class<SlotCargo> slotCart = itemSelections.get(this.target[transfer.getSetting()]).getValidSlot();
        if (slotCart == null) {
            transfer.setLowestSetting(transfer.getSetting() + 1);
            return true;
        }
        Class<SlotCargo> slotCargo = SlotCargo.class;
        if (this.toCart[transfer.getSetting()]) {
            fromInv = this;
            fromCont = new ContainerCargo(0, null, this, new SimpleContainerData(0));
            fromValid = slotCargo;
            toInv = transfer.getCart();
            toCont = transfer.getCart().getCon(null);
            toValid = slotCart;
        } else {
            fromInv = transfer.getCart();
            fromCont = transfer.getCart().getCon(null);
            fromValid = slotCart;
            toInv = this;
            toCont = new ContainerCargo(0, null, this, new SimpleContainerData(0));
            toValid = slotCargo;
        }
        this.latestTransferToBeUsed = transfer;
        for (int i = 0; i < fromInv.m_6643_(); ++i) {
            if (!TransferHandler.isSlotOfType(fromCont.m_38853_(i), fromValid) || fromInv.m_8020_(i).m_41619_()) continue;
            ItemStack iStack = fromInv.m_8020_(i);
            int stacksize = iStack.m_41613_();
            int maxNumber = this.getAmountType(transfer.getSetting()) == 1 ? this.getAmount(transfer.getSetting()) - transfer.getWorkload() : -1;
            TransferHandler.TransferItem(iStack, (Container)toInv, toCont, toValid, maxNumber, TransferHandler.TRANSFER_TYPE.MANAGER);
            if (iStack.m_41613_() == stacksize) continue;
            if (this.getAmountType(transfer.getSetting()) == 1) {
                transfer.setWorkload(transfer.getWorkload() + stacksize - iStack.m_41613_());
            } else if (this.getAmountType(transfer.getSetting()) == 2) {
                transfer.setWorkload(transfer.getWorkload() + 1);
            }
            this.m_6596_();
            transfer.getCart().m_6596_();
            if (iStack.m_41613_() == 0) {
                fromInv.m_6836_(i, ItemStack.f_41583_);
            }
            if (transfer.getWorkload() >= this.getAmount(transfer.getSetting()) && this.getAmountType(transfer.getSetting()) != 0) {
                transfer.setLowestSetting(transfer.getSetting() + 1);
            }
            return true;
        }
        return false;
    }

    public TransferManager getCurrentTransferForSlots() {
        return this.latestTransferToBeUsed;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(this::createHandler).cast();
        }
        return super.getCapability(capability);
    }

    @NotNull
    private IItemHandlerModifiable createHandler() {
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof BlockCargoManager)) {
            return new InvWrapper((Container)this);
        }
        return new ItemStackHandler(0);
    }

    @Override
    public int m_6643_() {
        return 60;
    }

    public boolean m_6542_(@NotNull Player playerEntity) {
        return true;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"screen.cargo.manager");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new ContainerCargo(id, playerInventory, this, this.dataAccess);
    }
}

