/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vswe.stevescarts.Constants;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.api.IModuleItem;
import vswe.stevescarts.api.modules.ModuleType;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.api.modules.data.ModuleDataHull;
import vswe.stevescarts.blocks.BlockCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.containers.ContainerCartAssembler;
import vswe.stevescarts.containers.ContainerUpgrade;
import vswe.stevescarts.containers.slots.SlotAssembler;
import vswe.stevescarts.containers.slots.SlotAssemblerFuel;
import vswe.stevescarts.containers.slots.SlotHull;
import vswe.stevescarts.containers.slots.SlotOutput;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.DropDownMenuItem;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.SimulationInfo;
import vswe.stevescarts.helpers.TitleBox;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.init.ModItems;
import vswe.stevescarts.items.ItemCarts;
import vswe.stevescarts.polylib.NBTHelper;
import vswe.stevescarts.upgrades.AssemblerUpgrade;
import vswe.stevescarts.upgrades.BaseEffect;
import vswe.stevescarts.upgrades.CombustionFuel;
import vswe.stevescarts.upgrades.Disassemble;
import vswe.stevescarts.upgrades.FuelCapacity;
import vswe.stevescarts.upgrades.FuelCost;
import vswe.stevescarts.upgrades.TimeFlat;
import vswe.stevescarts.upgrades.TimeFlatCart;
import vswe.stevescarts.upgrades.TimeFlatRemoved;
import vswe.stevescarts.upgrades.WorkEfficiency;

public class TileEntityCartAssembler
extends TileEntityBase
implements WorldlyContainer,
MenuProvider {
    private int maxAssemblingTime;
    private float currentAssemblingTime = -1.0f;
    private int fuelCheckTimer;
    @Nonnull
    protected ItemStack outputItem = ItemStack.f_41583_;
    protected NonNullList<ItemStack> spareModules;
    private boolean isAssembling;
    public boolean isErrorListOutdated;
    private final ArrayList<TitleBox> titleBoxes;
    private final ArrayList<DropDownMenuItem> dropDownItems;
    private final SimulationInfo info;
    private boolean shouldSpin = true;
    private EntityMinecartModular placeholder;
    private float yaw = 0.0f;
    private float roll = 0.0f;
    private boolean rolldown = false;
    private final ArrayList<SlotAssembler> slots;
    private final ArrayList<SlotAssembler> engineSlots;
    private final ArrayList<SlotAssembler> addonSlots;
    private final ArrayList<SlotAssembler> chestSlots;
    private final ArrayList<SlotAssembler> funcSlots;
    private final SlotHull hullSlot;
    private final SlotAssembler toolSlot;
    private final SlotOutput outputSlot;
    private final SlotAssemblerFuel fuelSlot;
    private final int[] topbotSlots;
    private final int[] sideSlots;
    @Nonnull
    private ItemStack lastHull = ItemStack.f_41583_;
    private float fuelLevel;
    private final ArrayList<TileEntityUpgrade> upgrades;
    public boolean isDead;
    private boolean loaded;
    NonNullList<ItemStack> inventoryStacks;
    protected final SimpleContainerData dataAccess = new SimpleContainerData(0){

        public int m_6413_(int id) {
            return switch (id) {
                case 0 -> TileEntityCartAssembler.this.getShortFromInt(true, TileEntityCartAssembler.this.maxAssemblingTime);
                case 1 -> TileEntityCartAssembler.this.getShortFromInt(false, TileEntityCartAssembler.this.maxAssemblingTime);
                case 2 -> TileEntityCartAssembler.this.getShortFromInt(true, TileEntityCartAssembler.this.getAssemblingTime());
                case 3 -> TileEntityCartAssembler.this.getShortFromInt(false, TileEntityCartAssembler.this.getAssemblingTime());
                case 4 -> (short)(TileEntityCartAssembler.this.isAssembling ? 1 : 0);
                case 5 -> TileEntityCartAssembler.this.getShortFromInt(true, TileEntityCartAssembler.this.getFuelLevel());
                case 6 -> TileEntityCartAssembler.this.getShortFromInt(false, TileEntityCartAssembler.this.getFuelLevel());
                default -> throw new IllegalArgumentException("Invalid index: " + id);
            };
        }

        public void m_8050_(int p_221477_1_, int p_221477_2_) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int m_6499_() {
            return 7;
        }
    };
    public static final String MODIFY_STATUS = "ModifyStatus";

    public TileEntityCartAssembler(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.CART_ASSEMBLER_TILE.get(), blockPos, blockState);
        SlotAssembler slot;
        int i;
        this.upgrades = new ArrayList();
        this.spareModules = NonNullList.m_122779_();
        this.dropDownItems = new ArrayList();
        this.slots = new ArrayList();
        this.engineSlots = new ArrayList();
        this.addonSlots = new ArrayList();
        this.chestSlots = new ArrayList();
        this.funcSlots = new ArrayList();
        this.titleBoxes = new ArrayList();
        int slotID = 0;
        this.hullSlot = new SlotHull(this, slotID++, 18, 25);
        this.slots.add(this.hullSlot);
        TitleBox engineBox = new TitleBox(0, 65, 16225309);
        TitleBox toolBox = new TitleBox(1, 100, 6696337);
        TitleBox attachBox = new TitleBox(2, 135, 23423);
        TitleBox storageBox = new TitleBox(3, 170, 10357518);
        TitleBox addonBox = new TitleBox(4, 205, 22566);
        TitleBox infoBox = new TitleBox(5, 375, 30, 13417984);
        this.titleBoxes.add(engineBox);
        this.titleBoxes.add(toolBox);
        this.titleBoxes.add(attachBox);
        this.titleBoxes.add(storageBox);
        this.titleBoxes.add(addonBox);
        this.titleBoxes.add(infoBox);
        for (i = 0; i < 5; ++i) {
            slot = new SlotAssembler(this, slotID++, engineBox.getX() + 2 + 18 * i, engineBox.getY(), ModuleType.ENGINE, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.engineSlots.add(slot);
        }
        this.toolSlot = new SlotAssembler(this, slotID++, toolBox.getX() + 2, toolBox.getY(), ModuleType.TOOL, false, 0);
        this.slots.add(this.toolSlot);
        this.toolSlot.invalidate();
        for (i = 0; i < 6; ++i) {
            slot = new SlotAssembler(this, slotID++, attachBox.getX() + 2 + 18 * i, attachBox.getY(), ModuleType.ATTACHMENT, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.funcSlots.add(slot);
        }
        for (i = 0; i < 4; ++i) {
            slot = new SlotAssembler(this, slotID++, storageBox.getX() + 2 + 18 * i, storageBox.getY(), ModuleType.STORAGE, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.chestSlots.add(slot);
        }
        for (i = 0; i < 12; ++i) {
            slot = new SlotAssembler(this, slotID++, addonBox.getX() + 2 + 18 * (i % 6), addonBox.getY() + 18 * (i / 6), ModuleType.ADDON, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.addonSlots.add(slot);
        }
        this.fuelSlot = new SlotAssemblerFuel(this, slotID++, 395, 220);
        this.slots.add(this.fuelSlot);
        this.outputSlot = new SlotOutput(this, slotID++, 450, 220);
        this.outputSlot.invalidate();
        this.slots.add(this.outputSlot);
        this.info = new SimulationInfo();
        this.inventoryStacks = NonNullList.m_122780_((int)this.slots.size(), (Object)ItemStack.f_41583_);
        this.topbotSlots = new int[]{this.m_6643_() - this.nonModularSlots()};
        this.sideSlots = new int[]{this.m_6643_() - this.nonModularSlots() + 1};
    }

    public void clearUpgrades() {
        this.upgrades.clear();
    }

    public void addUpgrade(TileEntityUpgrade upgrade) {
        this.upgrades.add(upgrade);
    }

    public void removeUpgrade(TileEntityUpgrade upgrade) {
        this.upgrades.remove(upgrade);
    }

    public ArrayList<TileEntityUpgrade> getUpgradeTiles() {
        return this.upgrades;
    }

    public ArrayList<AssemblerUpgrade> getUpgrades() {
        ArrayList<AssemblerUpgrade> lst = new ArrayList<AssemblerUpgrade>();
        for (TileEntityUpgrade tile : this.upgrades) {
            lst.add(tile.getUpgrade());
        }
        return lst;
    }

    public ArrayList<BaseEffect> getEffects() {
        ArrayList<BaseEffect> lst = new ArrayList<BaseEffect>();
        for (TileEntityUpgrade tile : this.upgrades) {
            AssemblerUpgrade upgrade = tile.getUpgrade();
            if (upgrade == null) continue;
            lst.addAll(upgrade.getEffects());
        }
        return lst;
    }

    public SimulationInfo getSimulationInfo() {
        return this.info;
    }

    public ArrayList<DropDownMenuItem> getDropDown() {
        return this.dropDownItems;
    }

    public ArrayList<TitleBox> getTitleBoxes() {
        return this.titleBoxes;
    }

    public static int getRemovedSize() {
        return -1;
    }

    public static int getKeepSize() {
        return 0;
    }

    public ArrayList<SlotAssembler> getSlots() {
        return this.slots;
    }

    public ArrayList<SlotAssembler> getEngines() {
        return this.engineSlots;
    }

    public ArrayList<SlotAssembler> getChests() {
        return this.chestSlots;
    }

    public ArrayList<SlotAssembler> getAddons() {
        return this.addonSlots;
    }

    public ArrayList<SlotAssembler> getFuncs() {
        return this.funcSlots;
    }

    public SlotAssembler getToolSlot() {
        return this.toolSlot;
    }

    public int getMaxAssemblingTime() {
        return this.maxAssemblingTime;
    }

    public int getAssemblingTime() {
        return (int)this.currentAssemblingTime;
    }

    private void setAssemblingTime(int val) {
        this.currentAssemblingTime = val;
    }

    public boolean getIsAssembling() {
        return this.isAssembling;
    }

    public void doAssemble() {
        if (!this.hasErrors()) {
            this.maxAssemblingTime = this.generateAssemblingTime();
            this.createCartFromModules();
            this.isAssembling = true;
            for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
                if (tile.getUpgrade() == null) continue;
                for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                    if (!(effect instanceof Disassemble)) continue;
                    ItemStack oldcart = tile.m_8020_(0);
                    if (!oldcart.m_41619_() && !this.outputItem.m_41619_() && oldcart.m_41720_() instanceof ItemCarts && this.outputItem.m_41720_() instanceof ItemCarts && oldcart.m_41788_()) {
                        this.outputItem.m_41714_(oldcart.m_41611_());
                    }
                    tile.m_6836_(0, ItemStack.f_41583_);
                }
            }
        }
    }

    public void receivePacket(int id, byte[] data, @Nullable ServerPlayer sender) {
        SlotAssembler slot;
        byte slotId;
        if (id == 0) {
            this.doAssemble();
        } else if (id == 1 && (slotId = data[0]) >= 1 && slotId < this.getSlots().size() && !(slot = this.getSlots().get(slotId)).m_7993_().m_41619_()) {
            CompoundTag comp = TileEntityCartAssembler.getOrCreateCompound(slot.m_7993_());
            if (comp.m_128451_(MODIFY_STATUS) == TileEntityCartAssembler.getKeepSize()) {
                comp.m_128405_(MODIFY_STATUS, TileEntityCartAssembler.getRemovedSize());
            } else {
                comp.m_128405_(MODIFY_STATUS, TileEntityCartAssembler.getKeepSize());
            }
        }
    }

    public static CompoundTag getOrCreateCompound(ItemStack stack) {
        if (!stack.m_41782_() && !stack.m_41619_()) {
            stack.m_41751_(new CompoundTag());
        }
        return stack.m_41783_();
    }

    public static int getSlotStatus(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_(MODIFY_STATUS, NBTHelper.INT.getId())) {
            return stack.m_41783_().m_128451_(MODIFY_STATUS);
        }
        return 1;
    }

    public static ItemStack removeModify(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128425_(MODIFY_STATUS, NBTHelper.INT.getId())) {
            stack.m_41783_().m_128473_(MODIFY_STATUS);
            if (stack.m_41783_().m_128440_() <= 0) {
                stack.m_41751_(null);
            }
        }
        return stack;
    }

    public void onUpgradeUpdate() {
    }

    public int generateAssemblingTime() {
        if (((Boolean)SCConfig.disableTimedCrafting.get()).booleanValue()) {
            return 1;
        }
        return this.generateAssemblingTime(this.getModules(true, new int[]{TileEntityCartAssembler.getKeepSize(), TileEntityCartAssembler.getRemovedSize()}), this.getModules(true, new int[]{TileEntityCartAssembler.getKeepSize(), 1}));
    }

    private int generateAssemblingTime(ArrayList<ModuleData> modules, ArrayList<ModuleData> removed) {
        int timeRequired = 100;
        for (ModuleData module : modules) {
            timeRequired += this.getAssemblingTime(module, false);
        }
        for (ModuleData module : removed) {
            timeRequired += this.getAssemblingTime(module, true);
        }
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof TimeFlatCart)) continue;
            timeRequired += ((TimeFlatCart)effect).getTicks();
        }
        return Math.max(0, timeRequired);
    }

    private int getAssemblingTime(ModuleData module, boolean isRemoved) {
        int time = (int)(5.0 * Math.pow(module.getCost(), 2.2));
        return Math.max(0, time += this.getTimeDecreased(isRemoved));
    }

    @Nonnull
    public ItemStack getCartFromModules(boolean isSimulated) {
        NonNullList items = NonNullList.m_122779_();
        for (int i = 0; i < this.m_6643_() - this.nonModularSlots(); ++i) {
            ItemStack item = this.m_8020_(i);
            if (item.m_41619_()) continue;
            if (TileEntityCartAssembler.getSlotStatus(item) != TileEntityCartAssembler.getRemovedSize()) {
                items.add((Object)item);
                continue;
            }
            if (isSimulated) continue;
            ItemStack spare = item.m_41777_();
            spare.m_41764_(1);
            this.spareModules.add((Object)spare);
        }
        if (items.size() == 1) {
            return TileEntityCartAssembler.removeModify((ItemStack)items.get(0));
        }
        return ModuleData.createModularCartFromItems((NonNullList<ItemStack>)items);
    }

    private void createCartFromModules() {
        this.spareModules.clear();
        this.outputItem = this.getCartFromModules(false);
        if (!this.outputItem.m_41619_()) {
            for (int i = 0; i < this.m_6643_() - this.nonModularSlots(); ++i) {
                this.m_6836_(i, ItemStack.f_41583_);
            }
        } else {
            this.spareModules.clear();
        }
    }

    public ArrayList<ModuleData> getNonHullModules() {
        return this.getModules(false);
    }

    public ArrayList<ModuleData> getModules(boolean includeHull) {
        return this.getModules(includeHull, new int[]{TileEntityCartAssembler.getRemovedSize()});
    }

    public ArrayList<ModuleData> getModules(boolean includeHull, int[] invalid) {
        int i;
        ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
        int n = i = includeHull ? 0 : 1;
        while (i < this.m_6643_() - this.nonModularSlots()) {
            ItemStack item = this.m_8020_(i);
            if (!item.m_41619_()) {
                IModuleItem itemCartModule;
                ModuleData module;
                Item item2;
                boolean validSize = true;
                for (int k : invalid) {
                    if (k != TileEntityCartAssembler.getSlotStatus(item) && (k <= 0 || TileEntityCartAssembler.getSlotStatus(item) <= 0)) continue;
                    validSize = false;
                    break;
                }
                if (validSize && (item2 = item.m_41720_()) instanceof IModuleItem && (module = (itemCartModule = (IModuleItem)item2).getModuleData()) != null) {
                    modules.add(module);
                }
            }
            ++i;
        }
        return modules;
    }

    public ModuleDataHull getHullModule() {
        IModuleItem itemCartModule;
        ModuleData hulldata;
        ItemStack stack;
        Item item;
        if (!this.m_8020_(0).m_41619_() && (item = (stack = this.m_8020_(0)).m_41720_()) instanceof IModuleItem && (hulldata = (itemCartModule = (IModuleItem)item).getModuleData()) instanceof ModuleDataHull) {
            return (ModuleDataHull)hulldata;
        }
        return null;
    }

    private boolean hasErrors() {
        return this.getErrors().size() > 0;
    }

    public ArrayList<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.hullSlot.m_7993_().m_41619_()) {
            errors.add(Localization.GUI.ASSEMBLER.HULL_ERROR.translate(new String[0]));
        } else {
            IModuleItem itemCartModule = (IModuleItem)this.m_8020_(0).m_41720_();
            ModuleData hulldata = itemCartModule.getModuleData();
            if (!(hulldata instanceof ModuleDataHull)) {
                errors.add(Localization.GUI.ASSEMBLER.INVALID_HULL_SHORT.translate(new String[0]));
            } else {
                if (this.isAssembling) {
                    errors.add(Localization.GUI.ASSEMBLER.BUSY.translate(new String[0]));
                } else if (this.outputSlot != null && !this.outputSlot.m_7993_().m_41619_()) {
                    errors.add(Localization.GUI.ASSEMBLER.DEPARTURE_BAY.translate(new String[0]));
                }
                ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
                for (int i = 0; i < this.m_6643_() - this.nonModularSlots(); ++i) {
                    IModuleItem itemCartModule1;
                    ModuleData data;
                    if (this.m_8020_(i).m_41619_() || (data = (itemCartModule1 = (IModuleItem)this.m_8020_(i).m_41720_()).getModuleData()) == null) continue;
                    modules.add(data);
                }
                String error = ModuleData.checkForErrors((ModuleDataHull)hulldata, modules);
                if (error != null) {
                    errors.add(error);
                }
            }
        }
        return errors;
    }

    public int getTotalCost() {
        ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
        for (int i = 0; i < this.m_6643_() - this.nonModularSlots(); ++i) {
            IModuleItem itemCartModule;
            ModuleData data;
            Item item;
            if (this.m_8020_(i).m_41619_() || !((item = this.m_8020_(i).m_41720_()) instanceof IModuleItem) || (data = (itemCartModule = (IModuleItem)item).getModuleData()) == null) continue;
            modules.add(data);
        }
        return ModuleData.getTotalCost(modules);
    }

    private void invalidateAll() {
        int i;
        for (i = 0; i < this.getEngines().size(); ++i) {
            this.getEngines().get(i).invalidate();
        }
        for (i = 0; i < this.getAddons().size(); ++i) {
            this.getAddons().get(i).invalidate();
        }
        for (i = 0; i < this.getChests().size(); ++i) {
            this.getChests().get(i).invalidate();
        }
        for (i = 0; i < this.getFuncs().size(); ++i) {
            this.getFuncs().get(i).invalidate();
        }
        this.getToolSlot().invalidate();
    }

    private void validateAll() {
        if (this.hullSlot == null) {
            return;
        }
        ArrayList<SlotAssembler> slots = this.getValidSlotFromHullItem(this.hullSlot.m_7993_());
        if (slots != null) {
            for (SlotAssembler slot : slots) {
                slot.validate();
            }
        }
    }

    public ArrayList<SlotAssembler> getValidSlotFromHullItem(@Nonnull ItemStack hullitem) {
        IModuleItem itemCartModule;
        ModuleData moduleData;
        Item item;
        if (!hullitem.m_41619_() && (item = hullitem.m_41720_()) instanceof IModuleItem && (moduleData = (itemCartModule = (IModuleItem)item).getModuleData()) instanceof ModuleDataHull) {
            ModuleDataHull moduleDataHull = (ModuleDataHull)moduleData;
            return this.getValidSlotFromHull(moduleDataHull);
        }
        return null;
    }

    private ArrayList<SlotAssembler> getValidSlotFromHull(ModuleDataHull hull) {
        int i;
        ArrayList<SlotAssembler> slots = new ArrayList<SlotAssembler>();
        for (i = 0; i < hull.getEngineMax(); ++i) {
            slots.add(this.getEngines().get(i));
        }
        for (i = 0; i < hull.getAddonMax(); ++i) {
            slots.add(this.getAddons().get(i));
        }
        slots.addAll(this.getChests());
        slots.addAll(this.getFuncs());
        slots.add(this.getToolSlot());
        return slots;
    }

    public int getMaxFuelLevel() {
        int capacity = 4000;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof FuelCapacity)) continue;
            capacity += ((FuelCapacity)effect).getFuelCapacity();
        }
        if (capacity > 200000) {
            capacity = 200000;
        } else if (capacity < 1) {
            capacity = 1;
        }
        return capacity;
    }

    public boolean isCombustionFuelValid() {
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof CombustionFuel)) continue;
            return true;
        }
        return false;
    }

    public int getFuelLevel() {
        return (int)this.fuelLevel;
    }

    public void setFuelLevel(int val) {
        this.fuelLevel = val;
    }

    private int getTimeDecreased(boolean isRemoved) {
        int timeDecr = 0;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof TimeFlat) || effect instanceof TimeFlatRemoved) continue;
            timeDecr += ((TimeFlat)effect).getTicks();
        }
        if (isRemoved) {
            for (BaseEffect effect : this.getEffects()) {
                if (!(effect instanceof TimeFlatRemoved)) continue;
                timeDecr += ((TimeFlat)effect).getTicks();
            }
        }
        return timeDecr;
    }

    private float getFuelCost() {
        float cost = 1.0f;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof FuelCost)) continue;
            cost += ((FuelCost)effect).getCost();
        }
        return cost;
    }

    public float getEfficiency() {
        float efficiency = 1.0f;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof WorkEfficiency)) continue;
            efficiency += ((WorkEfficiency)effect).getEfficiency();
        }
        return efficiency;
    }

    private void deployCart() {
    }

    private void deploySpares() {
        for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
            if (tile.getUpgrade() == null) continue;
            for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                if (!(effect instanceof Disassemble)) continue;
                for (ItemStack item : this.spareModules) {
                    item = TileEntityCartAssembler.removeModify(item);
                    TransferHandler.TransferItem(item, (Container)tile, new ContainerUpgrade(0, null, tile, new SimpleContainerData(0)), 1);
                    if (item.m_41613_() <= 0) continue;
                    this.puke(item);
                }
            }
        }
    }

    public void puke(@Nonnull ItemStack item) {
        if (this.f_58857_ == null) {
            return;
        }
        ItemEntity entityitem = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_() + 0.25, (double)this.m_58899_().m_123343_(), item);
        this.f_58857_.m_7967_((Entity)entityitem);
    }

    @Override
    public void tick() {
        CompoundTag info;
        ItemStack itemInSlot;
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.loaded) {
            ((BlockCartAssembler)((Object)ModBlocks.CART_ASSEMBLER.get())).updateMultiBlock(this.f_58857_, this.m_58899_());
            this.loaded = true;
        }
        if (!this.isAssembling && this.outputSlot != null && !this.outputSlot.m_7993_().m_41619_() && (itemInSlot = this.outputSlot.m_7993_()).m_41720_() == ModItems.CARTS.get() && (info = itemInSlot.m_41783_()) != null && info.m_128441_("maxTime")) {
            ItemStack newItem = new ItemStack((ItemLike)ModItems.CARTS.get());
            CompoundTag save = new CompoundTag();
            save.m_128382_("Modules", info.m_128463_("Modules"));
            newItem.m_41751_(save);
            this.maxAssemblingTime = info.m_128451_("maxTime");
            this.setAssemblingTime(info.m_128451_("currentTime"));
            this.spareModules.clear();
            if (itemInSlot.m_41788_()) {
                newItem.m_41714_(itemInSlot.m_41611_());
            }
            this.isAssembling = true;
            this.outputItem = newItem;
            this.outputSlot.m_5852_(ItemStack.f_41583_);
        }
        if (this.getFuelLevel() > this.getMaxFuelLevel()) {
            this.setFuelLevel(this.getMaxFuelLevel());
        }
        if (this.isAssembling && this.outputSlot != null && (float)this.getFuelLevel() >= this.getFuelCost()) {
            this.currentAssemblingTime += this.getEfficiency();
            this.fuelLevel -= this.getFuelCost();
            if (this.getFuelLevel() <= 0) {
                this.setFuelLevel(0);
            }
            if (this.getAssemblingTime() >= this.maxAssemblingTime) {
                this.isAssembling = false;
                this.setAssemblingTime(0);
                if (!this.outputItem.m_41619_()) {
                    this.m_6836_(this.outputSlot.getSlotIndex(), this.outputItem);
                }
                if (!this.f_58857_.f_46443_) {
                    this.deployCart();
                    this.outputItem = ItemStack.f_41583_;
                    this.deploySpares();
                    this.spareModules.clear();
                }
            }
        }
        if (!this.f_58857_.m_5776_() && this.fuelCheckTimer-- <= 0 && this.fuelSlot != null && !this.fuelSlot.m_7993_().m_41619_() && this.getFuelLevel() < this.getMaxFuelLevel()) {
            int fuel = this.fuelSlot.getFuelLevel(this.fuelSlot.m_7993_());
            if (fuel > 0 && this.getFuelLevel() + fuel <= this.getMaxFuelLevel()) {
                this.setFuelLevel(this.getFuelLevel() + fuel);
                if (this.fuelSlot.m_7993_().hasCraftingRemainingItem()) {
                    this.fuelSlot.m_5852_(this.fuelSlot.m_7993_().getCraftingRemainingItem());
                } else {
                    ItemStack stack = this.fuelSlot.m_7993_();
                    stack.m_41774_(1);
                }
                if (this.fuelSlot.m_7993_().m_41613_() <= 0) {
                    this.fuelSlot.m_5852_(ItemStack.f_41583_);
                }
            } else {
                this.fuelCheckTimer = 20;
            }
        }
        this.updateSlots();
        this.handlePlaceholder();
    }

    public void updateSlots() {
        if (this.hullSlot != null) {
            if (!this.lastHull.m_41619_() && this.hullSlot.m_7993_().m_41619_()) {
                this.invalidateAll();
            } else if (this.lastHull.m_41619_() && !this.hullSlot.m_7993_().m_41619_()) {
                this.validateAll();
            } else if (this.lastHull != this.hullSlot.m_7993_()) {
                this.invalidateAll();
                this.validateAll();
            }
            this.lastHull = this.hullSlot.m_7993_();
        }
        for (SlotAssembler slot : this.slots) {
            slot.m_6654_();
        }
    }

    public void resetPlaceholder() {
        this.placeholder = null;
    }

    public EntityMinecartModular getPlaceholder() {
        return this.placeholder;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getRoll() {
        return this.roll;
    }

    public void setYaw(float val) {
        this.yaw = val;
    }

    public void setRoll(float val) {
        this.roll = val;
    }

    public void setSpinning(boolean val) {
        this.shouldSpin = val;
    }

    public boolean shouldSpin() {
        return this.shouldSpin;
    }

    public int nonModularSlots() {
        return 2;
    }

    private void handlePlaceholder() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (this.placeholder == null) {
                return;
            }
            if (!Constants.freezeCartSimulation) {
                int minRoll = -5;
                int maxRoll = 25;
                if (this.shouldSpin) {
                    this.yaw += 2.0f;
                    this.roll %= 360.0f;
                    if (!this.rolldown) {
                        this.roll = this.roll < -8.0f ? (this.roll += 5.0f) : (this.roll += 0.2f);
                        if (this.roll > 25.0f) {
                            this.rolldown = true;
                        }
                    } else {
                        this.roll = this.roll > 28.0f ? (this.roll -= 5.0f) : (this.roll -= 0.2f);
                        if (this.roll < -5.0f) {
                            this.rolldown = false;
                        }
                    }
                }
            }
            this.placeholder.onCartUpdate();
            if (this.placeholder == null) {
                return;
            }
            this.placeholder.updateFuel();
        }
    }

    public int @NotNull [] m_7071_(@NotNull Direction direction) {
        return new int[0];
    }

    public boolean m_7155_(int id, @NotNull ItemStack itemStack, @javax.annotation.Nullable Direction direction) {
        return false;
    }

    public boolean m_7157_(int id, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        return false;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"tile.cart.assembler");
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new ContainerCartAssembler(id, playerInventory, this, this.dataAccess);
    }

    public void createPlaceholder() {
        if (this.placeholder == null) {
            this.placeholder = new EntityMinecartModular(this.f_58857_, this, this.getModularInfo());
            this.updateRenderMenu();
            this.isErrorListOutdated = true;
        }
    }

    public void updatePlaceholder() {
        if (this.placeholder != null) {
            this.placeholder.updateSimulationModules(this.getModularInfo());
            this.updateRenderMenu();
            this.isErrorListOutdated = true;
        }
    }

    private void updateRenderMenu() {
        ArrayList<DropDownMenuItem> list = this.info.getList();
        this.dropDownItems.clear();
        block0: for (DropDownMenuItem item : list) {
            if (item.getModuleClass() == null) {
                this.dropDownItems.add(item);
                continue;
            }
            for (int i = 0; i < this.m_6643_() - this.nonModularSlots(); ++i) {
                if (this.m_8020_(i).m_41619_() || !ModuleData.isItemOfModularType(this.m_8020_(i), item.getModuleClass()) || item.getExcludedClass() != null && ModuleData.isItemOfModularType(this.m_8020_(i), item.getExcludedClass())) continue;
                this.dropDownItems.add(item);
                continue block0;
            }
        }
    }

    private ArrayList<ResourceLocation> getModularInfo() {
        ArrayList<ResourceLocation> datalist = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.m_6643_() - this.nonModularSlots(); ++i) {
            IModuleItem itemCartModule;
            ModuleData data;
            Item item;
            if (this.m_8020_(i).m_41619_() || !((item = this.m_8020_(i).m_41720_()) instanceof IModuleItem) || (data = (itemCartModule = (IModuleItem)item).getModuleData()) == null) continue;
            datalist.add(data.getID());
        }
        return datalist;
    }

    public boolean getIsDisassembling() {
        for (int i = 0; i < this.m_6643_() - this.nonModularSlots(); ++i) {
            if (this.m_8020_(i).m_41619_() || TileEntityCartAssembler.getSlotStatus(this.m_8020_(i)) > 0) continue;
            return true;
        }
        return false;
    }

    public int m_6643_() {
        return this.inventoryStacks.size();
    }

    public boolean m_7983_() {
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int i) {
        return i >= 0 && i < this.inventoryStacks.size() ? (ItemStack)this.inventoryStacks.get(i) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_7407_(int i, int j) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.inventoryStacks, (int)i, (int)j);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int i) {
        ItemStack itemStack = (ItemStack)this.inventoryStacks.get(i);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.inventoryStacks.set(i, (Object)ItemStack.f_41583_);
        return itemStack;
    }

    public void m_6836_(int i, @NotNull ItemStack itemStack) {
        this.inventoryStacks.set(i, (Object)itemStack);
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        this.inventoryStacks.clear();
        this.m_6596_();
    }

    public void m_142466_(@NotNull CompoundTag tagCompound) {
        ItemStack iStack;
        super.m_142466_(tagCompound);
        ListTag items = tagCompound.m_128437_("Items", NBTHelper.COMPOUND.getId());
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag item = items.m_128728_(i);
            int slot = item.m_128445_("Slot") & 0xFF;
            iStack = ItemStack.m_41712_((CompoundTag)item);
            if (slot >= this.m_6643_()) continue;
            this.m_6836_(slot, iStack);
        }
        ListTag spares = tagCompound.m_128437_("Spares", NBTHelper.COMPOUND.getId());
        this.spareModules.clear();
        for (int j = 0; j < spares.size(); ++j) {
            CompoundTag item2 = spares.m_128728_(j);
            iStack = ItemStack.m_41712_((CompoundTag)item2);
            this.spareModules.add((Object)iStack);
        }
        CompoundTag outputTag = (CompoundTag)tagCompound.m_128423_("Output");
        if (outputTag != null) {
            this.outputItem = ItemStack.m_41712_((CompoundTag)outputTag);
        }
        if (tagCompound.m_128441_("Fuel")) {
            this.setFuelLevel(tagCompound.m_128448_("Fuel"));
        } else {
            this.setFuelLevel(tagCompound.m_128451_("IntFuel"));
        }
        this.maxAssemblingTime = tagCompound.m_128451_("maxTime");
        this.setAssemblingTime(tagCompound.m_128451_("currentTime"));
        this.isAssembling = tagCompound.m_128471_("isAssembling");
    }

    public void m_183515_(@NotNull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        ListTag items = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack iStack = this.m_8020_(i);
            if (iStack.m_41619_()) continue;
            CompoundTag item = new CompoundTag();
            item.m_128344_("Slot", (byte)i);
            iStack.m_41739_(item);
            items.add((Object)item);
        }
        tagCompound.m_128365_("Items", (Tag)items);
        ListTag spares = new ListTag();
        for (ItemStack iStack2 : this.spareModules) {
            if (iStack2.m_41619_()) continue;
            CompoundTag item2 = new CompoundTag();
            iStack2.m_41739_(item2);
            spares.add((Object)item2);
        }
        tagCompound.m_128365_("Spares", (Tag)spares);
        if (!this.outputItem.m_41619_()) {
            CompoundTag outputTag = new CompoundTag();
            this.outputItem.m_41739_(outputTag);
            tagCompound.m_128365_("Output", (Tag)outputTag);
        }
        tagCompound.m_128405_("IntFuel", this.getFuelLevel());
        tagCompound.m_128405_("maxTime", this.maxAssemblingTime);
        tagCompound.m_128405_("currentTime", this.getAssemblingTime());
        tagCompound.m_128379_("isAssembling", this.isAssembling);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.m_142466_(pkt.m_131708_());
        }
    }

    public CompoundTag getOutputInfo() {
        if (this.outputItem.m_41619_()) {
            return null;
        }
        if (!this.outputItem.m_41782_()) {
            return null;
        }
        return this.outputItem.m_41783_();
    }

    public void increaseFuel(int val) {
        this.fuelLevel += (float)val;
        if (this.fuelLevel > (float)this.getMaxFuelLevel()) {
            this.fuelLevel = this.getMaxFuelLevel();
        }
    }
}

