/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityActivator;
import vswe.stevescarts.containers.ContainerActivator;
import vswe.stevescarts.helpers.ActivatorOption;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.network.PacketHandler;
import vswe.stevescarts.network.packets.PacketActivator;

public class GuiActivator
extends AbstractContainerScreen<ContainerActivator> {
    private static ResourceLocation texture = ResourceHelper.getResource("/gui/activator.png");
    TileEntityActivator activator;
    Inventory invPlayer;

    public GuiActivator(ContainerActivator containerActivator, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)containerActivator, playerInventory, iTextComponent);
        this.invPlayer = playerInventory;
        this.f_97726_ = 255;
        this.f_97727_ = 222;
        this.activator = containerActivator.getActivator();
    }

    protected void m_7286_(@NotNull PoseStack poseStack, float p_230450_2_, int mouseX, int mouseY) {
        int j = this.getGuiLeft();
        int k = this.getGuiTop();
        ResourceHelper.bindResource(texture);
        this.m_93228_(poseStack, j, k, 0, 0, this.f_97726_, this.f_97727_);
        mouseX -= this.getGuiLeft();
        mouseY -= this.getGuiTop();
        for (int i = 0; i < this.activator.getOptions().size(); ++i) {
            ActivatorOption option = this.activator.getOptions().get(i);
            int[] box = this.getBoxRect(i);
            int srcX = 0;
            if (this.inRect(mouseX, mouseY, box)) {
                srcX = 16;
            }
            this.m_93228_(poseStack, j + box[0], k + box[1], srcX, this.f_97727_, box[2], box[3]);
            this.m_93228_(poseStack, j + box[0] + 1, k + box[1] + 1, (box[2] - 2) * option.getOption(), this.f_97727_ + box[3], box[2] - 2, box[3] - 2);
        }
    }

    protected void m_7027_(@NotNull PoseStack poseStack, int p_230451_2_, int p_230451_3_) {
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float p_230430_4_) {
        int[] box;
        ActivatorOption option;
        int i;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, p_230430_4_);
        this.m_7025_(poseStack, mouseX, mouseY);
        mouseX -= this.getGuiLeft();
        mouseY -= this.getGuiTop();
        this.f_96547_.m_92883_(poseStack, Localization.GUI.TOGGLER.TITLE.translate(new String[0]), (float)(this.getGuiLeft() + 8), (float)(this.getGuiTop() + 6), 0x404040);
        for (i = 0; i < this.activator.getOptions().size(); ++i) {
            option = this.activator.getOptions().get(i);
            box = this.getBoxRect(i);
            this.f_96547_.m_92883_(poseStack, option.getName(), (float)(this.getGuiLeft() + box[0] + box[2] + 6), (float)(this.getGuiTop() + box[1] + 4), 0x404040);
        }
        for (i = 0; i < this.activator.getOptions().size(); ++i) {
            option = this.activator.getOptions().get(i);
            box = this.getBoxRect(i);
            this.drawMouseMover(poseStack, option.getInfo(), mouseX, mouseY, box);
        }
    }

    private void drawMouseMover(PoseStack matrixStack, String str, int x, int y, int[] rect) {
        if (this.inRect(x, y, rect)) {
            this.drawMouseOver(matrixStack, str, x, y, rect);
        }
    }

    public void drawMouseOver(PoseStack matrixStack, String str, int x, int y, int[] rect) {
        if (this.inRect(x, y, rect)) {
            this.m_96602_(matrixStack, (Component)Component.m_237113_((String)str), this.getGuiLeft() + x, this.getGuiTop() + y);
        }
    }

    private int[] getBoxRect(int i) {
        return new int[]{20, 22 + i * 20, 16, 16};
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        mouseX -= (double)this.getGuiLeft();
        mouseY -= (double)this.getGuiTop();
        for (int i = 0; i < this.activator.getOptions().size(); ++i) {
            int[] box = this.getBoxRect(i);
            if (!this.inRect((int)mouseX, (int)mouseY, box)) continue;
            byte data = (byte)(button != 0 ? 1 : 0);
            data = (byte)(data | (byte)(i << 1));
            this.activator.getOptions().get(i).changeOption(button == 0);
            PacketHandler.sendToServer(new PacketActivator(this.activator.m_58899_(), 0, new byte[]{data}));
        }
        return true;
    }
}

