/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.guis;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.client.guis.GuiHelper;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ModuleCountPair;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.network.PacketHandler;
import vswe.stevescarts.network.packets.PacketMinecartTurn;

public class GuiMinecart
extends AbstractContainerScreen<ContainerMinecart> {
    private static ResourceLocation textureLeft = ResourceHelper.getResource("/gui/guiBase1.png");
    private static ResourceLocation textureRight = ResourceHelper.getResource("/gui/guiBase2.png");
    private static ResourceLocation textureReturn = ResourceHelper.getResource("/gui/return.png");
    private boolean isScrolling;
    private final int[] scrollBox = new int[]{450, 15, 18, 225};
    private EntityMinecartModular cart;
    private final int[] returnButton = new int[]{324, 173, 24, 12};

    public GuiMinecart(ContainerMinecart containerMinecart, Inventory invPlayer, Component iTextComponent) {
        super((AbstractContainerMenu)containerMinecart, invPlayer, iTextComponent);
        this.setup(containerMinecart.cart);
    }

    protected void setup(EntityMinecartModular cart) {
        this.cart = cart;
        this.f_97726_ = 478;
        this.f_97727_ = 256;
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        if (this.cart == null) {
            return;
        }
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.drawModuleForeground(poseStack, thief);
                this.drawModuleMouseOver(poseStack, thief, mouseX, mouseY);
            } else {
                for (ModuleBase module : this.cart.getModules()) {
                    this.drawModuleForeground(poseStack, module);
                }
                this.renderModuleListText(poseStack, mouseX, mouseY);
                for (ModuleBase module : this.cart.getModules()) {
                    this.drawModuleMouseOver(poseStack, module, mouseX, mouseY);
                }
                this.renderModuleListMouseOver(poseStack, mouseX, mouseY);
                this.renderReturnMouseOver(poseStack, mouseX, mouseY);
            }
        }
    }

    protected void m_7286_(@NotNull PoseStack poseStack, float p_230450_2_, int mouseX, int mouseY) {
        block5: {
            int top;
            int left;
            block6: {
                left = this.getGuiLeft();
                top = this.getGuiTop();
                ResourceHelper.bindResource(textureLeft);
                this.m_93228_(poseStack, left, top, 0, 0, 256, 256);
                ResourceHelper.bindResource(textureRight);
                this.m_93228_(poseStack, left + 256, top, 0, 0, this.f_97726_ - 256, this.f_97727_);
                if (this.cart == null) break block5;
                ModuleBase thief = this.cart.getInterfaceThief();
                if (thief == null) break block6;
                this.drawModuleSlots(poseStack, thief);
                this.drawModuleBackground(poseStack, thief, mouseX, mouseY);
                this.drawModuleBackgroundItems(thief, mouseX, mouseY);
                for (ModuleBase module : this.cart.getModules()) {
                    if (!module.hasGui() || !module.hasSlots()) continue;
                    ArrayList<SlotBase> slotsList = module.getSlots();
                    for (SlotBase slot : slotsList) {
                        this.resetSlot(slot);
                    }
                }
                break block5;
            }
            if (this.cart.getModules() == null) break block5;
            this.m_93228_(poseStack, left + this.scrollBox[0], top + this.scrollBox[1], 222, 24, this.scrollBox[2], this.scrollBox[3]);
            this.m_93228_(poseStack, left + this.scrollBox[0] + 2, top + this.scrollBox[1] + 2 + this.cart.getScrollY(), 240, 26 + (this.cart.canScrollModules ? 0 : 25), 14, 25);
            for (ModuleBase module : this.cart.getModules()) {
                this.drawModuleSlots(poseStack, module);
            }
            for (ModuleBase module : this.cart.getModules()) {
                this.drawModuleBackground(poseStack, module, mouseX, mouseY);
            }
            this.renderModuleList(mouseX, mouseY);
            this.renderReturnButton(poseStack, mouseX, mouseY);
            for (ModuleBase module : this.cart.getModules()) {
                this.drawModuleBackgroundItems(module, mouseX, mouseY);
            }
        }
    }

    protected void m_7027_(@NotNull PoseStack poseStack, int p_230451_2_, int p_230451_3_) {
    }

    private void renderModuleList(int x, int y) {
        ArrayList<ModuleCountPair> moduleCounts = this.cart.getModuleCounts();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            this.drawModuleIcon(count.getData(), this.getGuiLeft() + this.getModuleDisplayX(i), this.getGuiTop() + this.getModuleDisplayY(i), 1.0f, 1.0f, 0.0f, 0.0f);
        }
        GlStateManager.m_84519_();
    }

    private void renderReturnButton(PoseStack matrixStack, int x, int y) {
        ResourceHelper.bindResource(textureReturn);
        int uy = this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.returnButton) ? 12 : 0;
        this.m_93228_(matrixStack, this.returnButton[0] + this.getGuiLeft(), this.returnButton[1] + this.getGuiTop(), 0, uy, this.returnButton[2], this.returnButton[3]);
    }

    public void drawModuleIcon(ModuleData icon, int targetX, int targetY, float sizeX, float sizeY, float offsetX, float offsetY) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        itemRenderer.m_115123_(icon.getItemStack(), targetX, targetY);
        RenderSystem.m_69465_();
    }

    private void renderModuleListText(PoseStack matrixStack, int mouseX, int mouseY) {
        mouseX -= this.getGuiLeft();
        mouseY -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.getModuleCounts();
        this.f_96547_.m_92889_(matrixStack, this.cart.m_7755_(), (float)(this.getGuiLeft() + 5), (float)(this.getGuiTop() + 172), 0x404040);
        GlStateManager.m_84525_();
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            if (count.getCount() == 1) continue;
            int alpha = (int)((this.inRect(mouseX, mouseY, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16) ? 1.0f : 0.75f) * 256.0f);
            String str = String.valueOf(count.getCount());
            this.f_96547_.m_92750_(matrixStack, str, (float)(this.getGuiLeft() + this.getModuleDisplayX(i) + 16 - this.f_96547_.m_92895_(str)), (float)(this.getModuleDisplayY(i) + 8), 0xFFFFFF | alpha << 24);
        }
        GlStateManager.m_84519_();
    }

    private void renderModuleListMouseOver(PoseStack matrixStack, int x, int y) {
        x -= this.getGuiLeft();
        y -= this.getGuiTop();
        ArrayList<ModuleCountPair> moduleCounts = this.cart.getModuleCounts();
        for (int i = 0; i < moduleCounts.size(); ++i) {
            ModuleCountPair count = moduleCounts.get(i);
            if (!this.inRect(x, y, this.getModuleDisplayX(i), this.getModuleDisplayY(i), 16, 16)) continue;
            for (ModuleBase module : this.cart.getModules()) {
                if (module.getClass() != count.getData().getModuleClass()) continue;
                if (!module.hasExtraData()) break;
                count.setExtraData(module.writeExtraData());
                break;
            }
            this.drawMouseOver(matrixStack, count.toString(), x, y);
        }
    }

    public void drawMouseOver(PoseStack matrixStack, String str, int x, int y) {
        String[] split = str.split("\n");
        ArrayList<String> text = new ArrayList<String>(Arrays.asList(split));
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        for (String s : text) {
            list.add(Component.m_237113_((String)s));
        }
        this.m_169388_(matrixStack, list, Optional.empty(), this.getGuiLeft() + x, this.getGuiTop() + y);
    }

    private void renderReturnMouseOver(PoseStack matrixStack, int x, int y) {
        if (this.inRect(x -= this.getGuiLeft(), y -= this.getGuiTop(), this.returnButton)) {
            this.drawMouseOver(matrixStack, Localization.GUI.CART.RETURN.translate(new String[0]), x, y);
        }
    }

    private int getModuleDisplayX(int id) {
        return id % 8 * 18 + 7;
    }

    private int getModuleDisplayY(int id) {
        return id / 8 * 18 + 182;
    }

    public boolean m_6375_(double x, double y, int button) {
        ModuleBase thief = this.cart.getInterfaceThief();
        if (thief != null) {
            this.handleModuleMouseClicked(thief, (int)x, (int)y, button);
        } else if (this.cart.getModules() != null) {
            if (this.inRect((int)x - this.getGuiLeft(), (int)y - this.getGuiTop(), this.scrollBox[0], this.scrollBox[1], this.scrollBox[2], this.scrollBox[3])) {
                this.scrollToMouse(y);
                this.isScrolling = true;
                return true;
            }
            for (ModuleBase module : this.cart.getModules()) {
                this.handleModuleMouseClicked(module, (int)x, (int)y, button);
            }
            if (this.inRect((int)x - this.getGuiLeft(), (int)y - this.getGuiTop(), this.returnButton)) {
                PacketHandler.sendToServer(new PacketMinecartTurn(this.cart.m_19879_()));
            }
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        ModuleBase thief = this.cart.getInterfaceThief();
        if (thief != null) {
            this.handleModuleMouseReleased(thief, (int)x, (int)y, button);
        } else if (this.cart.getModules() != null) {
            for (ModuleBase module : this.cart.getModules()) {
                this.handleModuleMouseReleased(module, (int)x, (int)y, button);
            }
        }
        this.isScrolling = false;
        return super.m_6348_(x, y, button);
    }

    protected boolean inRect(int x, int y, int x1, int y1, int sizeX, int sizeY) {
        return x >= x1 && x <= x1 + sizeX && y >= y1 && y <= y1 + sizeY;
    }

    public boolean inRect(int x, int y, int[] coords) {
        return coords != null && x >= coords[0] && x < coords[0] + coords[2] && y >= coords[1] && y < coords[1] + coords[3];
    }

    public boolean m_7979_(double x, double y, int button, double moveX, double moveY) {
        if (super.m_7979_(x, y, button, moveX, moveY)) {
            return true;
        }
        if (this.isScrolling) {
            this.scrollToMouse(y);
            return true;
        }
        return false;
    }

    public void m_94757_(double x, double y) {
        super.m_94757_(x, y);
        if (this.isScrolling) {
            this.scrollToMouse(y);
        }
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.handleModuleMouseMoved(thief, (int)x, (int)y);
            } else {
                for (ModuleBase module : this.cart.getModules()) {
                    this.handleModuleMouseMoved(module, (int)x, (int)y);
                }
            }
        }
    }

    private void scrollToMouse(double mouseY) {
        int temp = (int)mouseY - this.getGuiTop() - 12 - (this.scrollBox[1] + 2);
        if (temp < 0) {
            temp = 0;
        } else if (temp > 198) {
            temp = 198;
        }
        this.cart.setScrollY(temp);
    }

    public boolean m_7933_(int p_231046_1_, int id, int p_231046_3_) {
        super.m_7933_(p_231046_1_, id, p_231046_3_);
        if (this.cart.getModules() != null) {
            ModuleBase thief = this.cart.getInterfaceThief();
            if (thief != null) {
                this.handleModuleKeyPress(thief, id, p_231046_3_);
            } else {
                for (ModuleBase module : this.cart.getModules()) {
                    this.handleModuleKeyPress(module, id, p_231046_3_);
                }
            }
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawModuleForeground(PoseStack matrixStack, ModuleBase module) {
        if (module.hasGui()) {
            module.drawForeground(matrixStack, this);
            if (module.useButtons()) {
                module.drawButtonText(matrixStack, this);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawModuleMouseOver(PoseStack matrixStack, ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawMouseOver(matrixStack, this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            if (module.useButtons()) {
                module.drawButtonOverlays(matrixStack, this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            }
        }
    }

    private void drawModuleSlots(PoseStack matrixStack, ModuleBase module) {
        if (module.hasGui() && module.hasSlots()) {
            ArrayList<SlotBase> slotsList = module.getSlots();
            for (SlotBase slot : slotsList) {
                boolean drawAll;
                int[] rect = new int[]{slot.getX() + 1, slot.getY() + 1, 16, 16};
                module.handleScroll(rect);
                boolean bl = drawAll = rect[3] == 16;
                if (drawAll) {
                    slot.f_40220_ = slot.getX() + module.getX() + 1;
                    slot.f_40221_ = slot.getY() + module.getY() + 1 - this.cart.getRealScrollY();
                } else {
                    this.resetSlot(slot);
                }
                module.drawImage(matrixStack, this, slot.getX(), slot.getY(), this.getXSize() - 256, 0, 18, 18);
                if (drawAll) continue;
                module.drawImage(matrixStack, this, slot.getX() + 1, slot.getY() + 1, this.getXSize() - 256 + 18, 1, 16, 16);
            }
        }
    }

    private void resetSlot(SlotBase slot) {
        slot.f_40220_ = -9001;
        slot.f_40221_ = -9001;
    }

    private void drawModuleBackground(PoseStack matrixStack, ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawBackground(matrixStack, this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            if (module.useButtons()) {
                module.drawButtons(matrixStack, this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
            }
        }
    }

    private void drawModuleBackgroundItems(ModuleBase module, int x, int y) {
        if (module.hasGui()) {
            module.drawBackgroundItems(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
        }
    }

    private void handleModuleMouseClicked(ModuleBase module, int x, int y, int button) {
        module.mouseClicked(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        if (module.useButtons()) {
            module.mouseClickedButton(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        }
    }

    private void handleModuleMouseReleased(ModuleBase module, int x, int y, int button) {
        module.mouseMovedOrUp(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
        module.mouseReleased(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), button);
    }

    private void handleModuleMouseMoved(ModuleBase module, int x, int y) {
        module.mouseMovedOrUp(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY(), -1);
        module.mouseMoved(this, x - this.getGuiLeft() - module.getX(), y - this.getGuiTop() - module.getY());
    }

    private void handleModuleKeyPress(ModuleBase module, int id, int extraInformation) {
        module.keyPress(this, id, extraInformation);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        super.m_6050_(mouseX, mouseY, amount);
        if (amount < 0.0) {
            amount = -1.0;
        }
        if (amount > 0.0) {
            amount = 1.0;
        }
        if (this.inRect((int)mouseX - this.getGuiLeft(), (int)mouseY - this.getGuiTop(), 0, 0, this.f_97726_, this.f_97727_)) {
            int moduleSize = this.cart.modularSpaceHeight;
            int scroll = this.cart.getScrollY() + (int)(-amount) * 4000 / (moduleSize - 168);
            scroll = Mth.m_14045_((int)scroll, (int)0, (int)198);
            this.cart.setScrollY(scroll);
        }
        return true;
    }

    public void pushScissor() {
        GuiHelper.pushGuiScissor(this.f_96541_, this.getGuiLeft() + 5, this.getGuiTop() + 4, 438.0, 164.0, this.f_96543_, this.f_96544_);
    }

    public void popScissor() {
        GuiHelper.popScissor();
    }

    public void drawTexturedModalRect(PoseStack matrixStack, int x, int y, int u, int v, int w, int h, RENDER_ROTATION rotation) {
        double[] pt3;
        double[] pt2;
        double[] pt1;
        float fw = 0.00390625f;
        float fy = 0.00390625f;
        double a = (float)u * 0.00390625f;
        double b = (float)(u + w) * 0.00390625f;
        double c = (float)(v + h) * 0.00390625f;
        double d = (float)v * 0.00390625f;
        double[] ptA = new double[]{a, c};
        double[] ptB = new double[]{b, c};
        double[] ptC = new double[]{b, d};
        double[] ptD = new double[]{a, d};
        double[] pt4 = switch (rotation) {
            default -> {
                pt1 = ptA;
                pt2 = ptB;
                pt3 = ptC;
                yield ptD;
            }
            case RENDER_ROTATION.ROTATE_90 -> {
                pt1 = ptB;
                pt2 = ptC;
                pt3 = ptD;
                yield ptA;
            }
            case RENDER_ROTATION.ROTATE_180 -> {
                pt1 = ptC;
                pt2 = ptD;
                pt3 = ptA;
                yield ptB;
            }
            case RENDER_ROTATION.ROTATE_270 -> {
                pt1 = ptD;
                pt2 = ptA;
                pt3 = ptB;
                yield ptC;
            }
            case RENDER_ROTATION.FLIP_HORIZONTAL -> {
                pt1 = ptB;
                pt2 = ptA;
                pt3 = ptD;
                yield ptC;
            }
            case RENDER_ROTATION.ROTATE_90_FLIP -> {
                pt1 = ptA;
                pt2 = ptD;
                pt3 = ptC;
                yield ptB;
            }
            case RENDER_ROTATION.FLIP_VERTICAL -> {
                pt1 = ptD;
                pt2 = ptC;
                pt3 = ptB;
                yield ptA;
            }
            case RENDER_ROTATION.ROTATE_270_FLIP -> {
                pt1 = ptC;
                pt2 = ptB;
                pt3 = ptA;
                yield ptD;
            }
        };
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buff = tessellator.m_85915_();
        buff.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float zLevel = 1.0f;
        buff.m_5483_((double)x, (double)(y + h), (double)zLevel).m_7421_((float)pt1[0], (float)pt1[1]).m_5752_();
        buff.m_5483_((double)(x + w), (double)(y + h), (double)zLevel).m_7421_((float)pt2[0], (float)pt2[1]).m_5752_();
        buff.m_5483_((double)(x + w), (double)y, (double)zLevel).m_7421_((float)pt3[0], (float)pt3[1]).m_5752_();
        buff.m_5483_((double)x, (double)y, (double)zLevel).m_7421_((float)pt4[0], (float)pt4[1]).m_5752_();
        tessellator.m_85914_();
    }

    public static enum RENDER_ROTATION {
        NORMAL,
        ROTATE_90,
        ROTATE_180,
        ROTATE_270,
        FLIP_HORIZONTAL,
        ROTATE_90_FLIP,
        FLIP_VERTICAL,
        ROTATE_270_FLIP;


        public RENDER_ROTATION getNextRotation() {
            switch (this) {
                default: {
                    return ROTATE_90;
                }
                case ROTATE_90: {
                    return ROTATE_180;
                }
                case ROTATE_180: {
                    return ROTATE_270;
                }
                case ROTATE_270: {
                    return NORMAL;
                }
                case FLIP_HORIZONTAL: {
                    return ROTATE_90_FLIP;
                }
                case ROTATE_90_FLIP: {
                    return FLIP_VERTICAL;
                }
                case FLIP_VERTICAL: {
                    return ROTATE_270_FLIP;
                }
                case ROTATE_270_FLIP: 
            }
            return FLIP_HORIZONTAL;
        }

        public RENDER_ROTATION getFlippedRotation() {
            switch (this) {
                default: {
                    return FLIP_HORIZONTAL;
                }
                case ROTATE_90: {
                    return ROTATE_90_FLIP;
                }
                case ROTATE_180: {
                    return FLIP_VERTICAL;
                }
                case ROTATE_270: {
                    return ROTATE_270_FLIP;
                }
                case FLIP_HORIZONTAL: {
                    return NORMAL;
                }
                case ROTATE_90_FLIP: {
                    return ROTATE_90;
                }
                case FLIP_VERTICAL: {
                    return ROTATE_180;
                }
                case ROTATE_270_FLIP: 
            }
            return ROTATE_270;
        }
    }
}

