/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.addons.ModuleLiquidSensors;

public class ModelLiquidSensors
extends ModelCartbase {
    private static ResourceLocation texture = ResourceHelper.getResource("/models/sensorModel.png");
    private int activeColour = 0;
    private ModelPart[] sensorLeft = new ModelPart[]{this.createSensor(false, 1), this.createSensor(false, 2), this.createSensor(false, 3)};
    private ModelPart[] sensorRight = new ModelPart[]{this.createSensor(true, 1), this.createSensor(true, 2), this.createSensor(true, 3)};

    public ModelLiquidSensors() {
        super(null, texture);
    }

    private ModelPart createSensor(boolean right, int colour) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition base = modelPartData.m_171599_("base", CubeListBuilder.m_171558_().m_171481_(-0.5f, 2.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171419_((float)-9.0f, (float)-11.0f, (float)(right ? 7.0f : -7.0f)));
        PartDefinition head = base.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(4, 0).m_171481_(-3.0f, -2.0f, -3.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)1.0f, (float)0.0f, (float)1.0f));
        PartDefinition face = head.m_171599_("face", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171481_(-1.5f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-2.5f, (float)0.0f, (float)0.0f));
        PartDefinition light = head.m_171599_("light_" + colour, CubeListBuilder.m_171558_().m_171514_(20, 1 + colour * 3).m_171481_(-2.0f, -0.5f, -2.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.5f, (float)0.0f));
        return base.m_171583_(32, 16);
    }

    @Override
    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumers, int light, int overlay, float red, float green, float blue, float alpha) {
        this.sensorLeft[this.activeColour].m_104306_(poseStack, vertexConsumers, light, overlay, red, green, blue, alpha);
        this.sensorRight[this.activeColour].m_104306_(poseStack, vertexConsumers, light, overlay, red, green, blue, alpha);
    }

    @Override
    public void applyEffects(ModuleBase module, PoseStack matrixStack, MultiBufferSource rtb, float yaw, float pitch, float roll) {
        this.sensorLeft[this.activeColour].f_104204_ = module == null ? 0.0f : -((ModuleLiquidSensors)module).getSensorRotation();
        this.sensorRight[this.activeColour].f_104204_ = module == null ? 0.0f : ((ModuleLiquidSensors)module).getSensorRotation();
        this.activeColour = (module == null ? 2 : ((ModuleLiquidSensors)module).getLight()) - 1;
    }
}

