/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.api.client.ModelCartbase;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.EntityMinecartModular;

public class RenderModulerCart
extends EntityRenderer<EntityMinecartModular> {
    public RenderModulerCart(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EntityMinecartModular entity, float yaw, float tickDelta, @NotNull PoseStack poseStack, @NotNull MultiBufferSource vertexConsumers, int light) {
        boolean flip;
        if (entity.m_20145_()) {
            return;
        }
        super.m_7392_((Entity)entity, yaw, tickDelta, poseStack, vertexConsumers, light);
        poseStack.m_85836_();
        long l = (long)entity.m_19879_() * 493286711L;
        l = l * l * 4392167121L + l * 98761L;
        float h = (((float)(l >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float j = (((float)(l >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float k = (((float)(l >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.m_85837_((double)h, (double)j, (double)k);
        double renderX = Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_());
        double renderY = Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_());
        double renderZ = Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_());
        double offset = 0.3f;
        Vec3 vec3 = entity.m_38179_(renderX, renderY, renderZ);
        float pitch = Mth.m_14179_((float)tickDelta, (float)entity.f_19860_, (float)entity.m_146909_());
        if (vec3 != null) {
            Vec3 vec3d2 = entity.m_38096_(renderX, renderY, renderZ, offset);
            Vec3 vec3d3 = entity.m_38096_(renderX, renderY, renderZ, -offset);
            if (vec3d2 == null) {
                vec3d2 = vec3;
            }
            if (vec3d3 == null) {
                vec3d3 = vec3;
            }
            poseStack.m_85837_(vec3.f_82479_ - renderX, (vec3d2.f_82480_ + vec3d3.f_82480_) / 2.0 - renderY, vec3.f_82481_ - renderZ);
            Vec3 vec3d4 = vec3d3.m_82520_(-vec3d2.f_82479_, -vec3d2.f_82480_, -vec3d2.f_82481_);
            if (vec3d4.m_82553_() != 0.0) {
                vec3d4 = vec3d4.m_82541_();
                yaw = (float)(Math.atan2(vec3d4.f_82481_, vec3d4.f_82479_) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(vec3d4.f_82480_) * 73.0);
            }
        }
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        yaw += 360.0f;
        double rotationYaw = (entity.m_146908_() + 180.0f) % 360.0f;
        if (rotationYaw < 0.0) {
            rotationYaw += 360.0;
        }
        if (Math.abs((double)yaw - (rotationYaw += 360.0)) > 90.0) {
            pitch = -pitch;
        }
        boolean bl = flip = entity.m_20184_().f_82479_ > 0.0 != entity.m_20184_().f_82481_ > 0.0;
        if (entity.cornerFlip) {
            flip = !flip;
        }
        if (entity.getRenderFlippedYaw(yaw + (flip ? 0.0f : 180.0f))) {
            flip = !flip;
        }
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yaw));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-pitch));
        float damageWobbleTicks = (float)entity.m_38176_() - tickDelta;
        float damageWobbleStrength = Mth.m_14036_((float)(entity.m_38169_() - tickDelta), (float)0.0f, (float)Float.MAX_VALUE);
        if (damageWobbleTicks > 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)damageWobbleTicks) * damageWobbleTicks * damageWobbleStrength / 10.0f * (float)entity.m_38177_()));
        }
        yaw += flip ? 0.0f : 180.0f;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(flip ? 0.0f : 180.0f));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        if (entity.getModules() != null) {
            for (ModuleBase module : entity.getModules()) {
                if (!module.haveModels()) continue;
                for (ModelCartbase model : module.getModels()) {
                    if (model.getRenderType(module) == null) continue;
                    model.applyEffects(module, poseStack, vertexConsumers, yaw, pitch, 0.0f);
                    model.m_7695_(poseStack, vertexConsumers.m_6299_(model.getRenderType(module)), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
        poseStack.m_85849_();
        this.renderLabels(entity, poseStack, vertexConsumers, light);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityMinecartModular p_114482_) {
        return new ResourceLocation("textures/entity/minecart.png");
    }

    protected void renderLabels(EntityMinecartModular cart, PoseStack poseStack, MultiBufferSource bufferSource, int p_114502_) {
        ArrayList<Component> labels = cart.getLabel();
        if (labels == null || this.f_114476_.m_114471_((Entity)cart) > 4096.0) {
            return;
        }
        float f = cart.m_20206_() + 1.5f;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)f, 0.0);
        poseStack.m_85845_(this.f_114476_.m_114470_());
        poseStack.m_85841_(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        Font font = this.m_114481_();
        int height = 0;
        for (int i = 0; i < labels.size(); ++i) {
            Component label = labels.get(i);
            float f2 = -font.m_92852_((FormattedText)label) / 2;
            font.m_92841_(label, f2, (float)height, 0x20FFFFFF, false, matrix4f, bufferSource, true, j, p_114502_);
            font.m_92841_(label, f2, (float)height, -1, false, matrix4f, bufferSource, false, 0, p_114502_);
            Objects.requireNonNull(font);
            height += 9;
        }
        poseStack.m_85849_();
    }
}

