/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.init.ModContainers;
import vswe.stevescarts.network.PacketHandler;
import vswe.stevescarts.network.packets.PacketFluidSync;
import vswe.stevescarts.upgrades.InventoryEffect;

public class ContainerUpgrade
extends ContainerBase {
    private TileEntityUpgrade upgrade;
    private SimpleContainerData data;
    private FluidStack lastFluid = FluidStack.EMPTY;

    public ContainerUpgrade(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (TileEntityUpgrade)Objects.requireNonNull(Minecraft.m_91087_().f_91073_.m_7702_(packetBuffer.m_130135_())), new SimpleContainerData(7));
    }

    public ContainerUpgrade(int containerID, Inventory invPlayer, TileEntityUpgrade upgrade, SimpleContainerData data) {
        super((MenuType)ModContainers.CONTAINER_UPGRADE.get(), containerID);
        this.upgrade = upgrade;
        if (upgrade.getUpgrade() == null) {
            return;
        }
        if (upgrade.getUpgrade().getInventoryEffect() != null) {
            try {
                InventoryEffect inventory = upgrade.getUpgrade().getInventoryEffect();
                inventory.clear();
                for (int id = 0; id < inventory.getInventorySize(); ++id) {
                    Slot slot = inventory.createSlot(upgrade, id);
                    this.m_38897_(slot);
                    inventory.addSlot(slot);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)invPlayer, k + i * 9 + 9, this.offsetX() + k * 18, i * 18 + this.offsetY()));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)invPlayer, j, this.offsetX() + j * 18, 58 + this.offsetY()));
        }
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.lastFluid.equals((Object)this.upgrade.tank.getFluid()) || this.lastFluid.getAmount() != this.upgrade.tank.getFluid().getAmount()) {
            this.lastFluid = this.upgrade.tank.getFluid().copy();
            PacketHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.upgrade.m_58904_().m_46745_(this.upgrade.m_58899_())), new PacketFluidSync(this.lastFluid, this.upgrade.m_58899_(), 0));
        }
    }

    public TileEntityUpgrade getUpgrade() {
        return this.upgrade;
    }

    protected int offsetX() {
        return 48;
    }

    protected int offsetY() {
        return 108;
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }
}

