/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.containers.slots;

import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import vswe.stevescarts.api.modules.ModuleType;
import vswe.stevescarts.api.modules.data.ModuleData;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.items.ItemCarts;

public class SlotAssembler
extends Slot {
    private final ModuleType moduleType;
    private final int xPos;
    private final int yPos;
    private final TileEntityCartAssembler assembler;
    private int openingAnimation;
    private final int id;
    private boolean isValid;
    private final boolean useLarge;

    public SlotAssembler(TileEntityCartAssembler assembler, int i, int j, int k, ModuleType moduleType, boolean useLarge, int id) {
        super((Container)assembler, i, j, k);
        this.assembler = assembler;
        this.useLarge = useLarge;
        this.moduleType = moduleType;
        this.xPos = j;
        this.yPos = k;
        this.isValid = true;
        this.id = id;
    }

    private void invalidationCheck() {
        this.f_40220_ = -3000;
        this.f_40221_ = -3000;
        if (this.openingAnimation > 8) {
            this.openingAnimation = 8;
        }
    }

    public void update() {
        if (this.assembler.m_58904_() == null) {
            return;
        }
        if (!this.assembler.m_58904_().f_46443_) {
            if (!this.isValid() && this.m_6657_()) {
                this.assembler.puke(this.m_7993_());
                this.m_5852_(ItemStack.f_41583_);
            }
        } else if (this.isValid()) {
            if (this.openingAnimation == 8) {
                this.f_40220_ = this.getX();
                this.f_40221_ = this.getY();
                ++this.openingAnimation;
            } else if (this.openingAnimation < 8) {
                ++this.openingAnimation;
            }
        } else {
            this.openingAnimation = this.openingAnimation > 0 ? --this.openingAnimation : this.id * -3;
        }
    }

    public void m_6654_() {
        super.m_6654_();
        if (this.shouldUpdatePlaceholder()) {
            this.assembler.updatePlaceholder();
        } else {
            this.assembler.isErrorListOutdated = true;
        }
    }

    public boolean useLargeInterface() {
        return this.useLarge;
    }

    public boolean m_5857_(@Nonnull ItemStack itemstack) {
        return this.isValid && ModuleData.isValidModuleItem(this.moduleType, itemstack);
    }

    public void invalidate() {
        this.isValid = false;
        this.invalidationCheck();
    }

    public int m_6641_() {
        return 1;
    }

    public void validate() {
        this.isValid = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getAnimationTick() {
        return this.openingAnimation;
    }

    public int getX() {
        return this.xPos;
    }

    public int getY() {
        return this.yPos;
    }

    public TileEntityCartAssembler getAssembler() {
        return this.assembler;
    }

    public boolean shouldUpdatePlaceholder() {
        return true;
    }

    public boolean m_8010_(Player player) {
        if (this.m_7993_().m_41720_() instanceof ItemCarts && this.assembler.getIsAssembling()) {
            return false;
        }
        return !this.m_7993_().m_41619_() && (!this.m_7993_().m_41782_() || !this.m_7993_().m_41783_().m_128441_("ModifyStatus") || this.m_7993_().m_41783_().m_128451_("ModifyStatus") > 0);
    }
}

