/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.engines;

import com.mojang.blaze3d.vertex.PoseStack;
import net.creeperhost.polylib.helpers.FuelHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotFuel;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;

public abstract class ModuleCoalBase
extends ModuleEngine {
    private int fireCoolDown;
    private int fireIndex;
    private EntityDataAccessor<Integer> PRIORITY;

    public ModuleCoalBase(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    protected EntityDataAccessor<Integer> getPriorityDw() {
        return this.PRIORITY;
    }

    @Override
    public void initDw() {
        this.PRIORITY = this.createDw(EntityDataSerializers.f_135028_);
        super.initDw();
    }

    @Override
    protected void loadFuel() {
        int consumption = this.getCart().getConsumption(true) * 2;
        if (this.getFuelLevel() <= consumption) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                this.setFuelLevel(this.getFuelLevel() + FuelHelper.getItemBurnTime((ItemStack)this.getStack(i)));
                if (this.getFuelLevel() <= consumption) continue;
                if (this.getStack(i).m_41619_()) break;
                if (this.getStack(i).hasCraftingRemainingItem()) {
                    this.setStack(i, new ItemStack((ItemLike)this.getStack(i).m_41720_().m_41469_()));
                } else {
                    ItemStack stack = this.getStack(i);
                    stack.m_41774_(1);
                }
                if (this.getStack(i).m_41613_() != 0) break;
                this.setStack(i, ItemStack.f_41583_);
                break;
            }
        }
    }

    @Override
    public int getTotalFuel() {
        int totalfuel = this.getFuelLevel();
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i).m_41619_()) continue;
            totalfuel += FuelHelper.getItemBurnTime((ItemStack)this.getStack(i)) * this.getStack(i).m_41613_();
        }
        return totalfuel;
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    @Override
    public void smoke() {
        Direction smokeSide = this.getCart().m_6374_().m_122424_();
        double oX = smokeSide.m_122429_();
        double oZ = smokeSide.m_122431_();
        if (this.getCart().f_19796_.m_188503_(2) == 0) {
            this.getCart().f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.getCart().m_20185_() + oX * 0.85, this.getCart().m_20186_() + 0.12, this.getCart().m_20189_() + oZ * 0.85, 0.0, 0.0, 0.0);
        }
        if (this.getCart().f_19796_.m_188503_(30) == 0) {
            this.getCart().f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.getCart().m_20185_() + oX * 0.75, this.getCart().m_20186_() + 0.15, this.getCart().m_20189_() + oZ * 0.75, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotFuel(this.getCart(), slotId, 8 + x * 18, 23 + 18 * y);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, Localization.MODULES.ENGINES.COAL.translate(new String[0]), 8, 6, 0x404040);
        Object strfuel = Localization.MODULES.ENGINES.NO_FUEL.translate(new String[0]);
        if (this.getFuelLevel() > 0) {
            strfuel = "Fuel: " + this.getFuelLevel();
        }
        this.drawString(matrixStack, gui, (String)strfuel, 8, 48, 0x404040);
    }

    @Override
    public int numberOfGuiData() {
        return 1;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.getFuelLevel());
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.setFuelLevel(data);
            if (this.getFuelLevel() < 0) {
                this.setFuelLevel(this.getFuelLevel() + 65536);
            }
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.fireCoolDown <= 0) {
            this.fireIndex = this.getCart().f_19796_.m_188503_(4) + 1;
            this.fireCoolDown = 2;
        } else {
            --this.fireCoolDown;
        }
    }

    public int getFireIndex() {
        if (this.getCart().isEngineBurning()) {
            return this.fireIndex;
        }
        return 0;
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.m_128376_(this.generateNBTName("Fuel", id), (short)this.getFuelLevel());
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setFuelLevel(tagCompound.m_128448_(this.generateNBTName("Fuel", id)));
        if (this.getFuelLevel() < 0) {
            this.setFuelLevel(this.getFuelLevel() + 65536);
        }
    }

    public abstract double getFuelMultiplier();
}

