/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.engines;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.IFluidHandler;
import vswe.stevescarts.api.modules.template.ModuleEngine;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;

public abstract class ModuleThermalBase
extends ModuleEngine {
    private short coolantLevel;
    private static final int RELOAD_LIQUID_SIZE = 1;
    private EntityDataAccessor<Integer> PRIORITY;

    public ModuleThermalBase(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    protected EntityDataAccessor<Integer> getPriorityDw() {
        return this.PRIORITY;
    }

    @Override
    public void initDw() {
        this.PRIORITY = this.createDw(EntityDataSerializers.f_135028_);
        super.initDw();
    }

    private int getCoolantLevel() {
        return this.coolantLevel;
    }

    private void setCoolantLevel(int val) {
        this.coolantLevel = (short)val;
    }

    @Override
    protected void initPriorityButton() {
        this.priorityButton = new int[]{72, 17, 16, 16};
    }

    protected abstract int getEfficiency();

    protected abstract int getCoolantEfficiency();

    private boolean requiresCoolant() {
        return this.getCoolantEfficiency() > 0;
    }

    @Override
    public int guiHeight() {
        return 40;
    }

    @Override
    public boolean hasFuel(int consumption) {
        return super.hasFuel(consumption) && (!this.requiresCoolant() || this.getCoolantLevel() >= consumption);
    }

    @Override
    public void consumeFuel(int consumption) {
        super.consumeFuel(consumption);
        this.setCoolantLevel(this.getCoolantLevel() - consumption);
    }

    @Override
    protected void loadFuel() {
        int amount;
        int consumption = this.getCart().getConsumption(true) * 2;
        while (this.getFuelLevel() <= consumption && (amount = this.getCart().drain((Fluid)Fluids.f_76195_, 1, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            this.getCart().drain((Fluid)Fluids.f_76195_, amount, IFluidHandler.FluidAction.EXECUTE);
            this.setFuelLevel(this.getFuelLevel() + amount * this.getEfficiency());
        }
        while (this.requiresCoolant() && this.getCoolantLevel() <= consumption && (amount = this.getCart().drain((Fluid)Fluids.f_76193_, 1, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            this.getCart().drain((Fluid)Fluids.f_76193_, amount, IFluidHandler.FluidAction.EXECUTE);
            this.setCoolantLevel(this.getCoolantLevel() + amount * this.getCoolantEfficiency());
        }
    }

    @Override
    public int getTotalFuel() {
        int totalfuel = this.getFuelLevel() + this.getCart().drain((Fluid)Fluids.f_76195_, Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) * this.getEfficiency();
        if (this.requiresCoolant()) {
            int totalcoolant = this.getCoolantLevel() + this.getCart().drain((Fluid)Fluids.f_76193_, Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE) * this.getCoolantEfficiency();
            return Math.min(totalcoolant, totalfuel);
        }
        return totalfuel;
    }

    @Override
    public float[] getGuiBarColor() {
        return new float[]{1.0f, 0.0f, 0.0f};
    }

    @Override
    public void smoke() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, Localization.MODULES.ENGINES.THERMAL.translate(new String[0]), 8, 6, 0x404040);
        int consumption = this.getCart().getConsumption();
        if (consumption == 0) {
            consumption = 1;
        }
        String str = this.getFuelLevel() >= consumption && (!this.requiresCoolant() || this.getCoolantLevel() >= consumption) ? Localization.MODULES.ENGINES.POWERED.translate(new String[0]) : (this.getFuelLevel() >= consumption ? Localization.MODULES.ENGINES.NO_WATER.translate(new String[0]) : Localization.MODULES.ENGINES.NO_LAVA.translate(new String[0]));
        this.drawString(matrixStack, gui, str, 8, 22, 0x404040);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        this.updateGuiData(info, 0, (short)this.getFuelLevel());
        if (this.requiresCoolant()) {
            this.updateGuiData(info, 1, (short)this.getCoolantLevel());
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.setFuelLevel(data);
        } else if (id == 1) {
            this.setCoolantLevel(data);
        }
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.m_128376_(this.generateNBTName("Fuel", id), (short)this.getFuelLevel());
        if (this.requiresCoolant()) {
            tagCompound.m_128376_(this.generateNBTName("Coolant", id), (short)this.getCoolantLevel());
        }
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setFuelLevel(tagCompound.m_128448_(this.generateNBTName("Fuel", id)));
        if (this.requiresCoolant()) {
            this.setCoolantLevel(tagCompound.m_128448_(this.generateNBTName("Coolant", id)));
        }
    }
}

