/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.arcade.ArcadeGame;
import vswe.stevescarts.arcade.invaders.ArcadeInvaders;
import vswe.stevescarts.arcade.sweeper.ArcadeSweeper;
import vswe.stevescarts.arcade.tetris.ArcadeTetris;
import vswe.stevescarts.arcade.tracks.ArcadeTracks;
import vswe.stevescarts.arcade.tracks.TrackStory;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.ResourceHelper;

public class ModuleArcade
extends ModuleBase {
    private ArrayList<ArcadeGame> games = new ArrayList<ArcadeTracks>();
    private ArcadeGame currentGame;
    private int afkTimer;

    public ModuleArcade(EntityMinecartModular cart) {
        super(cart);
        this.games.add(new ArcadeTracks(this));
        this.games.add(new ArcadeTetris(this));
        this.games.add(new ArcadeInvaders(this));
        this.games.add(new ArcadeSweeper(this));
    }

    private boolean isGameActive() {
        return this.getCart().f_19853_.f_46443_ && this.currentGame != null;
    }

    @Override
    public boolean doStealInterface() {
        return this.isGameActive();
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 190;
    }

    @Override
    public int guiHeight() {
        return 115;
    }

    @Override
    public void update() {
        if (this.isGameActive() && this.afkTimer < 10) {
            this.currentGame.update();
            ++this.afkTimer;
        }
    }

    @Override
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        if (this.isGameActive()) {
            this.currentGame.drawForeground(matrixStack, gui);
        } else {
            this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
            for (int i = 0; i < this.games.size(); ++i) {
                int[] text = this.getButtonTextArea(i);
                if (text[3] != 8) continue;
                this.drawString(matrixStack, gui, this.games.get(i).getName(), text[0], text[1], 0x404040);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/arcade.png");
        this.afkTimer = 0;
        if (this.isGameActive()) {
            int[] rect = this.getExitArea();
            boolean srcX = false;
            int srcY = 104 + (this.inRect(x, y, rect) ? 16 : 0);
            this.drawImage(matrixStack, gui, rect, 0, srcY);
            this.currentGame.drawBackground(matrixStack, gui, x, y);
        } else {
            int[] rect = this.getListArea();
            this.drawImage(matrixStack, gui, rect, 0, 0);
            for (int i = 0; i < this.games.size(); ++i) {
                int[] button = this.getButtonGraphicArea(i);
                boolean srcX2 = false;
                int srcY2 = 136 + (this.inRect(x, y, this.getButtonBoundsArea(i)) ? button[3] : 0);
                if (button[3] <= 0) continue;
                this.drawImage(matrixStack, gui, button, 0, srcY2);
                int[] icon = this.getButtonIconArea(i);
                this.drawImage(matrixStack, gui, icon, i * 16, rect[3]);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        if (this.isGameActive()) {
            this.drawStringOnMouseOver(matrixStack, gui, "Exit", x, y, this.getExitArea());
            this.currentGame.drawMouseOver(matrixStack, gui, x, y);
        }
    }

    private int[] getExitArea() {
        return new int[]{455, 6, 16, 16};
    }

    private int[] getListArea() {
        return new int[]{15, 20, 170, 88};
    }

    private int[] getButtonBoundsArea(int i) {
        return this.getButtonArea(i, false);
    }

    private int[] getButtonGraphicArea(int i) {
        return this.getButtonArea(i, true);
    }

    private int[] getButtonArea(int i, boolean graphic) {
        int[] list = this.getListArea();
        return new int[]{list[0] + 2, list[1] + 2 + i * 21, 166, graphic ? 21 : 20};
    }

    private int[] getButtonTextArea(int i) {
        int[] button = this.getButtonGraphicArea(i);
        return new int[]{button[0] + 24, button[1] + 6, button[2], 8};
    }

    private int[] getButtonIconArea(int i) {
        int[] button = this.getButtonGraphicArea(i);
        return new int[]{button[0] + 2, button[1] + 2, 16, 16};
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (this.isGameActive()) {
            if (button == 0 && this.inRect(x, y, this.getExitArea())) {
                this.currentGame.unload(gui);
                this.currentGame = null;
            } else {
                this.currentGame.mouseClicked(gui, x, y, button);
            }
        } else if (button == 0) {
            for (int i = 0; i < this.games.size(); ++i) {
                if (!this.inRect(x, y, this.getButtonBoundsArea(i))) continue;
                this.currentGame = this.games.get(i);
                this.currentGame.load(gui);
                break;
            }
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.isGameActive()) {
            this.currentGame.mouseMovedOrUp(gui, x, y, button);
        }
    }

    @Override
    public void keyPress(GuiMinecart gui, int id, int extraInformation) {
        if (this.isGameActive()) {
            this.currentGame.keyPress(gui, id, extraInformation);
        }
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        for (ArcadeGame game : this.games) {
            game.Save(tagCompound, id);
        }
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        for (ArcadeGame game : this.games) {
            game.Load(tagCompound, id);
        }
    }

    @Override
    public int numberOfPackets() {
        return 4;
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        for (ArcadeGame game : this.games) {
            game.receivePacket(id, data, player);
        }
    }

    @Override
    public int numberOfGuiData() {
        return TrackStory.stories.size() + 5;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        for (ArcadeGame game : this.games) {
            game.checkGuiData(info);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        for (ArcadeGame game : this.games) {
            game.receiveGuiData(id, data);
        }
    }

    @Override
    public boolean disableStandardKeyFunctionality() {
        return this.currentGame != null && this.currentGame.disableStandardKeyFunctionality();
    }
}

