/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotCake;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;

public class ModuleCakeServer
extends ModuleBase
implements ISuppliesModule {
    private int cooldown = 0;
    private static final int MAX_CAKES = 10;
    private static final int SLICES_PER_CAKE = 6;
    private static final int MAX_TOTAL_SLICES = 66;
    private int[] rect = new int[]{40, 20, 13, 36};
    private EntityDataAccessor<Integer> BUFFER;

    public ModuleCakeServer(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().f_19853_.f_46443_) {
            ItemStack item;
            if (this.getCart().hasCreativeSupplies()) {
                if (this.cooldown >= 20) {
                    if (this.getCakeBuffer() < 66) {
                        this.setCakeBuffer(this.getCakeBuffer() + 1);
                    }
                    this.cooldown = 0;
                } else {
                    ++this.cooldown;
                }
            }
            if (!(item = this.getStack(0)).m_41619_() && item.m_41720_().equals(Items.f_42502_) && this.getCakeBuffer() + 6 <= 66) {
                this.setCakeBuffer(this.getCakeBuffer() + 6);
                this.setStack(0, ItemStack.f_41583_);
            }
        }
    }

    private void setCakeBuffer(int i) {
        this.updateDw(this.BUFFER, i);
    }

    private int getCakeBuffer() {
        if (this.isPlaceholder()) {
            return 6;
        }
        return this.getDw(this.BUFFER);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.BUFFER = this.createDw(EntityDataSerializers.f_135028_);
        this.registerDw(this.BUFFER, 0);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected int getInventoryWidth() {
        return 1;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotCake(this.getCart(), slotId, 8 + x * 18, 38 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, Localization.MODULES.ATTACHMENTS.CAKE_SERVER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        tagCompound.m_128376_(this.generateNBTName("Cake", id), (short)this.getCakeBuffer());
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.setCakeBuffer(tagCompound.m_128448_(this.generateNBTName("Cake", id)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(matrixStack, gui, Localization.MODULES.ATTACHMENTS.CAKES.translate(String.valueOf(this.getCakes()), String.valueOf(10)) + "\n" + Localization.MODULES.ATTACHMENTS.SLICES.translate(String.valueOf(this.getSlices()), String.valueOf(6)), x, y, this.rect);
    }

    private int getCakes() {
        if (this.getCakeBuffer() == 66) {
            return 10;
        }
        return this.getCakeBuffer() / 6;
    }

    private int getSlices() {
        if (this.getCakeBuffer() == 66) {
            return 6;
        }
        return this.getCakeBuffer() % 6;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/cake.png");
        this.drawImage(matrixStack, gui, this.rect, 0, this.inRect(x, y, this.rect) ? this.rect[3] : 0);
        int maxHeight = this.rect[3] - 2;
        int height = (int)((float)this.getCakes() / 10.0f * (float)maxHeight);
        if (height > 0) {
            this.drawImage(matrixStack, gui, this.rect[0] + 1, this.rect[1] + 1 + maxHeight - height, this.rect[2], maxHeight - height, 7, height);
        }
        if ((height = (int)((float)this.getSlices() / 6.0f * (float)maxHeight)) > 0) {
            this.drawImage(matrixStack, gui, this.rect[0] + 9, this.rect[1] + 1 + maxHeight - height, this.rect[2] + 7, maxHeight - height, 3, height);
        }
    }

    @Override
    public int guiWidth() {
        return 75;
    }

    @Override
    public int guiHeight() {
        return 60;
    }

    @Override
    public boolean onInteractFirst(Player entityplayer) {
        if (this.getCakeBuffer() > 0) {
            if (!this.getCart().f_19853_.f_46443_ && entityplayer.m_36391_(false)) {
                this.setCakeBuffer(this.getCakeBuffer() - 1);
                entityplayer.m_36324_().m_38707_(2, 0.1f);
            }
            return true;
        }
        return false;
    }

    public int getRenderSliceCount() {
        int count = this.getSlices();
        if (count == 0 && this.getCakes() > 0) {
            count = 6;
        }
        return count;
    }

    @Override
    public boolean haveSupplies() {
        return this.getCakeBuffer() > 0;
    }
}

