/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RailBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidBlock;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotBridge;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.modules.workers.ModuleWorker;

public class ModuleBridge
extends ModuleWorker
implements ISuppliesModule {
    private EntityDataAccessor<Boolean> BRIDGE;

    public ModuleBridge(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotBridge(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 98;
    }

    @Override
    public boolean work() {
        Level world = this.getCart().f_19853_;
        BlockPos next = this.getNextblock();
        if (this.getCart().getYTarget() < next.m_123342_()) {
            next = next.m_6625_(2);
        } else if (this.getCart().getYTarget() == next.m_123342_()) {
            next = next.m_6625_(1);
        }
        if (!RailBlock.m_49364_((Level)world, (BlockPos)next) && !RailBlock.m_49364_((Level)world, (BlockPos)next.m_7495_())) {
            if (this.doPreWork()) {
                if (this.tryBuildBridge(world, next, false)) {
                    this.startWorking(22);
                    this.setBridge(true);
                    return true;
                }
            } else if (this.tryBuildBridge(world, next, true)) {
                this.stopWorking();
            }
        }
        this.setBridge(false);
        return false;
    }

    private boolean tryBuildBridge(Level world, BlockPos pos, boolean doPlace) {
        Block blockAtPos = world.m_8055_(pos).m_60734_();
        if ((this.countsAsAir(pos) || blockAtPos instanceof IFluidBlock) && this.isValidForTrack(pos.m_7494_(), false)) {
            for (int slot = 0; slot < this.getInventorySize(); ++slot) {
                ItemStack stack = this.getStack(slot);
                if (stack.m_41619_() || !SlotBridge.isBridgeMaterial(stack)) continue;
                if (doPlace) {
                    Block block = Block.m_49814_((Item)stack.m_41720_());
                    boolean placed = this.getCart().f_19853_.m_7731_(pos, block.m_49966_(), 3);
                    if (!placed) {
                        return false;
                    }
                    if (!this.getCart().hasCreativeSupplies()) {
                        stack.m_41774_(1);
                        if (this.getStack(slot).m_41613_() == 0) {
                            this.setStack(slot, ItemStack.f_41583_);
                        }
                        this.getCart().m_6596_();
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void initDw() {
        this.BRIDGE = this.createDw(EntityDataSerializers.f_135035_);
        this.registerDw(this.BRIDGE, false);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    private void setBridge(boolean val) {
        this.updateDw(this.BRIDGE, val);
    }

    public boolean needBridge() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getNeedBridge();
        }
        return this.getDw(this.BRIDGE);
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.m_41619_() || !SlotBridge.isBridgeMaterial(item)) continue;
            return true;
        }
        return false;
    }
}

