/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RailBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotBuilder;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.workers.ModuleWorker;

public class ModuleRailer
extends ModuleWorker
implements ISuppliesModule {
    private boolean hasGeneratedAngles = false;
    private float[] railAngles;
    private EntityDataAccessor<Byte> RAILS;

    public ModuleRailer(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotBuilder(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, Localization.MODULES.ATTACHMENTS.RAILER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 100;
    }

    @Override
    public boolean work() {
        BlockPos next = this.getNextblock();
        ArrayList<BlockPos> positions = this.getValidRailPositions(next);
        if (this.doPreWork()) {
            boolean foundValidPosition = false;
            for (BlockPos pos : positions) {
                if (!this.tryPlaceTrack(pos, false)) continue;
                foundValidPosition = true;
                break;
            }
            if (foundValidPosition) {
                this.startWorking(12);
            } else {
                boolean canContinue = false;
                for (BlockPos pos : positions) {
                    if (!RailBlock.m_49364_((Level)this.getCart().f_19853_, (BlockPos)pos)) continue;
                    canContinue = true;
                    break;
                }
                if (!canContinue) {
                    this.turnback();
                }
            }
            return true;
        }
        this.stopWorking();
        for (BlockPos position : positions) {
            if (this.tryPlaceTrack(position, true)) break;
        }
        return false;
    }

    protected ArrayList<BlockPos> getValidRailPositions(BlockPos pos) {
        ArrayList<BlockPos> lst = new ArrayList<BlockPos>();
        if (pos.m_123342_() >= this.getCart().y()) {
            lst.add(pos.m_7494_());
        }
        lst.add(pos);
        lst.add(pos.m_7495_());
        return lst;
    }

    protected boolean validRail(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        return stack.m_204117_(ItemTags.f_13142_);
    }

    private boolean tryPlaceTrack(BlockPos pos, boolean doPlace) {
        if (!this.isValidForTrack(pos, true)) {
            return false;
        }
        FakePlayer fakePlayer = this.getFakePlayer();
        for (int slot = 0; slot < this.getInventorySize(); ++slot) {
            ItemStack stack = this.getStack(slot);
            if (stack.m_41619_() || !this.validRail(stack.m_41720_())) continue;
            if (!fakePlayer.m_36204_(pos, Direction.DOWN, stack)) {
                return false;
            }
            if (doPlace) {
                Block block = Block.m_49814_((Item)stack.m_41720_());
                boolean placed = this.getCart().f_19853_.m_7731_(pos, block.m_49966_(), 3);
                if (!placed) {
                    return false;
                }
                if (!this.getCart().hasCreativeSupplies()) {
                    stack.m_41774_(1);
                    this.getCart().m_6596_();
                }
            }
            return true;
        }
        this.turnback();
        return true;
    }

    @Override
    public void initDw() {
        this.RAILS = this.createDw(EntityDataSerializers.f_135027_);
        this.registerDw(this.RAILS, (byte)0);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.calculateRails();
    }

    private void calculateRails() {
        if (this.getCart().f_19853_.f_46443_) {
            return;
        }
        byte valid = 0;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            if (this.getStack(i).m_41619_() || !this.validRail(this.getStack(i).m_41720_())) continue;
            valid = (byte)(valid + 1);
        }
        this.updateDw(this.RAILS, valid);
    }

    public int getRails() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getRailCount();
        }
        return this.getDw(this.RAILS).byteValue();
    }

    public float getRailAngle(int i) {
        if (!this.hasGeneratedAngles) {
            this.railAngles = new float[this.getInventorySize()];
            for (int j = 0; j < this.getInventorySize(); ++j) {
                this.railAngles[j] = this.getCart().f_19796_.m_188501_() / 2.0f - 0.25f;
            }
            this.hasGeneratedAngles = true;
        }
        return this.railAngles[i];
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        this.calculateRails();
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.m_41619_() || !this.validRail(item.m_41720_())) continue;
            return true;
        }
        return false;
    }
}

