/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.state.BlockState;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.modules.workers.ModuleWorker;

public class ModuleRemover
extends ModuleWorker
implements IActivatorModule {
    @Nonnull
    private BlockPos remove = new BlockPos(0, -1, 0);
    private EntityDataAccessor<Boolean> IS_ENABLED;

    public ModuleRemover(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public void initDw() {
        this.IS_ENABLED = this.createDw(EntityDataSerializers.f_135035_);
        this.registerDw(this.IS_ENABLED, true);
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public byte getWorkPriority() {
        return 120;
    }

    @Override
    protected boolean preventTurnback() {
        return true;
    }

    @Override
    public boolean work() {
        EntityMinecartModular cart = this.getCart();
        Level world = cart.f_19853_;
        if (this.remove.m_123342_() != -1 && (this.remove.m_123341_() != cart.x() || this.remove.m_123343_() != cart.z()) && this.removeRail(world, this.remove, true)) {
            return false;
        }
        BlockPos next = this.getNextblock();
        BlockPos last = this.getLastblock();
        boolean front = this.isRailAtCoords(world, next);
        boolean back = this.isRailAtCoords(world, last);
        if (!front) {
            if (back) {
                this.turnback();
                if (this.removeRail(world, cart.getExactPosition(), false)) {
                    return true;
                }
            }
        } else if (!back && this.removeRail(world, cart.getExactPosition(), false)) {
            return true;
        }
        return false;
    }

    private boolean isRailAtCoords(Level world, BlockPos coords) {
        return RailBlock.m_49364_((Level)world, (BlockPos)coords.m_7494_()) || RailBlock.m_49364_((Level)world, (BlockPos)coords) || RailBlock.m_49364_((Level)world, (BlockPos)coords.m_7495_());
    }

    private boolean removeRail(Level world, BlockPos pos, boolean flag) {
        if (flag) {
            BlockState blockState = world.m_8055_(pos);
            if (RailBlock.m_49416_((BlockState)blockState)) {
                if (this.isRemovingEnabled()) {
                    if (this.doPreWork()) {
                        this.startWorking(12);
                        return true;
                    }
                    ItemStack iStack = new ItemStack((ItemLike)blockState.m_60734_(), 1);
                    this.getCart().addItemToChest(iStack);
                    if (iStack.m_41613_() == 0) {
                        world.m_7471_(pos, false);
                    }
                }
                this.remove = new BlockPos(pos.m_123341_(), -1, pos.m_123343_());
            } else {
                this.remove = new BlockPos(pos.m_123341_(), -1, pos.m_123343_());
            }
        } else if (RailBlock.m_49364_((Level)world, (BlockPos)pos.m_7495_())) {
            this.remove = pos.m_7495_();
        } else if (RailBlock.m_49364_((Level)world, (BlockPos)pos)) {
            this.remove = pos;
        } else if (RailBlock.m_49364_((Level)world, (BlockPos)pos.m_7494_())) {
            this.remove = pos.m_7494_();
        }
        this.stopWorking();
        return false;
    }

    private void enableRemoving(boolean remove) {
        if (!this.isPlaceholder()) {
            this.updateDw(this.IS_ENABLED, remove);
        }
    }

    private boolean isRemovingEnabled() {
        return !this.isPlaceholder() && this.getDw(this.IS_ENABLED) != false;
    }

    @Override
    public void doActivate(int id) {
        this.enableRemoving(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.enableRemoving(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.isRemovingEnabled();
    }
}

