/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.fluids.IFluidBlock;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.EntityMinecartModular;

public abstract class ModuleWorker
extends ModuleBase {
    private boolean preWork = true;
    private boolean shouldDie;

    public ModuleWorker(EntityMinecartModular cart) {
        super(cart);
    }

    public abstract byte getWorkPriority();

    public abstract boolean work();

    public void startWorking(int time) {
        this.getCart().setWorkingTime(time);
        this.preWork = false;
        this.getCart().setWorker(this);
    }

    public void stopWorking() {
        if (this.getCart().getWorker() == this) {
            this.preWork = true;
            this.getCart().setWorker(null);
        }
    }

    public boolean preventAutoShutdown() {
        return false;
    }

    public void kill() {
        this.shouldDie = true;
    }

    public boolean isDead() {
        return this.shouldDie;
    }

    public void revive() {
        this.shouldDie = false;
    }

    protected boolean doPreWork() {
        return this.preWork;
    }

    public BlockPos getLastblock() {
        return this.getNextblock(false);
    }

    public BlockPos getNextblock() {
        return this.getNextblock(true);
    }

    private BlockPos getNextblock(boolean flag) {
        BlockState blockState;
        BlockPos pos = this.getCart().m_20183_();
        if (BaseRailBlock.m_49364_((Level)this.getCart().f_19853_, (BlockPos)pos.m_7495_())) {
            pos = pos.m_7495_();
        }
        if (BaseRailBlock.m_49416_((BlockState)(blockState = this.getCart().f_19853_.m_8055_(pos)))) {
            RailShape direction = ((BaseRailBlock)blockState.m_60734_()).getRailDirection(blockState, (BlockGetter)this.getCart().f_19853_, pos, (AbstractMinecart)this.getCart());
            if (direction.m_61745_()) {
                pos = pos.m_7494_();
            }
            int[][] logic = EntityMinecartModular.railDirectionCoordinates[direction.ordinal()];
            double pX = this.getCart().temppushX;
            double pZ = this.getCart().temppushZ;
            boolean xDir = pX > 0.0 && logic[0][0] > 0 || pX == 0.0 || logic[0][0] == 0 || pX < 0.0 && logic[0][0] < 0;
            boolean zDir = pZ > 0.0 && logic[0][2] > 0 || pZ == 0.0 || logic[0][2] == 0 || pZ < 0.0 && logic[0][2] < 0;
            int dir = (xDir && zDir) != flag ? 1 : 0;
            return pos.m_7918_(logic[dir][0], logic[dir][1], logic[dir][2]);
        }
        return pos;
    }

    @Override
    public float getMaxSpeed() {
        if (!this.doPreWork()) {
            return 0.0f;
        }
        return super.getMaxSpeed();
    }

    protected boolean isValidForTrack(BlockPos pos, boolean checkBellow) {
        boolean result;
        boolean bl = result = this.countsAsAir(pos) && (!checkBellow || Block.m_49936_((BlockGetter)this.getCart().f_19853_, (BlockPos)pos.m_7495_()));
        if (result) {
            int coordX = pos.m_123341_() - (this.getCart().x() - pos.m_123341_());
            int coordZ = pos.m_123343_() - (this.getCart().z() - pos.m_123343_());
            Block block = this.getCart().f_19853_.m_8055_(new BlockPos(coordX, pos.m_123342_(), coordZ)).m_60734_();
            boolean isWater = block == Blocks.f_49990_ || block == Blocks.f_50126_;
            boolean isLava = block == Blocks.f_49991_;
            boolean isOther = block instanceof IFluidBlock;
            boolean isLiquid = isWater || isLava || isOther;
            result = !isLiquid;
        }
        return result;
    }
}

