/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.creeperhost.polylib.helpers.LevelHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidBlock;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.IActivatorModule;
import vswe.stevescarts.api.modules.template.ModuleChest;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.init.ModBlocks;
import vswe.stevescarts.modules.addons.ModuleDrillIntelligence;
import vswe.stevescarts.modules.addons.ModuleHeightControl;
import vswe.stevescarts.modules.addons.ModuleIncinerator;
import vswe.stevescarts.modules.addons.ModuleLiquidSensors;
import vswe.stevescarts.modules.addons.ModuleOreTracker;
import vswe.stevescarts.modules.workers.tools.ModuleTool;

public abstract class ModuleDrill
extends ModuleTool
implements IActivatorModule {
    private ModuleDrillIntelligence intelligence;
    private ModuleLiquidSensors liquidsensors;
    private ModuleOreTracker tracker;
    private boolean hasHeightController;
    private byte sensorLight = 1;
    private float drillRotation;
    private int miningCoolDown;
    private int[] buttonRect = new int[]{15, 30, 24, 12};
    private boolean setup;
    private EntityDataAccessor<Boolean> IS_MINING;
    private EntityDataAccessor<Boolean> IS_ENABLED;

    public ModuleDrill(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 50;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ModuleDrillIntelligence) {
                this.intelligence = (ModuleDrillIntelligence)module;
            }
            if (module instanceof ModuleLiquidSensors) {
                this.liquidsensors = (ModuleLiquidSensors)module;
            }
            if (module instanceof ModuleOreTracker) {
                this.tracker = (ModuleOreTracker)module;
            }
            if (!(module instanceof ModuleHeightControl)) continue;
            this.hasHeightController = true;
        }
    }

    @Override
    public boolean work() {
        Level world = this.getCart().f_19853_;
        if (!this.isDrillEnabled()) {
            this.stopDrill();
            this.stopWorking();
            return false;
        }
        if (!this.doPreWork()) {
            this.stopDrill();
            this.stopWorking();
        }
        if (this.isBroken()) {
            return false;
        }
        BlockPos next = this.getNextblock();
        int[] range = this.mineRange();
        for (int holeY = range[1]; holeY >= range[0]; --holeY) {
            for (int holeX = -this.blocksOnSide(); holeX <= this.blocksOnSide(); ++holeX) {
                BlockPos mine;
                if (!this.isMiningSpotAllowed(next, holeX, holeY, range) || !this.mineBlockAndRevive(world, mine = next.m_7918_(this.getCart().z() != next.m_123343_() ? holeX : 0, holeY, this.getCart().x() != next.m_123341_() ? holeX : 0), next, holeX, holeY)) continue;
                return true;
            }
        }
        BlockPos pos = next.m_7918_(0, range[0], 0);
        if (LevelHelper.isAir((Level)this.getCart().f_19853_, (BlockPos)pos) && !this.isValidForTrack(pos, true) && this.mineBlockAndRevive(world, pos.m_7495_(), next, 0, range[0] - 1)) {
            return true;
        }
        this.stopWorking();
        this.stopDrill();
        return false;
    }

    private boolean isMiningSpotAllowed(BlockPos next, int holeX, int holeY, int[] range) {
        int maxHeight = (Integer)SCConfig.drillSize.get() * 2 + 1 - (this.hasHeightController ? (range[2] == 0 ? -1 : 1) : 0);
        if (Math.abs(holeX) <= (Integer)SCConfig.drillSize.get() && holeY <= maxHeight) {
            return this.intelligence == null || this.intelligence.isActive(holeX + this.blocksOnSide(), holeY, range[2], next.m_123341_() > this.getCart().x() || next.m_123343_() < this.getCart().z());
        }
        return false;
    }

    private int[] mineRange() {
        BlockPos next = this.getNextblock();
        int yTarget = this.getCart().getYTarget();
        if (BaseRailBlock.m_49364_((Level)this.getCart().f_19853_, (BlockPos)next) || BaseRailBlock.m_49364_((Level)this.getCart().f_19853_, (BlockPos)next.m_7495_())) {
            return new int[]{0, this.blocksOnTop() - 1, 1};
        }
        if (next.m_123342_() > yTarget) {
            return new int[]{-1, this.blocksOnTop() - 1, 1};
        }
        if (next.m_123342_() < yTarget) {
            return new int[]{1, this.blocksOnTop() + 1, 0};
        }
        return new int[]{0, this.blocksOnTop() - 1, 1};
    }

    protected abstract int blocksOnTop();

    protected abstract int blocksOnSide();

    public int getAreaWidth() {
        return this.blocksOnSide() * 2 + 1;
    }

    public int getAreaHeight() {
        return this.blocksOnTop();
    }

    private boolean mineBlockAndRevive(Level world, BlockPos coord, BlockPos next, int holeX, int holeY) {
        if (this.mineBlock(world, coord, next, holeX, holeY, false)) {
            return true;
        }
        if (this.isDead()) {
            this.revive();
            return true;
        }
        return false;
    }

    protected boolean mineBlock(Level world, BlockPos coord, BlockPos next, int holeX, int holeY, boolean flag) {
        List drops;
        BlockPos target;
        if (this.tracker != null && (target = this.tracker.findBlockToMine(this, coord)) != null) {
            coord = target;
        }
        Object valid = this.isValidBlock(world, coord, holeX, holeY, flag);
        BlockEntity storage = null;
        if (valid instanceof BlockEntity) {
            storage = (BlockEntity)valid;
        } else if (valid == null) {
            return false;
        }
        BlockState blockState = world.m_8055_(coord);
        Block block = blockState.m_60734_();
        float h = blockState.m_60800_((BlockGetter)world, coord);
        if (h < 0.0f) {
            h = 0.0f;
        }
        if (storage != null) {
            for (int i = 0; i < ((Container)storage).m_6643_(); ++i) {
                ItemStack iStack = ((Container)storage).m_8020_(i);
                if (iStack.m_41619_()) continue;
                if (!this.minedItem(world, iStack, next)) {
                    return false;
                }
                ((Container)storage).m_6836_(i, ItemStack.f_41583_);
            }
        }
        int fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
        ItemStack tool = new ItemStack((ItemLike)Items.f_42390_);
        if (fortune > 0) {
            tool.m_41663_(Enchantments.f_44987_, fortune);
        }
        if (!(drops = block.m_7381_(blockState, new LootContext.Builder((ServerLevel)world).m_78972_(LootContextParams.f_81463_, (Object)tool).m_78972_(LootContextParams.f_81460_, (Object)this.getCart().m_20182_()))).isEmpty()) {
            boolean shouldRemove = false;
            for (int j = 0; j < drops.size(); ++j) {
                if (!this.minedItem(world, (ItemStack)drops.get(j), next)) {
                    return false;
                }
                shouldRemove = true;
            }
            if (shouldRemove) {
                world.m_7471_(coord, false);
            }
        } else {
            world.m_7471_(coord, false);
        }
        this.damageTool(1 + (int)h);
        this.startWorking(this.getTimeToMine(h));
        this.startDrill();
        return true;
    }

    protected boolean minedItem(Level world, @Nonnull ItemStack iStack, BlockPos Coords) {
        ItemEntity entityitem;
        if (iStack.m_41619_() || iStack.m_41613_() <= 0) {
            return true;
        }
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleIncinerator)) continue;
            ((ModuleIncinerator)module).incinerate(iStack);
            if (iStack.m_41613_() > 0) continue;
            return true;
        }
        int size = iStack.m_41613_();
        this.getCart().addItemToChest(iStack);
        if (iStack.m_41613_() == 0) {
            return true;
        }
        boolean hasChest = false;
        for (ModuleBase module2 : this.getCart().getModules()) {
            if (!(module2 instanceof ModuleChest)) continue;
            hasChest = true;
            break;
        }
        if (!hasChest) {
            entityitem = new ItemEntity(world, (double)this.getCart().x(), (double)this.getCart().y(), (double)this.getCart().z(), iStack);
            world.m_7967_((Entity)entityitem);
            return true;
        }
        if (iStack.m_41613_() != size) {
            entityitem = new ItemEntity(world, (double)this.getCart().x(), (double)this.getCart().y(), (double)this.getCart().z(), iStack);
            world.m_7967_((Entity)entityitem);
            return true;
        }
        return false;
    }

    private int getTimeToMine(float hardness) {
        int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
        return (int)((double)(this.getTimeMult() * hardness) / Math.pow(1.3f, efficiency)) + (this.liquidsensors != null ? 2 : 0);
    }

    protected abstract float getTimeMult();

    public Object isValidBlock(Level world, BlockPos pos, int holeX, int holeY, boolean flag) {
        BlockEntity tileentity;
        if (!flag && BaseRailBlock.m_49364_((Level)world, (BlockPos)pos) || BaseRailBlock.m_49364_((Level)world, (BlockPos)pos.m_7494_())) {
            return null;
        }
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block == null) {
            return null;
        }
        if (block == Blocks.f_50016_) {
            return null;
        }
        if (block == Blocks.f_50752_) {
            return null;
        }
        if (block instanceof IFluidBlock) {
            return null;
        }
        if (blockState.m_60800_((BlockGetter)world, pos) < 0.0f) {
            return null;
        }
        if (!world.m_6425_(pos).m_76178_()) {
            return null;
        }
        if (!(holeX == 0 && holeY <= 0 || block != Blocks.f_50081_ && block != Blocks.f_50088_ && block != Blocks.f_50174_ && block != Blocks.f_50146_ && block != Blocks.f_50328_ && block != ModBlocks.MODULE_TOGGLER.get())) {
            return null;
        }
        if (block instanceof BaseEntityBlock && Container.class.isInstance(tileentity = world.m_7702_(pos))) {
            if (holeX != 0 || holeY > 0) {
                return null;
            }
            return tileentity;
        }
        if (this.liquidsensors != null) {
            if (this.liquidsensors.isDangerous(this, pos.m_7918_(0, 1, 0), true) || this.liquidsensors.isDangerous(this, pos.m_7918_(1, 0, 0), false) || this.liquidsensors.isDangerous(this, pos.m_7918_(-1, 0, 0), false) || this.liquidsensors.isDangerous(this, pos.m_7918_(0, 0, 1), false) || this.liquidsensors.isDangerous(this, pos.m_7918_(0, 0, -1), false)) {
                this.sensorLight = (byte)3;
                return null;
            }
            this.sensorLight = (byte)2;
        }
        return false;
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().f_19853_.f_46443_ && !this.setup) {
            if (this.isPlaceholder() || !this.getDw(this.IS_MINING).booleanValue()) {
                this.drillRotation = 0.0f;
                this.miningCoolDown = 10;
            }
            this.setup = true;
        }
        if (this.getCart().hasFuel() && this.isMining() || this.miningCoolDown < 10) {
            this.drillRotation = (float)((double)(this.drillRotation + 0.03f * (float)(10 - this.miningCoolDown)) % (Math.PI * 2));
            this.miningCoolDown = this.isMining() ? 0 : ++this.miningCoolDown;
        }
        if (!this.getCart().f_19853_.f_46443_ && this.liquidsensors != null) {
            byte data = this.sensorLight;
            if (this.isDrillSpinning()) {
                data = (byte)(data | 4);
            }
            this.liquidsensors.getInfoFromDrill(data);
            this.sensorLight = 1;
        }
    }

    protected void startDrill() {
        this.updateDw(this.IS_MINING, true);
    }

    protected void stopDrill() {
        this.updateDw(this.IS_MINING, false);
    }

    protected boolean isMining() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getDrillSpinning();
        }
        return this.getDw(this.IS_MINING);
    }

    protected boolean isDrillSpinning() {
        return this.isMining() || this.miningCoolDown < 10;
    }

    @Override
    public void initDw() {
        super.initDw();
        this.IS_MINING = this.createDw(EntityDataSerializers.f_135035_);
        this.IS_ENABLED = this.createDw(EntityDataSerializers.f_135035_);
        this.registerDw(this.IS_MINING, false);
        this.registerDw(this.IS_ENABLED, true);
    }

    @Override
    public int numberOfDataWatchers() {
        return 2 + super.numberOfDataWatchers();
    }

    public float getDrillRotation() {
        return this.drillRotation;
    }

    private boolean isDrillEnabled() {
        return this.getDw(this.IS_ENABLED);
    }

    public void setDrillEnabled(boolean val) {
        this.updateDw(this.IS_ENABLED, val);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, Player player) {
        this.setDrillEnabled(!this.isDrillEnabled());
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, Localization.MODULES.TOOLS.DRILL.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawBackground(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        super.drawBackground(matrixStack, gui, x, y);
        ResourceHelper.bindResource("/gui/drill.png");
        int imageID = this.isDrillEnabled() ? 1 : 0;
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = 1;
        }
        this.drawImage(matrixStack, gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 2 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(matrixStack, gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(PoseStack matrixStack, GuiMinecart gui, int x, int y) {
        super.drawMouseOver(matrixStack, gui, x, y);
        this.drawStringOnMouseOver(matrixStack, gui, this.getStateName(), x, y, this.buttonRect);
    }

    private String getStateName() {
        return Localization.MODULES.TOOLS.TOGGLE.translate(this.isDrillEnabled() ? "1" : "0");
    }

    @Override
    protected void Save(CompoundTag tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.m_128379_(this.generateNBTName("DrillEnabled", id), this.isDrillEnabled());
    }

    @Override
    protected void Load(CompoundTag tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setDrillEnabled(tagCompound.m_128471_(this.generateNBTName("DrillEnabled", id)));
    }

    @Override
    public void doActivate(int id) {
        this.setDrillEnabled(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.setDrillEnabled(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.isDrillEnabled();
    }
}

