/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import vswe.stevescarts.api.StevesCartsAPI;
import vswe.stevescarts.api.farms.ICropModule;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.api.modules.interfaces.ISuppliesModule;
import vswe.stevescarts.client.guis.GuiMinecart;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotSeed;
import vswe.stevescarts.entities.EntityMinecartModular;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.modules.workers.tools.ModuleTool;

public abstract class ModuleFarmer
extends ModuleTool
implements ISuppliesModule {
    private ArrayList<ICropModule> plantModules;
    private int farming;
    private float farmAngle;
    private float rigAngle = -3.926991f;
    private EntityDataAccessor<Boolean> IS_FARMING;

    public ModuleFarmer(EntityMinecartModular cart) {
        super(cart);
    }

    protected abstract int getRange();

    public int getExternalRange() {
        return this.getRange();
    }

    @Override
    public void init() {
        super.init();
        this.plantModules = new ArrayList();
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ICropModule)) continue;
            this.plantModules.add((ICropModule)((Object)module));
        }
        this.plantModules.addAll(StevesCartsAPI.CROP_MODULES);
    }

    @Override
    public byte getWorkPriority() {
        return 80;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(PoseStack matrixStack, GuiMinecart gui) {
        this.drawString(matrixStack, gui, Localization.MODULES.TOOLS.FARMER.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return super.getInventoryWidth() + 3;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        if (x == 0) {
            return super.getSlot(slotId, x, y);
        }
        return new SlotSeed(this.getCart(), slotId, 8 + --x * 18, 28 + y * 18);
    }

    @Override
    public boolean work() {
        Level world = this.getCart().f_19853_;
        BlockPos next = this.getNextblock();
        for (int i = -this.getRange(); i <= this.getRange(); ++i) {
            for (int j = -this.getRange(); j <= this.getRange(); ++j) {
                BlockPos coord = next.m_7918_(i, -1, j);
                if (this.farm(world, coord)) {
                    return true;
                }
                if (this.till(world, coord)) {
                    return true;
                }
                if (!this.plant(world, coord)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean till(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_204336_(BlockTags.f_144274_) && world.m_8055_(pos.m_7494_()).m_60795_()) {
            if (this.doPreWork()) {
                this.startWorking(10);
                return true;
            }
            this.stopWorking();
            world.m_7731_(pos, Blocks.f_50093_.m_49966_(), 3);
        }
        return false;
    }

    protected boolean plant(Level world, BlockPos pos) {
        int hasSeeds = -1;
        BlockState soilState = world.m_8055_(pos);
        Block soilblock = soilState.m_60734_();
        if (soilblock != null) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                BlockState cropblock;
                if (this.getStack(i).m_41619_() || !this.isSeedValidHandler(this.getStack(i)) || (cropblock = this.getCropFromSeedHandler(this.getStack(i))) == null || !(cropblock.m_60734_() instanceof IPlantable) || !world.m_8055_(pos.m_7494_()).m_60795_() || !soilblock.canSustainPlant(soilState, (BlockGetter)world, pos, Direction.UP, (IPlantable)cropblock.m_60734_())) continue;
                hasSeeds = i;
                break;
            }
            if (hasSeeds != -1) {
                if (this.doPreWork()) {
                    this.startWorking(25);
                    return true;
                }
                this.stopWorking();
                BlockState cropblock2 = this.getCropFromSeedHandler(this.getStack(hasSeeds));
                world.m_7731_(pos.m_7494_(), cropblock2, 3);
                ItemStack stack = this.getStack(hasSeeds);
                stack.m_41774_(1);
                if (this.getStack(hasSeeds).m_41613_() <= 0) {
                    this.setStack(hasSeeds, ItemStack.f_41583_);
                }
            }
        }
        return false;
    }

    protected boolean farm(Level world, BlockPos pos) {
        EntityMinecartModular cart = this.getCart();
        if (!this.isBroken()) {
            pos = pos.m_7494_();
            BlockState blockState = world.m_8055_(pos);
            Block block = blockState.m_60734_();
            if (this.isReadyToHarvestHandler(world, pos)) {
                if (this.doPreWork()) {
                    int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
                    int workingtime = (int)((double)this.getBaseFarmingTime() / Math.pow(1.3f, efficiency));
                    this.setFarming(workingtime * 4);
                    this.startWorking(workingtime);
                    return true;
                }
                this.stopWorking();
                int fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
                List stuff = block.m_7381_(blockState, new LootContext.Builder((ServerLevel)world).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78972_(LootContextParams.f_81460_, (Object)this.getCart().m_20182_()));
                for (ItemStack iStack : stuff) {
                    cart.addItemToChest(iStack);
                    if (iStack.m_41613_() == 0) continue;
                    ItemEntity entityitem = new ItemEntity(world, (double)cart.x(), (double)cart.y(), (double)cart.z(), iStack);
                    world.m_7967_((Entity)entityitem);
                }
                world.m_7471_(pos, false);
                this.damageTool(3);
            }
        }
        return false;
    }

    protected int getBaseFarmingTime() {
        return 25;
    }

    public boolean isSeedValidHandler(@Nonnull ItemStack seed) {
        return seed.m_204117_(Tags.Items.SEEDS) || seed.m_204117_(Tags.Items.CROPS);
    }

    protected BlockState getCropFromSeedHandler(@Nonnull ItemStack seed) {
        Block cropBlock = Block.m_49814_((Item)seed.m_41720_());
        if (cropBlock == null) {
            return null;
        }
        if (cropBlock instanceof CropBlock) {
            CropBlock cropsBlock = (CropBlock)cropBlock;
            return cropsBlock.m_49966_();
        }
        return null;
    }

    protected boolean isReadyToHarvestHandler(Level world, BlockPos pos) {
        Block block = world.m_8055_(pos).m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropsBlock = (CropBlock)block;
            return cropsBlock.m_52307_(world.m_8055_(pos));
        }
        return false;
    }

    public float getFarmAngle() {
        return this.farmAngle;
    }

    public float getRigAngle() {
        return this.rigAngle;
    }

    @Override
    public void initDw() {
        super.initDw();
        this.IS_FARMING = this.createDw(EntityDataSerializers.f_135035_);
        this.registerDw(this.IS_FARMING, false);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1 + super.numberOfDataWatchers();
    }

    private void setFarming(int val) {
        this.farming = val;
        this.updateDw(this.IS_FARMING, val > 0);
    }

    protected boolean isFarming() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getIsFarming();
        }
        return this.getCart().isEngineBurning() && this.getDw(this.IS_FARMING) != false;
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().f_19853_.f_46443_) {
            this.setFarming(this.farming - 1);
        } else {
            float up = -3.926991f;
            float down = (float)(-Math.PI);
            boolean flag = this.isFarming();
            if (flag) {
                if (this.rigAngle < (float)(-Math.PI)) {
                    this.rigAngle += 0.1f;
                    if (this.rigAngle > (float)(-Math.PI)) {
                        this.rigAngle = (float)(-Math.PI);
                    }
                } else {
                    this.farmAngle = (float)((double)(this.farmAngle + 0.15f) % (Math.PI * 2));
                }
            } else if (this.rigAngle > -3.926991f) {
                this.rigAngle -= 0.075f;
                if (this.rigAngle < -3.926991f) {
                    this.rigAngle = -3.926991f;
                }
            }
        }
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item.m_41619_() || !this.isSeedValidHandler(item)) continue;
            return true;
        }
        return false;
    }
}

