/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import vswe.stevescarts.network.packets.PacketActivator;
import vswe.stevescarts.network.packets.PacketCargpManager;
import vswe.stevescarts.network.packets.PacketCreateCart;
import vswe.stevescarts.network.packets.PacketDistributor;
import vswe.stevescarts.network.packets.PacketFluidSync;
import vswe.stevescarts.network.packets.PacketGuiData;
import vswe.stevescarts.network.packets.PacketMinecartButton;
import vswe.stevescarts.network.packets.PacketMinecartTurn;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("stevescarts", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static int index;

    public static void register() {
        PacketHandler.registerMessage(PacketCreateCart.class, PacketCreateCart::encode, PacketCreateCart::decode, PacketCreateCart.Handler::handle);
        PacketHandler.registerMessage(PacketMinecartButton.class, PacketMinecartButton::encode, PacketMinecartButton::decode, PacketMinecartButton.Handler::handle);
        PacketHandler.registerMessage(PacketCargpManager.class, PacketCargpManager::encode, PacketCargpManager::decode, PacketCargpManager.Handler::handle);
        PacketHandler.registerMessage(PacketDistributor.class, PacketDistributor::encode, PacketDistributor::decode, PacketDistributor.Handler::handle);
        PacketHandler.registerMessage(PacketActivator.class, PacketActivator::encode, PacketActivator::decode, PacketActivator.Handler::handle);
        PacketHandler.registerMessage(PacketFluidSync.class, PacketFluidSync::encode, PacketFluidSync::decode, PacketFluidSync.Handler::handle);
        PacketHandler.registerMessage(PacketMinecartTurn.class, PacketMinecartTurn::encode, PacketMinecartTurn::decode, PacketMinecartTurn.Handler::handle);
        PacketHandler.registerMessage(PacketGuiData.class, PacketGuiData::encode, PacketGuiData::decode, PacketGuiData.Handler::handle);
    }

    private static <MSG> void registerMessage(Class<MSG> type, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> consumer) {
        HANDLER.registerMessage(index++, type, encoder, decoder, consumer);
    }

    public static void sendToServer(Object msg) {
        HANDLER.sendToServer(msg);
    }

    public static void send(PacketDistributor.PacketTarget target, Object message) {
        HANDLER.send(target, message);
    }

    public static void sendTo(Object message, ServerPlayer player) {
        HANDLER.sendTo(message, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }
}

