/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import vswe.stevescarts.containers.ContainerBase;

public class PacketGuiData {
    private final int containerId;
    private final int dataId;
    private final int data;

    public PacketGuiData(int containerId, int dataId, int data) {
        this.containerId = containerId;
        this.dataId = dataId;
        this.data = data;
    }

    public static void encode(PacketGuiData msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.containerId);
        buffer.m_130130_(msg.dataId);
        buffer.m_130130_(msg.data);
    }

    public static PacketGuiData decode(FriendlyByteBuf buffer) {
        return new PacketGuiData(buffer.readInt(), buffer.m_130242_(), buffer.m_130242_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientSide(PacketGuiData msg, Supplier<NetworkEvent.Context> ctx) {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof ContainerBase) {
            ContainerBase menu = (ContainerBase)abstractContainerMenu;
            if (menu.f_38840_ == msg.containerId) {
                menu.receiveGuiData(msg.dataId, msg.data);
            }
        }
    }

    public static class Handler {
        public static void handle(PacketGuiData msg, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
                return;
            }
            ctx.get().enqueueWork(() -> PacketGuiData.handleClientSide(msg, ctx));
            ctx.get().setPacketHandled(true);
        }
    }
}

