/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import vswe.stevescarts.api.modules.ModuleBase;
import vswe.stevescarts.entities.EntityMinecartModular;

public class PacketMinecartButton {
    private final int cartID;
    private final int id;
    private final byte[] array;

    public PacketMinecartButton(int cartID, int id, byte[] array) {
        this.cartID = cartID;
        this.id = id;
        this.array = array;
    }

    public static void encode(PacketMinecartButton msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.cartID);
        buffer.writeInt(msg.id);
        buffer.m_130087_(msg.array);
    }

    public static PacketMinecartButton decode(FriendlyByteBuf buffer) {
        return new PacketMinecartButton(buffer.readInt(), buffer.readInt(), buffer.m_130052_());
    }

    public static class Handler {
        public static void handle(PacketMinecartButton msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                    Handler.handleServerSide(msg, ctx);
                } else if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                    Handler.handleClientSide(msg, ctx);
                }
            });
            ctx.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void handleClientSide(PacketMinecartButton msg, Supplier<NetworkEvent.Context> ctx) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            LocalPlayer player = mc.f_91074_;
            Handler.handle(msg, (Level)level, (Player)player);
        }

        private static void handleServerSide(PacketMinecartButton msg, Supplier<NetworkEvent.Context> ctx) {
            ServerLevel level = ctx.get().getSender().m_9236_();
            ServerPlayer player = ctx.get().getSender();
            Handler.handle(msg, (Level)level, (Player)player);
        }

        private static void handle(PacketMinecartButton msg, Level level, Player player) {
            if (level.m_6815_(msg.cartID) == null) {
                return;
            }
            Entity entity = level.m_6815_(msg.cartID);
            if (entity instanceof EntityMinecartModular) {
                EntityMinecartModular entityMinecartModular = (EntityMinecartModular)entity;
                int id = msg.id;
                for (ModuleBase module : entityMinecartModular.getModules()) {
                    if (id < module.getPacketStart() || id >= module.getPacketStart() + module.totalNumberOfPackets()) continue;
                    module.delegateReceivedPacket(id - module.getPacketStart(), msg.array, player);
                    break;
                }
            }
        }
    }
}

