/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.grid.energy;

import cofh.lib.util.Constants;
import cofh.thermal.dynamics.api.grid.IDuct;
import cofh.thermal.dynamics.api.grid.ITickableGridNode;
import cofh.thermal.dynamics.attachment.IAttachment;
import cofh.thermal.dynamics.grid.GridNode;
import cofh.thermal.dynamics.grid.energy.EnergyGrid;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyGridNode
extends GridNode<EnergyGrid>
implements ITickableGridNode {
    protected Direction[] distArray = new Direction[0];
    protected int distIndex = 0;

    protected EnergyGridNode(EnergyGrid grid) {
        super(grid);
    }

    protected void cacheConnections() {
        for (Direction dir : Direction.values()) {
            if (!((EnergyGrid)this.grid).canConnectOnSide(this.pos.m_121945_(dir), dir.m_122424_())) continue;
            this.connections.add(dir);
        }
        this.distArray = this.connections.toArray(new Direction[0]);
        this.cached = true;
    }

    @Override
    public void attachmentTick() {
        IDuct<?, ?> duct = this.gridHost();
        if (duct == null) {
            return;
        }
        for (Direction dir : Constants.DIRECTIONS) {
            duct.getAttachment(dir).tick();
        }
    }

    @Override
    public void distributionTick() {
        IDuct<?, ?> duct;
        if (!this.cached) {
            this.cacheConnections();
        }
        if ((duct = this.gridHost()) != null && this.distArray.length > 0) {
            int i;
            ++this.distIndex;
            this.distIndex %= this.distArray.length;
            Level world = this.getWorld();
            for (i = this.distIndex; i < this.distArray.length; ++i) {
                this.tickDir(world, this.pos, duct, this.distArray[i]);
            }
            for (i = 0; i < this.distIndex; ++i) {
                this.tickDir(world, this.pos, duct, this.distArray[i]);
            }
        }
    }

    private void tickDir(Level world, BlockPos pos, IDuct<?, ?> duct, Direction dir) {
        if (duct.getConnectionType(dir) == IDuct.ConnectionType.DISABLED) {
            return;
        }
        IAttachment attachment = duct.getAttachment(dir);
        BlockEntity tile = world.m_7702_(pos.m_121945_(dir));
        if (tile == null) {
            return;
        }
        attachment.wrapExternalCapability(ThermalEnergyHelper.getBaseEnergySystem(), tile.getCapability(ThermalEnergyHelper.getBaseEnergySystem(), dir.m_122424_()).cast()).ifPresent(e -> ((EnergyGrid)this.grid).extractEnergy(e.receiveEnergy(((EnergyGrid)this.grid).getEnergyStored(), false), false));
    }
}

