/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.foundation.data;

import cofh.lib.util.helpers.DatapackHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.lib.FeatureHelper;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.MegaJungleFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.MegaJungleTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;

public final class TFndFeatures {
    public static final RuleTest SAND = new BlockMatchTest(Blocks.f_49992_);
    public static final RuleTest RED_SAND = new BlockMatchTest(Blocks.f_49993_);
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> RUBBERWOOD_TREE;
    public static Holder<ConfiguredFeature<TreeConfiguration, ?>> MEGA_RUBBERWOOD_TREE;

    public static JsonCodecProvider<PlacedFeature> dataGenFeatures(DataGenerator gen, ExistingFileHelper exFileHelper, RegistryOps<JsonElement> regOps) {
        return DatapackHelper.datapackProvider((String)"thermal", (DataGenerator)gen, (ExistingFileHelper)exFileHelper, regOps, (ResourceKey)Registry.f_194567_, TFndFeatures.generateFeatures((Registry<PlacedFeature>)regOps.f_206806_.m_175515_(Registry.f_194567_), regOps.f_206806_.m_175515_(Registry.f_122881_)));
    }

    private static Map<ResourceLocation, PlacedFeature> generateFeatures(Registry<PlacedFeature> featureRegistry, Registry<ConfiguredFeature<?, ?>> configuredRegistry) {
        HashMap<ResourceLocation, PlacedFeature> featureMap = new HashMap<ResourceLocation, PlacedFeature>();
        TFndFeatures.generateOres(featureMap);
        TFndFeatures.generateVegetation(featureMap, configuredRegistry);
        return featureMap;
    }

    private static void generateOres(Map<ResourceLocation, PlacedFeature> featureMap) {
        FeatureHelper.createOreFeature(featureMap, (String)"apatite_ore", (int)3, (int)-16, (int)96, (int)9);
        FeatureHelper.createOreFeature(featureMap, (String)"cinnabar_ore", (int)1, (int)-16, (int)48, (int)5);
        FeatureHelper.createOreFeature(featureMap, (String)"niter_ore", (int)2, (int)-16, (int)64, (int)7);
        FeatureHelper.createOreFeature(featureMap, (String)"sulfur_ore", (int)2, (int)-16, (int)32, (int)7);
        FeatureHelper.createOreFeature(featureMap, (String)"tin_ore", (int)6, (int)-20, (int)60, (int)9);
        FeatureHelper.createOreFeature(featureMap, (String)"lead_ore", (int)6, (int)-60, (int)40, (int)8);
        FeatureHelper.createOreFeature(featureMap, (String)"silver_ore", (int)4, (int)-60, (int)40, (int)8);
        FeatureHelper.createOreFeature(featureMap, (String)"nickel_ore", (int)4, (int)-40, (int)120, (int)8);
        FeatureHelper.createOreFeature(featureMap, List.of(OreConfiguration.m_161021_((RuleTest)SAND, (BlockState)((Block)ThermalCore.BLOCKS.get("oil_sand")).m_49966_()), OreConfiguration.m_161021_((RuleTest)RED_SAND, (BlockState)((Block)ThermalCore.BLOCKS.get("oil_red_sand")).m_49966_())), (String)"oil_sand", (int)2, (int)40, (int)80, (int)24);
    }

    private static void generateVegetation(Map<ResourceLocation, PlacedFeature> featureMap, Registry<ConfiguredFeature<?, ?>> configuredRegistry) {
        FeatureHelper.createTreeFeature(featureMap, configuredRegistry, (String)"rubberwood_tree", (Block)((Block)ThermalCore.BLOCKS.get("rubberwood_sapling")), (int)25);
        FeatureHelper.createTreeFeature(featureMap, configuredRegistry, (String)"mega_rubberwood_tree", (Block)((Block)ThermalCore.BLOCKS.get("rubberwood_sapling")), (int)100);
    }

    public static void setup() {
        RUBBERWOOD_TREE = FeatureUtils.m_206488_((String)new ResourceLocation("thermal", "rubberwood_tree").toString(), (Feature)Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_log"))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 2), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_leaves"))), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).m_68244_().m_68251_());
        MEGA_RUBBERWOOD_TREE = FeatureUtils.m_206488_((String)new ResourceLocation("thermal", "mega_rubberwood_tree").toString(), (Feature)Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_log"))), (TrunkPlacer)new MegaJungleTrunkPlacer(7, 2, 4), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_leaves"))), (FoliagePlacer)new MegaJungleFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).m_68244_().m_68251_());
    }
}

