/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.foundation.init;

import cofh.core.item.BlockItemCoFH;
import cofh.lib.block.OreBlockCoFH;
import cofh.lib.util.Utils;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.util.RegistrationHelper;
import cofh.thermal.foundation.ThermalFoundation;
import cofh.thermal.foundation.world.level.block.grower.RubberTreeGrower;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalItemGroups;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class TFndBlocks {
    private TFndBlocks() {
    }

    public static void register() {
        TFndBlocks.registerResources();
        TFndBlocks.registerStorage();
        TFndBlocks.registerWoodBlocks();
    }

    public static void setup() {
        FireBlock fire = (FireBlock)Blocks.f_50083_;
        fire.m_53444_((Block)ThermalCore.BLOCKS.get("rubberwood_leaves"), 30, 60);
        ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("rubberwood_sapling")));
        ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)ThermalCore.ITEMS.get("rubberwood_leaves")));
        HashMap<Block, Block> axeMap = new HashMap<Block, Block>(AxeItem.f_150683_.size() + 2);
        axeMap.putAll(AxeItem.f_150683_);
        axeMap.put((Block)ThermalCore.BLOCKS.get("rubberwood_log"), (Block)ThermalCore.BLOCKS.get("stripped_rubberwood_log"));
        axeMap.put((Block)ThermalCore.BLOCKS.get("rubberwood_wood"), (Block)ThermalCore.BLOCKS.get("stripped_rubberwood_wood"));
        AxeItem.f_150683_ = axeMap;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)BlockEntityType.f_58924_.f_58915_);
        builder.add((Object)((Block)ThermalCore.BLOCKS.get("rubberwood_sign")));
        builder.add((Object)((Block)ThermalCore.BLOCKS.get("rubberwood_wall_sign")));
        BlockEntityType.f_58924_.f_58915_ = builder.build();
        if (Blocks.f_50276_ instanceof FlowerPotBlock) {
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(Utils.getRegistryName((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_sapling"))), (Supplier)ThermalCore.BLOCKS.getSup("potted_rubberwood_sapling"));
        }
    }

    private static void registerResources() {
        RegistrationHelper.registerBlock((String)"apatite_ore", () -> OreBlockCoFH.createStoneOre().xp(0, 2), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_APATITE), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"apatite_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(0, 2), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_APATITE), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"cinnabar_ore", () -> OreBlockCoFH.createStoneOre().xp(1, 3), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_CINNABAR), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"cinnabar_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(1, 3), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_CINNABAR), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"niter_ore", () -> OreBlockCoFH.createStoneOre().xp(0, 2), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_NITER), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"niter_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(0, 2), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_NITER), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"sulfur_ore", () -> OreBlockCoFH.createStoneOre().xp(0, 2), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_SULFUR), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"sulfur_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(0, 2), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_SULFUR), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"tin_ore", OreBlockCoFH::createStoneOre, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_TIN), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"tin_ore"), OreBlockCoFH::createDeepslateOre, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_TIN), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"lead_ore", OreBlockCoFH::createStoneOre, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_LEAD), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"lead_ore"), OreBlockCoFH::createDeepslateOre, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_LEAD), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"silver_ore", OreBlockCoFH::createStoneOre, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_SILVER), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"silver_ore"), OreBlockCoFH::createDeepslateOre, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_SILVER), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"nickel_ore", OreBlockCoFH::createStoneOre, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_NICKEL), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"nickel_ore"), OreBlockCoFH::createDeepslateOre, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_NICKEL), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"ruby_ore", () -> OreBlockCoFH.createStoneOre().xp(3, 7), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_RUBY), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"ruby_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(3, 7), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_RUBY), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"sapphire_ore", () -> OreBlockCoFH.createStoneOre().xp(3, 7), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_SAPPHIRE), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.deepslate((String)"sapphire_ore"), () -> OreBlockCoFH.createDeepslateOre().xp(3, 7), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_SAPPHIRE), (String)"thermal_foundation");
        RegistrationHelper.registerBlockAndItem((String)"oil_sand", () -> new SandBlock(14406560, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_)), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("oil_sand"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(2400).setShowInGroups(ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_OIL)).setModId("thermal_foundation"));
        RegistrationHelper.registerBlockAndItem((String)"oil_red_sand", () -> new SandBlock(11098145, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49993_)), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("oil_red_sand"), new Item.Properties().m_41491_(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(2400).setShowInGroups(ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_OIL)).setModId("thermal_foundation"));
    }

    private static void registerStorage() {
        RegistrationHelper.registerBlock((String)RegistrationHelper.raw((String)"tin_block"), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76375_).m_60913_(5.0f, 6.0f).m_60999_()), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.raw((String)"lead_block"), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76383_).m_60913_(5.0f, 6.0f).m_60999_()), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.raw((String)"silver_block"), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76380_).m_60913_(5.0f, 6.0f).m_60999_()), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)RegistrationHelper.raw((String)"nickel_block"), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76376_).m_60913_(5.0f, 6.0f).m_60999_()), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"tin_block", RegistrationHelper::storageBlock, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_TIN), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"lead_block", RegistrationHelper::storageBlock, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_LEAD), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"silver_block", RegistrationHelper::storageBlock, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_SILVER), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"nickel_block", RegistrationHelper::storageBlock, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_NICKEL), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"bronze_block", RegistrationHelper::storageBlock, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_BRONZE), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"electrum_block", RegistrationHelper::storageBlock, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_ELECTRUM), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"invar_block", RegistrationHelper::storageBlock, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_INVAR), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"constantan_block", RegistrationHelper::storageBlock, (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_CONSTANTAN), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"ruby_block", () -> RegistrationHelper.storageBlock((MaterialColor)MaterialColor.f_76364_), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_RUBY), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"sapphire_block", () -> RegistrationHelper.storageBlock((MaterialColor)MaterialColor.f_76361_), (Supplier)ThermalFlags.getFlag((String)ThermalFlags.FLAG_RESOURCE_SAPPHIRE), (String)"thermal_foundation");
    }

    private static void registerWoodBlocks() {
        RegistrationHelper.registerBlock((String)"rubberwood_log", () -> TFndBlocks.log(MaterialColor.f_76385_, MaterialColor.f_76412_), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"stripped_rubberwood_log", () -> TFndBlocks.log(MaterialColor.f_76385_, MaterialColor.f_76385_), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"rubberwood_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76412_).m_60978_(2.0f).m_60918_(SoundType.f_56736_)), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"stripped_rubberwood_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76385_).m_60978_(2.0f).m_60918_(SoundType.f_56736_)), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"rubberwood_sapling", () -> new SaplingBlock((AbstractTreeGrower)new RubberTreeGrower(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_)), (String)"thermal_foundation");
        RegistrationHelper.registerBlock((String)"rubberwood_leaves", () -> TFndBlocks.leaves(SoundType.f_56740_), (String)"thermal_foundation");
        if (Blocks.f_50276_ instanceof FlowerPotBlock) {
            RegistrationHelper.registerBlockOnly((String)"potted_rubberwood_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, (Supplier)ThermalCore.BLOCKS.getSup("rubberwood_sapling"), BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60966_().m_60955_()));
        }
        RegistrationHelper.registerWoodBlockSet((String)"rubberwood", (Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76385_, (float)1.5f, (float)2.5f, (SoundType)SoundType.f_56736_, (String)"thermal_foundation");
        RegistrationHelper.registerBlockOnly((String)"rubberwood_sign", () -> new StandingSignBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), ThermalFoundation.RUBBERWOOD));
        RegistrationHelper.registerBlockOnly((String)"rubberwood_wall_sign", () -> new WallSignBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).lootFrom((Supplier)ThermalCore.BLOCKS.getSup("rubberwood_sign")), ThermalFoundation.RUBBERWOOD));
    }

    private static RotatedPillarBlock log(MaterialColor inner, MaterialColor bark) {
        return new RotatedPillarBlock(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? inner : bark).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
    }

    private static LeavesBlock leaves(SoundType soundType) {
        return new LeavesBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(0.2f).m_60977_().m_60918_(soundType).m_60955_().m_60922_(Blocks::m_50821_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_));
    }
}

