/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.client.model;

import cofh.core.item.IMultiModeItem;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.item.ICoFHItem;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public final class FluidReservoirItemModel
implements IUnbakedGeometry<FluidReservoirItemModel> {
    private static final Transformation FLUID_TRANSFORM = new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.002f), Quaternion.f_80118_);
    private static final Transformation COVER_TRANSFORM = new Transformation(Vector3f.f_176763_, Quaternion.f_80118_, new Vector3f(1.0f, 1.0f, 1.004f), Quaternion.f_80118_);
    private static final IQuadTransformer MAX_LIGHTMAP_TRANSFORMER = QuadTransformers.applyingLightmap((int)0xF000F0);
    @Nonnull
    private final FluidStack fluidStack;
    private final int mode;
    private final boolean active;
    private final boolean color;

    public FluidReservoirItemModel(FluidStack fluidStack, int mode, boolean active, boolean color) {
        this.fluidStack = fluidStack;
        this.mode = mode;
        this.active = active;
        this.color = color;
    }

    public FluidReservoirItemModel withProperties(FluidStack newFluid, int mode, boolean active, boolean color) {
        return new FluidReservoirItemModel(newFluid, mode, active, color);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        Material frameLayer;
        Material modeLayer;
        TextureAtlasSprite particleSprite;
        Material particleLocation = context.hasMaterial("particle") ? context.getMaterial("particle") : null;
        Material fluidMaskLocation = context.hasMaterial("fluid_mask") ? context.getMaterial("fluid_mask") : null;
        Material[] inactiveLocations = new Material[2];
        Material[] activeLocations = new Material[2];
        Material[] baseLocations = new Material[2];
        Material[] colorLocations = new Material[2];
        inactiveLocations[0] = context.hasMaterial("mode_0") ? context.getMaterial("mode_0") : null;
        inactiveLocations[1] = context.hasMaterial("mode_1") ? context.getMaterial("mode_1") : null;
        activeLocations[0] = context.hasMaterial("active_0") ? context.getMaterial("active_0") : null;
        activeLocations[1] = context.hasMaterial("active_1") ? context.getMaterial("active_1") : null;
        baseLocations[0] = context.hasMaterial("base_0") ? context.getMaterial("base_0") : null;
        baseLocations[1] = context.hasMaterial("base_1") ? context.getMaterial("base_1") : null;
        colorLocations[0] = context.hasMaterial("color_0") ? context.getMaterial("color_0") : null;
        colorLocations[1] = context.hasMaterial("color_1") ? context.getMaterial("color_1") : null;
        Fluid fluid = this.fluidStack.getFluid();
        TextureAtlasSprite fluidSprite = fluid != Fluids.f_76191_ ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(this.fluidStack))) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite != null ? fluidSprite : spriteGetter.apply(baseLocations[0]);
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(modelLocation);
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(bakery, (IGeometryBakingContext)itemContext, this), (ItemTransforms)context.getTransforms());
        RenderTypeGroup normalRenderTypes = FluidReservoirItemModel.getLayerRenderTypes();
        Material material = modeLayer = this.active ? activeLocations[this.mode % 2] : inactiveLocations[this.mode % 2];
        if (modeLayer != null) {
            TextureAtlasSprite modeSprite = spriteGetter.apply(modeLayer);
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)modeSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> modeSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        Material material2 = frameLayer = this.color ? colorLocations[this.mode % 2] : baseLocations[this.mode % 2];
        if (frameLayer != null) {
            TextureAtlasSprite frameSprite = spriteGetter.apply(frameLayer);
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)1, (TextureAtlasSprite)frameSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> frameSprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.m_6189_().m_121096_(FLUID_TRANSFORM), modelState.m_7538_());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)2, (TextureAtlasSprite)templateSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (ModelState)transformedState, (ResourceLocation)modelLocation);
            boolean unlit = fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = FluidReservoirItemModel.getLayerRenderTypes();
            if (unlit) {
                MAX_LIGHTMAP_TRANSFORMER.processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.hasMaterial("particle")) {
            texs.add(owner.getMaterial("particle"));
        }
        if (owner.hasMaterial("fluid_mask")) {
            texs.add(owner.getMaterial("fluid_mask"));
        }
        if (owner.hasMaterial("base_0")) {
            texs.add(owner.getMaterial("base_0"));
        }
        if (owner.hasMaterial("base_1")) {
            texs.add(owner.getMaterial("base_1"));
        }
        if (owner.hasMaterial("color_0")) {
            texs.add(owner.getMaterial("color_0"));
        }
        if (owner.hasMaterial("color_1")) {
            texs.add(owner.getMaterial("color_1"));
        }
        if (owner.hasMaterial("mode_0")) {
            texs.add(owner.getMaterial("mode_0"));
        }
        if (owner.hasMaterial("mode_1")) {
            texs.add(owner.getMaterial("mode_1"));
        }
        if (owner.hasMaterial("active_0")) {
            texs.add(owner.getMaterial("active_0"));
        }
        if (owner.hasMaterial("active_1")) {
            texs.add(owner.getMaterial("active_1"));
        }
        return texs;
    }

    public static RenderTypeGroup getLayerRenderTypes() {
        return new RenderTypeGroup(RenderType.m_110463_(), ForgeRenderTypes.ITEM_LAYERED_CUTOUT.get());
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<List<Integer>, BakedModel> cache = new Object2ObjectOpenHashMap();
        private final ModelBakery bakery;
        private final IGeometryBakingContext owner;
        private final FluidReservoirItemModel parent;

        private ContainedFluidOverrideHandler(ModelBakery bakery, IGeometryBakingContext owner, FluidReservoirItemModel parent) {
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            int mode = ((IMultiModeItem)stack.m_41720_()).getMode(stack);
            boolean active = ((ICoFHItem)stack.m_41720_()).isActive(stack);
            CompoundTag nbt = stack.m_41737_("display");
            boolean color = nbt != null && nbt.m_128425_("color", 99);
            FluidStack fluidStack = FluidHelper.getFluidContainedInItem((ItemStack)stack).orElse(FluidStack.EMPTY);
            List<Integer> fluidHash = Arrays.asList(mode + (active ? 2 : 0) + (color ? 4 : 0), FluidHelper.fluidHashcode((FluidStack)fluidStack));
            if (!this.cache.containsKey(fluidHash)) {
                FluidReservoirItemModel unbaked = this.parent.withProperties(fluidStack, mode, active, color);
                BakedModel bakedModel = unbaked.bake(this.owner, this.bakery, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("thermal_innovation", "reservoir_override"));
                this.cache.put(fluidHash, bakedModel);
                return bakedModel;
            }
            return this.cache.get(fluidHash);
        }
    }

    public static class Loader
    implements IGeometryLoader<FluidReservoirItemModel> {
        public FluidReservoirItemModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ResourceLocation fluidName;
            Fluid fluid;
            FluidStack stack = FluidStack.EMPTY;
            if (jsonObject.has("fluid") && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName = new ResourceLocation(jsonObject.get("fluid").getAsString()))) != null) {
                stack = new FluidStack(fluid, 1000);
            }
            return new FluidReservoirItemModel(stack, 0, false, false);
        }
    }
}

