/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.HedgeMazeComponent;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.components.structures.HydraLairComponent;
import twilightforest.world.components.structures.QuestGrove;
import twilightforest.world.components.structures.TFStructureComponentTemplate;
import twilightforest.world.components.structures.YetiCaveComponent;
import twilightforest.world.components.structures.courtyard.CourtyardMain;
import twilightforest.world.components.structures.darktower.DarkTowerMainComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleMainComponent;
import twilightforest.world.components.structures.icetower.IceTowerMainComponent;
import twilightforest.world.components.structures.lichtower.TowerMainComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRuinsComponent;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerMainComponent;
import twilightforest.world.components.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.world.components.structures.trollcave.TrollCaveMainComponent;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class TFLandmark
implements StructureHints,
AdvancementLockedStructure,
DecorationClearance,
ControlledSpawns {
    public static final TFLandmark NOTHING = new TFLandmark(0, "no_feature", false, null, TerrainAdjustment.NONE, new ResourceLocation[0]){
        {
            this.enableDecorations().disableStructure();
        }
    };
    public static final TFLandmark SMALL_HILL = new TFLandmark(1, "small_hollow_hill", true, (TagKey)BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES, TerrainAdjustment.NONE, true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)EntityType.f_20479_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20501_, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SWARM_SPIDER.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.KOBOLD.get()), 10, 4, 8);
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new HollowHillComponent((StructurePieceType)TFStructurePieceTypes.TFHill.get(), this, 0, this.size, x - 3, y - 2, z - 3);
        }
    };
    public static final TFLandmark MEDIUM_HILL = new TFLandmark(2, "medium_hollow_hill", true, (TagKey)BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES, TerrainAdjustment.NONE, true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP_SAPPER.get()), 1, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.KOBOLD.get()), 10, 2, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 2, 3).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SWARM_SPIDER.get()), 10, 2, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20479_, 10, 1, 3).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.FIRE_BEETLE.get()), 5, 1, 1).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SLIME_BEETLE.get()), 5, 1, 1).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 1, 1, 1);
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new HollowHillComponent((StructurePieceType)TFStructurePieceTypes.TFHill.get(), this, 0, this.size, x - 7, y - 5, z - 7);
        }
    };
    public static final TFLandmark LARGE_HILL = new TFLandmark(3, "large_hollow_hill", true, (TagKey)BiomeTagGenerator.VALID_HOLLOW_HILL_BIOMES, TerrainAdjustment.NONE, true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP.get()), 10, 2, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP_SAPPER.get()), 2, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 2, 3).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20554_, 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 10, 1, 1).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20566_, 1, 1, 1).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.WRAITH.get()), 2, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.FIRE_BEETLE.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SLIME_BEETLE.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.PINCH_BEETLE.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 1, 1, 1);
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new HollowHillComponent((StructurePieceType)TFStructurePieceTypes.TFHill.get(), this, 0, this.size, x - 11, y - 5, z - 11);
        }
    };
    public static final TFLandmark HEDGE_MAZE = new TFLandmark(2, "hedge_maze", true, (TagKey)BiomeTagGenerator.VALID_HEDGE_MAZE_BIOMES, TerrainAdjustment.BEARD_THIN, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new HedgeMazeComponent(this, 0, x + 1, chunkGenerator.m_6337_() + 8, z + 1);
        }
    };
    public static final TFLandmark QUEST_GROVE = new TFLandmark(1, "quest_grove", true, (TagKey)BiomeTagGenerator.VALID_QUEST_GROVE_BIOMES, TerrainAdjustment.BEARD_THIN, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new QuestGrove(structureManager, new BlockPos(x - 12, chunkGenerator.m_6337_() + 5, z - 12));
        }
    };
    public static final TFLandmark NAGA_COURTYARD = new TFLandmark(3, "naga_courtyard", true, (TagKey)BiomeTagGenerator.VALID_NAGA_COURTYARD_BIOMES, TerrainAdjustment.BEARD_THIN, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new CourtyardMain(this, rand, 0, x + 1, chunkGenerator.m_6337_() + 5, z + 1, structureManager);
        }
    };
    public static final TFLandmark LICH_TOWER = new TFLandmark(1, "lich_tower", true, (TagKey)BiomeTagGenerator.VALID_LICH_TOWER_BIOMES, TerrainAdjustment.BEARD_THIN, new ResourceLocation[]{TwilightForestMod.prefix("progress_naga")}){
        {
            this.addMonster((EntityType<? extends LivingEntity>)EntityType.f_20501_, 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 1, 1, 1).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20566_, 1, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.DEATH_TOME.get()), 10, 2, 3).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 1, 1, 1);
            this.adjustToTerrainHeight = true;
        }

        @Override
        public void addBookInformation(ItemStack book, ListTag bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.lichtower", 4);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)"twilightforest.book.author"));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"twilightforest.book.lichtower"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new TowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFLandmark HYDRA_LAIR = new TFLandmark(2, "hydra_lair", true, (TagKey)BiomeTagGenerator.VALID_HYDRA_LAIR_BIOMES, TerrainAdjustment.NONE, true, new ResourceLocation[]{TwilightForestMod.prefix("progress_labyrinth")}){
        {
            this.enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
        }

        @Override
        public void addBookInformation(ItemStack book, ListTag bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.hydralair", 4);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)"twilightforest.book.author"));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"twilightforest.book.hydralair"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new HydraLairComponent(this, 0, x - 7, y, z - 7);
        }
    };
    public static final TFLandmark LABYRINTH = new TFLandmark(3, "labyrinth", true, (TagKey)BiomeTagGenerator.VALID_LABYRINTH_BIOMES, TerrainAdjustment.BURY, new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.MINOTAUR.get()), 20, 2, 3).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20554_, 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.MAZE_SLIME.get()), 10, 2, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20566_, 1, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.FIRE_BEETLE.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SLIME_BEETLE.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.PINCH_BEETLE.get()), 10, 1, 1);
        }

        @Override
        public void addBookInformation(ItemStack book, ListTag bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.labyrinth", 5);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)"twilightforest.book.author"));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"twilightforest.book.labyrinth"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new MazeRuinsComponent(this, 0, x, y, z);
        }

        @Override
        public GenerationStep.Decoration getDecorationStage() {
            return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
        }
    };
    public static final TFLandmark DARK_TOWER = new TFLandmark(1, "dark_tower", true, (TagKey)BiomeTagGenerator.VALID_DARK_TOWER_BIOMES, TerrainAdjustment.BEARD_THIN, new ResourceLocation[]{TwilightForestMod.prefix("progress_knights")}){
        {
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.CARMINITE_GOLEM.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 5, 1, 1).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20566_, 2, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 1, 1, 1).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.CARMINITE_GHASTLING.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.CARMINITE_BROODLING.get()), 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.PINCH_BEETLE.get()), 10, 1, 1).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.CARMINITE_GHASTGUARD.get()), 10, 1, 2).addWaterCreature((EntityType<? extends LivingEntity>)EntityType.f_20480_, 10, 4, 4);
            this.adjustToTerrainHeight = true;
        }

        @Override
        public void addBookInformation(ItemStack book, ListTag bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.darktower", 3);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)"twilightforest.book.author"));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"twilightforest.book.darktower"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new DarkTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFLandmark KNIGHT_STRONGHOLD = new TFLandmark(3, "knight_stronghold", true, (TagKey)BiomeTagGenerator.VALID_KNIGHT_STRONGHOLD_BIOMES, TerrainAdjustment.BURY, new ResourceLocation[]{TwilightForestMod.prefix("progress_trophy_pedestal")}){
        {
            this.enableDecorations().disableProtectionAura();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.BLOCKCHAIN_GOBLIN.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.LOWER_GOBLIN_KNIGHT.get()), 5, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.HELMET_CRAB.get()), 10, 2, 4).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SLIME_BEETLE.get()), 10, 2, 3).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.REDCAP_SAPPER.get()), 2, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.KOBOLD.get()), 10, 2, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 5, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20526_, 5, 4, 4);
        }

        @Override
        public void addBookInformation(ItemStack book, ListTag bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.tfstronghold", 5);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)"twilightforest.book.author"));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"twilightforest.book.tfstronghold"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new StrongholdEntranceComponent(this, 0, x, y + 5, z);
        }

        @Override
        public GenerationStep.Decoration getDecorationStage() {
            return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
        }
    };
    public static final TFLandmark YETI_CAVE = new TFLandmark(2, "yeti_lairs", true, (TagKey)BiomeTagGenerator.VALID_YETI_CAVE_BIOMES, TerrainAdjustment.BURY, true, new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.YETI.get()), 5, 1, 2);
        }

        @Override
        public void addBookInformation(ItemStack book, ListTag bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.yeticave", 3);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)"twilightforest.book.author"));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"twilightforest.book.yeticave"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new YetiCaveComponent(this, 0, x, y, z);
        }
    };
    public static final TFLandmark ICE_TOWER = new TFLandmark(2, "ice_tower", true, (TagKey)BiomeTagGenerator.VALID_AURORA_PALACE_BIOMES, TerrainAdjustment.NONE, new ResourceLocation[]{TwilightForestMod.prefix("progress_yeti")}){
        {
            this.addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.SNOW_GUARDIAN.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.STABLE_ICE_CORE.get()), 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.UNSTABLE_ICE_CORE.get()), 5, 1, 2);
        }

        @Override
        public void addBookInformation(ItemStack book, ListTag bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.icetower", 3);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)"twilightforest.book.author"));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"twilightforest.book.icetower"));
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new IceTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFLandmark TROLL_CAVE = new TFLandmark(4, "troll_lairs", true, (TagKey)BiomeTagGenerator.VALID_TROLL_CAVE_BIOMES, TerrainAdjustment.BURY, new ResourceLocation[]{TwilightForestMod.prefix("progress_merge")}){
        {
            this.enableDecorations().enableTerrainAlterations().disableProtectionAura();
            this.addMonster((EntityType<? extends LivingEntity>)EntityType.f_20558_, 5, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20524_, 10, 1, 2).addMonster((EntityType<? extends LivingEntity>)((EntityType)TFEntities.TROLL.get()), 20, 1, 2).addMonster((EntityType<? extends LivingEntity>)EntityType.f_20495_, 5, 1, 1).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.GIANT_MINER.get()), 10, 1, 1).addMonster(1, (EntityType<? extends LivingEntity>)((EntityType)TFEntities.ARMORED_GIANT.get()), 10, 1, 1);
        }

        @Override
        public void addBookInformation(ItemStack book, ListTag bookPages) {
            StructureHints.addTranslatedPages(bookPages, "twilightforest.book.trollcave", 3);
            book.m_41700_("pages", (Tag)bookPages);
            book.m_41700_("author", (Tag)StringTag.m_129297_((String)"twilightforest.book.author"));
            book.m_41700_("title", (Tag)StringTag.m_129297_((String)"twilightforest.book.trollcave"));
        }

        @Override
        public GenerationStep.Decoration getDecorationStage() {
            return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new TrollCaveMainComponent((StructurePieceType)TFStructurePieceTypes.TFTCMai.get(), this, 0, x, y, z);
        }
    };
    public static final TFLandmark FINAL_CASTLE = new TFLandmark(4, "final_castle", true, (TagKey)BiomeTagGenerator.VALID_FINAL_CASTLE_BIOMES, TerrainAdjustment.BEARD_THIN, new ResourceLocation[]{TwilightForestMod.prefix("progress_troll")}){

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new FinalCastleMainComponent(this, 0, x, y, z);
        }
    };
    public static final TFLandmark MUSHROOM_TOWER = new TFLandmark(2, "mushroom_tower", true, (TagKey)BiomeTagGenerator.VALID_MUSHROOM_TOWER_BIOMES, TerrainAdjustment.NONE, new ResourceLocation[0]){
        {
            this.disableStructure();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
            return new MushroomTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFLandmark QUEST_ISLAND = new TFLandmark(1, "quest_island", false, (TagKey)BiomeTagGenerator.VALID_QUEST_GROVE_BIOMES, TerrainAdjustment.NONE, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    };
    public final int size;
    public final String name;
    public final boolean centerBounds;
    protected boolean surfaceDecorationsAllowed = false;
    protected boolean undergroundDecoAllowed = true;
    public boolean isStructureEnabled = true;
    public boolean requiresTerraforming = false;
    private final TagKey<Biome> biomeTag;
    private final TerrainAdjustment beardifierContribution;
    private final ImmutableList<ResourceLocation> requiredAdvancements;
    public boolean hasProtectionAura = true;
    protected boolean adjustToTerrainHeight = false;
    private static int maxPossibleSize;
    private final List<List<MobSpawnSettings.SpawnerData>> spawnableMonsterLists = new ArrayList<List<MobSpawnSettings.SpawnerData>>();
    private final List<MobSpawnSettings.SpawnerData> ambientCreatureList = new ArrayList<MobSpawnSettings.SpawnerData>();
    private final List<MobSpawnSettings.SpawnerData> waterCreatureList = new ArrayList<MobSpawnSettings.SpawnerData>();
    private long lastSpawnedHintMonsterTime;
    private static final ImmutableMap<String, TFLandmark> NAME_2_TYPE;
    public static final Codec<TFLandmark> CODEC;

    private TFLandmark(int size, String name, boolean featureGenerator, @Nullable TagKey<Biome> biomeTag, TerrainAdjustment beardifierContribution, ResourceLocation ... requiredAdvancements) {
        this(size, name, featureGenerator, biomeTag, beardifierContribution, false, requiredAdvancements);
    }

    private TFLandmark(int size, String name, boolean featureGenerator, TagKey<Biome> biomeTag, TerrainAdjustment beardifierContribution, boolean centerBounds, ResourceLocation ... requiredAdvancements) {
        this.size = size;
        this.name = name;
        this.biomeTag = biomeTag;
        this.beardifierContribution = beardifierContribution;
        this.requiredAdvancements = ImmutableList.copyOf((Object[])requiredAdvancements);
        this.centerBounds = centerBounds;
        maxPossibleSize = Math.max(this.size, maxPossibleSize);
    }

    @Deprecated
    public static int getMaxSearchSize() {
        return maxPossibleSize;
    }

    @Override
    public boolean isSurfaceDecorationsAllowed() {
        return this.surfaceDecorationsAllowed;
    }

    @Override
    public boolean isUndergroundDecoAllowed() {
        return this.undergroundDecoAllowed;
    }

    @Override
    public boolean shouldAdjustToTerrain() {
        return this.adjustToTerrainHeight;
    }

    public TFLandmark enableDecorations() {
        this.surfaceDecorationsAllowed = true;
        return this;
    }

    public TFLandmark disableStructure() {
        this.enableDecorations();
        this.isStructureEnabled = false;
        return this;
    }

    public TFLandmark enableTerrainAlterations() {
        this.requiresTerraforming = true;
        return this;
    }

    public TFLandmark disableProtectionAura() {
        this.hasProtectionAura = false;
        return this;
    }

    public TFLandmark addMonster(EntityType<? extends LivingEntity> monsterClass, int weight, int minGroup, int maxGroup) {
        this.addMonster(0, monsterClass, weight, minGroup, maxGroup);
        return this;
    }

    public TFLandmark addMonster(int listIndex, EntityType<? extends LivingEntity> monsterClass, int weight, int minGroup, int maxGroup) {
        List<Object> monsterList;
        if (this.spawnableMonsterLists.size() > listIndex) {
            monsterList = this.spawnableMonsterLists.get(listIndex);
        } else {
            monsterList = new ArrayList();
            this.spawnableMonsterLists.add(listIndex, monsterList);
        }
        monsterList.add(new MobSpawnSettings.SpawnerData(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public TFLandmark addWaterCreature(EntityType<? extends LivingEntity> monsterClass, int weight, int minGroup, int maxGroup) {
        this.waterCreatureList.add(new MobSpawnSettings.SpawnerData(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    @Nullable
    public TagKey<Biome> getBiomeTag() {
        return this.biomeTag;
    }

    public TerrainAdjustment getBeardifierContribution() {
        return this.beardifierContribution;
    }

    @Override
    public List<MobSpawnSettings.SpawnerData> getCombinedMonsterSpawnableList() {
        ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>();
        this.spawnableMonsterLists.forEach(l -> {
            if (l != null) {
                list.addAll((Collection<MobSpawnSettings.SpawnerData>)l);
            }
        });
        return list;
    }

    @Override
    public List<MobSpawnSettings.SpawnerData> getCombinedCreatureSpawnableList() {
        ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>();
        list.addAll(this.ambientCreatureList);
        list.addAll(this.waterCreatureList);
        return list;
    }

    @Override
    public List<MobSpawnSettings.SpawnerData> getSpawnableList(MobCategory creatureType) {
        return switch (creatureType) {
            case MobCategory.MONSTER -> this.getSpawnableMonsterList(0);
            case MobCategory.AMBIENT -> this.ambientCreatureList;
            case MobCategory.WATER_CREATURE -> this.waterCreatureList;
            default -> List.of();
        };
    }

    @Override
    public List<MobSpawnSettings.SpawnerData> getSpawnableMonsterList(int index) {
        if (index >= 0 && index < this.spawnableMonsterLists.size()) {
            return this.spawnableMonsterLists.get(index);
        }
        return new ArrayList<MobSpawnSettings.SpawnerData>();
    }

    public List<List<MobSpawnSettings.SpawnerData>> getSpawnableMonsterLists() {
        return this.spawnableMonsterLists;
    }

    public List<MobSpawnSettings.SpawnerData> getAmbientCreatureList() {
        return this.ambientCreatureList;
    }

    public List<MobSpawnSettings.SpawnerData> getWaterCreatureList() {
        return this.waterCreatureList;
    }

    @Override
    public List<ResourceLocation> getRequiredAdvancements() {
        return this.requiredAdvancements;
    }

    @Override
    public void trySpawnHintMonster(Level world, Player player, BlockPos pos) {
        long currentTime = world.m_46467_();
        if (currentTime < this.lastSpawnedHintMonsterTime) {
            this.lastSpawnedHintMonsterTime = 0L;
        }
        if (currentTime - this.lastSpawnedHintMonsterTime > 1200L) {
            for (int i = 0; i < 20; ++i) {
                if (!this.didSpawnHintMonster(world, player, pos)) continue;
                this.lastSpawnedHintMonsterTime = currentTime;
                break;
            }
        }
    }

    @Nullable
    public StructurePiece provideFirstPiece(StructureTemplateManager structureManager, ChunkGenerator chunkGenerator, RandomSource rand, int x, int y, int z) {
        return null;
    }

    public Optional<Structure.GenerationStub> generateStub(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        boolean dontCenter = this == LICH_TOWER || this == TROLL_CAVE || this == YETI_CAVE;
        int x = (chunkPos.f_45578_ << 4) + (dontCenter ? 0 : 7);
        int z = (chunkPos.f_45579_ << 4) + (dontCenter ? 0 : 7);
        int y = this.shouldAdjustToTerrain() ? Mth.m_14045_((int)context.f_226622_().m_223235_(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()), (int)(context.f_226622_().m_6337_() + 1), (int)(context.f_226622_().m_6337_() + 7)) : context.f_226622_().m_6337_();
        return Optional.ofNullable(this.provideFirstPiece(context.f_226625_(), context.f_226622_(), RandomSource.m_216335_((long)(context.f_226627_() + (long)chunkPos.f_45578_ * 25117L + (long)chunkPos.f_45579_ * 151121L)), x, y, z)).map(piece -> this.getStructurePieceGenerationStubFunction((StructurePiece)piece, context, x, y, z));
    }

    @NotNull
    private Structure.GenerationStub getStructurePieceGenerationStubFunction(StructurePiece startingPiece, Structure.GenerationContext context, int x, int y, int z) {
        return new Structure.GenerationStub(new BlockPos(x, y, z), structurePiecesBuilder -> {
            structurePiecesBuilder.m_142679_(startingPiece);
            startingPiece.m_214092_(startingPiece, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)context.f_226626_());
            structurePiecesBuilder.f_192778_.stream().filter(TFStructureComponentTemplate.class::isInstance).map(TFStructureComponentTemplate.class::cast).forEach(t -> t.LAZY_TEMPLATE_LOADER.run());
        });
    }

    public GenerationStep.Decoration getDecorationStage() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public final BoundingBox getComponentToAddBoundingBox(int x, int y, int z, int minX, int minY, int minZ, int spanX, int spanY, int spanZ, @Nullable Direction dir) {
        if (this.centerBounds) {
            x += (spanX + minX) / 4;
            y += (spanY + minY) / 4;
            z += (spanZ + minZ) / 4;
        }
        return switch (dir) {
            case Direction.WEST -> new BoundingBox(x - spanZ + minZ, y + minY, z + minX, x + minZ, y + spanY + minY, z + spanX + minX);
            case Direction.NORTH -> new BoundingBox(x - spanX - minX, y + minY, z - spanZ - minZ, x - minX, y + spanY + minY, z - minZ);
            case Direction.EAST -> new BoundingBox(x + minZ, y + minY, z - spanX, x + spanZ + minZ, y + spanY + minY, z + minX);
            default -> new BoundingBox(x + minX, y + minY, z + minZ, x + spanX + minX, y + spanY + minY, z + spanZ + minZ);
        };
    }

    public String toString() {
        return "TFLandmark{name='" + this.name + "'}";
    }

    static {
        NAME_2_TYPE = (ImmutableMap)Util.m_137537_(() -> ImmutableMap.builder().put((Object)"mushroom_tower", (Object)MUSHROOM_TOWER).put((Object)"small_hollow_hill", (Object)SMALL_HILL).put((Object)"medium_hollow_hill", (Object)MEDIUM_HILL).put((Object)"large_hollow_hill", (Object)LARGE_HILL).put((Object)"hedge_maze", (Object)HEDGE_MAZE).put((Object)"quest_grove", (Object)QUEST_GROVE).put((Object)"quest_island", (Object)QUEST_ISLAND).put((Object)"naga_courtyard", (Object)NAGA_COURTYARD).put((Object)"lich_tower", (Object)LICH_TOWER).put((Object)"hydra_lair", (Object)HYDRA_LAIR).put((Object)"labyrinth", (Object)LABYRINTH).put((Object)"dark_tower", (Object)DARK_TOWER).put((Object)"knight_stronghold", (Object)KNIGHT_STRONGHOLD).put((Object)"yeti_lairs", (Object)YETI_CAVE).put((Object)"ice_tower", (Object)ICE_TOWER).put((Object)"troll_lairs", (Object)TROLL_CAVE).put((Object)"final_castle", (Object)FINAL_CASTLE).build());
        CODEC = Codec.STRING.comapFlatMap(name -> NAME_2_TYPE.containsKey(name) ? DataResult.success((Object)((TFLandmark)NAME_2_TYPE.get(name))) : DataResult.error((String)("Landmark " + name + " not recognized!")), tfFeature -> tfFeature.name);
    }
}

