/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.stronghold;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.stronghold.StructureTFStrongholdComponent;

public class StrongholdUpperAscenderComponent
extends StructureTFStrongholdComponent {
    boolean exitTop;

    public StrongholdUpperAscenderComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFSUA.get(), nbt);
        this.exitTop = nbt.m_128471_("exitTop");
    }

    public StrongholdUpperAscenderComponent(TFLandmark feature, int i, Direction facing, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFSUA.get(), feature, i, facing, x, y, z);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128379_("exitTop", this.exitTop);
    }

    @Override
    public BoundingBox generateBoundingBox(Direction facing, int x, int y, int z) {
        if (y < -7) {
            this.exitTop = true;
            return BoundingBox.m_71031_((int)x, (int)y, (int)z, (int)-2, (int)-1, (int)0, (int)5, (int)10, (int)10, (Direction)facing);
        }
        this.exitTop = false;
        return BoundingBox.m_71031_((int)x, (int)y, (int)z, (int)-2, (int)-6, (int)0, (int)5, (int)10, (int)10, (Direction)facing);
    }

    @Override
    public void m_214092_(StructurePiece parent, StructurePieceAccessor list, RandomSource random) {
        super.m_214092_(parent, list, random);
        this.addNewUpperComponent(parent, list, random, Rotation.NONE, 2, this.exitTop ? 6 : 1, 10);
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.placeUpperStrongholdWalls(world, sbb, 0, 0, 0, 4, 9, 9, rand, this.deco.randomBlocks);
        this.placeSmallDoorwayAt(world, 2, 2, this.exitTop ? 1 : 6, 0, sbb);
        this.placeSmallDoorwayAt(world, 0, 2, this.exitTop ? 6 : 1, 9, sbb);
        if (this.exitTop) {
            this.makeStairsAt(world, 1, 3, Direction.NORTH, sbb);
            this.makeStairsAt(world, 2, 4, Direction.NORTH, sbb);
            this.makeStairsAt(world, 3, 5, Direction.NORTH, sbb);
            this.makeStairsAt(world, 4, 6, Direction.NORTH, sbb);
            this.makeStairsAt(world, 5, 7, Direction.NORTH, sbb);
            this.makePlatformAt(world, 5, 8, sbb);
        } else {
            this.makeStairsAt(world, 1, 6, Direction.NORTH, sbb);
            this.makeStairsAt(world, 2, 5, Direction.NORTH, sbb);
            this.makeStairsAt(world, 3, 4, Direction.NORTH, sbb);
            this.makeStairsAt(world, 4, 3, Direction.NORTH, sbb);
            this.makeStairsAt(world, 5, 2, Direction.NORTH, sbb);
            this.makePlatformAt(world, 5, 1, sbb);
        }
    }

    private void makeStairsAt(WorldGenLevel world, int y, int z, Direction facing, BoundingBox sbb) {
        if (this.m_73398_((BlockGetter)world, 0, y, z, sbb).m_60734_() != Blocks.f_50016_ || this.m_73398_((BlockGetter)world, 4, y, z, sbb).m_60734_() != Blocks.f_50016_) {
            for (int x = 1; x < 4; ++x) {
                this.m_73434_(world, (BlockState)Blocks.f_50194_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)facing.m_122424_()), x, y, z, sbb);
            }
        }
    }

    private void makePlatformAt(WorldGenLevel world, int y, int z, BoundingBox sbb) {
        if (this.m_73398_((BlockGetter)world, 0, y, z, sbb).m_60734_() != Blocks.f_50016_ || this.m_73398_((BlockGetter)world, 4, y, z, sbb).m_60734_() != Blocks.f_50016_) {
            for (int x = 1; x < 4; ++x) {
                this.m_73434_(world, Blocks.f_50222_.m_49966_(), x, y, z, sbb);
            }
        }
    }

    @Override
    public boolean isComponentProtected() {
        return false;
    }
}

