/*
 * Decompiled with CFR 0.152.
 */
package einstein.usefulslime.util;

import java.util.IdentityHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class BounceHandler {
    private static final IdentityHashMap<Entity, BounceHandler> bouncingEntities = new IdentityHashMap();
    public final LivingEntity entity;
    private int timer;
    private boolean wasInAir;
    private double bounce;
    private int bounceTick;
    private double lastMoveX;
    private double lastMoveZ;

    public BounceHandler(LivingEntity entity, double bounce) {
        this.entity = entity;
        this.timer = 0;
        this.wasInAir = false;
        this.bounce = bounce;
        this.bounceTick = bounce != 0.0 ? entity.f_19797_ : 0;
        bouncingEntities.put((Entity)entity, this);
    }

    @SubscribeEvent
    public void playerTick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player == this.entity && !event.player.m_21255_()) {
            if (event.player.f_19797_ == this.bounceTick) {
                Vec3 vec3 = event.player.m_20184_();
                event.player.m_20334_(vec3.f_82479_, this.bounce, vec3.f_82481_);
                this.bounceTick = 0;
            }
            if (!(this.entity.m_20096_() || this.entity.f_19797_ == this.bounceTick || this.lastMoveX == this.entity.m_20184_().f_82479_ && this.lastMoveZ == this.entity.m_20184_().f_82481_)) {
                double d = 0.935;
                Vec3 vec32 = this.entity.m_20184_();
                event.player.m_20334_(vec32.f_82479_ / 0.935, vec32.f_82480_, vec32.f_82481_ / 0.935);
                this.entity.f_19812_ = true;
                this.lastMoveX = this.entity.m_20184_().f_82479_;
                this.lastMoveZ = this.entity.m_20184_().f_82481_;
            }
            if (this.wasInAir && this.entity.m_20096_()) {
                if (this.timer == 0) {
                    this.timer = this.entity.f_19797_;
                } else if (this.entity.f_19797_ - this.timer > 5) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                    bouncingEntities.remove(this.entity);
                }
            } else {
                this.timer = 0;
                this.wasInAir = true;
            }
        }
    }

    public static void addBounceHandler(LivingEntity entity) {
        BounceHandler.addBounceHandler(entity, 0.0);
    }

    public static void addBounceHandler(LivingEntity entity, double bounce) {
        if (!(entity instanceof Player) || entity instanceof FakePlayer) {
            return;
        }
        BounceHandler handler = bouncingEntities.get(entity);
        if (handler == null) {
            MinecraftForge.EVENT_BUS.register((Object)new BounceHandler(entity, bounce));
        } else if (bounce != 0.0) {
            handler.bounce = bounce;
            handler.bounceTick = entity.f_19797_;
        }
    }
}

