/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.blay09.mods.waystones.client.gui.widget.RemoveWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.SortWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.WaystoneButton;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.blay09.mods.waystones.network.message.RemoveWaystoneMessage;
import net.blay09.mods.waystones.network.message.RequestEditWaystoneMessage;
import net.blay09.mods.waystones.network.message.SelectWaystoneMessage;
import net.blay09.mods.waystones.network.message.SortWaystoneMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public abstract class WaystoneSelectionScreenBase
extends AbstractContainerScreen<WaystoneSelectionMenu> {
    private final List<IWaystone> waystones;
    private List<IWaystone> filteredWaystones;
    private final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();
    private String searchText = "";
    private Button btnPrevPage;
    private Button btnNextPage;
    private EditBox searchBox;
    private int pageOffset;
    private int headerY;
    private boolean isLocationHeaderHovered;
    private int buttonsPerPage;
    private static final int headerHeight = 64;
    private static final int footerHeight = 25;
    private static final int entryHeight = 25;

    public WaystoneSelectionScreenBase(WaystoneSelectionMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.waystones = container.getWaystones();
        this.filteredWaystones = new ArrayList<IWaystone>(this.waystones);
        this.f_97726_ = 270;
        this.f_97727_ = 200;
    }

    public void m_7856_() {
        int maxContentHeight = (int)((float)this.f_96544_ * 0.6f);
        int maxButtonsPerPage = (maxContentHeight - 64 - 25) / 25;
        this.buttonsPerPage = Math.max(4, Math.min(maxButtonsPerPage, this.waystones.size()));
        int contentHeight = 64 + this.buttonsPerPage * 25 + 25;
        this.f_97726_ = this.f_96543_;
        this.f_97727_ = contentHeight;
        super.m_7856_();
        this.tooltipProviders.clear();
        this.btnPrevPage = new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 40, 95, 20, (Component)Component.m_237115_((String)"gui.waystones.waystone_selection.previous_page"), button -> {
            this.pageOffset = Screen.m_96638_() ? 0 : this.pageOffset - 1;
            this.updateList();
        });
        this.m_142416_(this.btnPrevPage);
        this.btnNextPage = new Button(this.f_96543_ / 2 + 5, this.f_96544_ / 2 + 40, 95, 20, (Component)Component.m_237115_((String)"gui.waystones.waystone_selection.next_page"), button -> {
            this.pageOffset = Screen.m_96638_() ? (this.waystones.size() - 1) / this.buttonsPerPage : this.pageOffset + 1;
            this.updateList();
        });
        this.m_142416_(this.btnNextPage);
        this.updateList();
        this.searchBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 99, this.f_97736_ + 64 - 24, 198, 20, (Component)Component.m_237119_());
        this.searchBox.m_94151_(text -> {
            this.pageOffset = 0;
            this.searchText = text;
            this.updateList();
        });
        this.m_142416_(this.searchBox);
    }

    protected <T extends GuiEventListener & Widget> T m_142416_(T widget) {
        if (widget instanceof ITooltipProvider) {
            this.tooltipProviders.add((ITooltipProvider)widget);
        }
        return (T)super.m_142416_(widget);
    }

    private void updateList() {
        this.filteredWaystones = this.waystones.stream().filter(waystone -> waystone.getName().toLowerCase().contains(this.searchText.toLowerCase())).collect(Collectors.toList());
        this.headerY = 0;
        this.btnPrevPage.f_93623_ = this.pageOffset > 0;
        this.btnNextPage.f_93623_ = this.pageOffset < (this.filteredWaystones.size() - 1) / this.buttonsPerPage;
        this.tooltipProviders.clear();
        Predicate<Object> removePredicate = button -> button instanceof WaystoneButton || button instanceof SortWaystoneButton || button instanceof RemoveWaystoneButton;
        ((ScreenAccessor)this).balm_getChildren().removeIf(removePredicate);
        ((ScreenAccessor)this).balm_getNarratables().removeIf(removePredicate);
        ((ScreenAccessor)this).balm_getRenderables().removeIf(removePredicate);
        int y = this.f_97736_ + 64 + this.headerY;
        for (int i = 0; i < this.buttonsPerPage; ++i) {
            int entryIndex = this.pageOffset * this.buttonsPerPage + i;
            if (entryIndex < 0 || entryIndex >= this.filteredWaystones.size()) continue;
            IWaystone waystone2 = this.filteredWaystones.get(entryIndex);
            this.m_142416_(this.createWaystoneButton(y, waystone2));
            if (this.allowSorting()) {
                SortWaystoneButton sortUpButton = new SortWaystoneButton(this.f_96543_ / 2 + 108, y + 2, -1, y, 20, it -> this.sortWaystone(entryIndex, -1));
                if (entryIndex == 0) {
                    sortUpButton.f_93623_ = false;
                }
                this.m_142416_(sortUpButton);
                SortWaystoneButton sortDownButton = new SortWaystoneButton(this.f_96543_ / 2 + 108, y + 13, 1, y, 20, it -> this.sortWaystone(entryIndex, 1));
                if (entryIndex == this.filteredWaystones.size() - 1) {
                    sortDownButton.f_93623_ = false;
                }
                this.m_142416_(sortDownButton);
            }
            if (this.allowDeletion()) {
                RemoveWaystoneButton removeButton = new RemoveWaystoneButton(this.f_96543_ / 2 + 122, y + 4, y, 20, waystone2, button -> {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    PlayerWaystoneManager.deactivateWaystone((Player)Objects.requireNonNull(player), waystone2);
                    Balm.getNetworking().sendToServer((Object)new RemoveWaystoneMessage(waystone2.getWaystoneUid()));
                    this.updateList();
                });
                if (!waystone2.isGlobal() || Minecraft.m_91087_().f_91074_.m_150110_().f_35937_) {
                    this.m_142416_(removeButton);
                }
            }
            y += 22;
        }
        this.btnPrevPage.f_93621_ = this.f_97736_ + this.headerY + 64 + this.buttonsPerPage * 22 + (this.filteredWaystones.size() > 0 ? 10 : 0);
        this.btnNextPage.f_93621_ = this.f_97736_ + this.headerY + 64 + this.buttonsPerPage * 22 + (this.filteredWaystones.size() > 0 ? 10 : 0);
    }

    private WaystoneButton createWaystoneButton(int y, IWaystone waystone) {
        IWaystone waystoneFrom = ((WaystoneSelectionMenu)this.f_97732_).getWaystoneFrom();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int xpLevelCost = Math.round(PlayerWaystoneManager.predictExperienceLevelCost((Entity)Objects.requireNonNull(player), waystone, ((WaystoneSelectionMenu)this.f_97732_).getWarpMode(), waystoneFrom));
        WaystoneButton btnWaystone = new WaystoneButton(this.f_96543_ / 2 - 100, y, waystone, xpLevelCost, button -> this.onWaystoneSelected(waystone));
        if (waystoneFrom != null && waystone.getWaystoneUid().equals(waystoneFrom.getWaystoneUid())) {
            btnWaystone.f_93623_ = false;
        }
        return btnWaystone;
    }

    protected void onWaystoneSelected(IWaystone waystone) {
        Balm.getNetworking().sendToServer((Object)new SelectWaystoneMessage(waystone.getWaystoneUid()));
    }

    private void sortWaystone(int index, int sortDir) {
        int otherIndex;
        if (index < 0 || index >= this.waystones.size()) {
            return;
        }
        if (Screen.m_96638_()) {
            otherIndex = sortDir == -1 ? -1 : this.waystones.size();
        } else {
            otherIndex = index + sortDir;
            if (otherIndex < 0 || otherIndex >= this.waystones.size()) {
                return;
            }
        }
        PlayerWaystoneManager.swapWaystoneSorting((Player)Minecraft.m_91087_().f_91074_, index, otherIndex);
        Balm.getNetworking().sendToServer((Object)new SortWaystoneMessage(index, otherIndex));
        this.updateList();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.isLocationHeaderHovered && ((WaystoneSelectionMenu)this.f_97732_).getWaystoneFrom() != null) {
            Balm.getNetworking().sendToServer((Object)new RequestEditWaystoneMessage(((WaystoneSelectionMenu)this.f_97732_).getWaystoneFrom().getWaystoneUid()));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        for (ITooltipProvider tooltipProvider : this.tooltipProviders) {
            if (!tooltipProvider.shouldShowTooltip()) continue;
            this.m_169388_(matrixStack, tooltipProvider.getTooltip(), Optional.empty(), mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack poseStack, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IWaystone fromWaystone = ((WaystoneSelectionMenu)this.f_97732_).getWaystoneFrom();
        WaystoneSelectionScreenBase.m_93215_((PoseStack)poseStack, (Font)fontRenderer, (Component)this.m_96636_(), (int)(this.f_97726_ / 2), (int)(this.headerY + (fromWaystone != null ? 20 : 0)), (int)0xFFFFFF);
        if (fromWaystone != null) {
            this.drawLocationHeader(poseStack, fromWaystone, mouseX, mouseY, this.f_97726_ / 2, this.headerY);
        }
        if (this.waystones.size() == 0) {
            WaystoneSelectionScreenBase.m_93208_((PoseStack)poseStack, (Font)fontRenderer, (String)(ChatFormatting.RED + I18n.m_118938_((String)"gui.waystones.waystone_selection.no_waystones_activated", (Object[])new Object[0])), (int)(this.f_97726_ / 2), (int)(this.f_97727_ / 2 - 20), (int)0xFFFFFF);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawLocationHeader(PoseStack matrixStack, IWaystone waystone, int mouseX, int mouseY, int x, int y) {
        fontRenderer = Minecraft.m_91087_().f_91062_;
        locationPrefix = ChatFormatting.YELLOW + I18n.m_118938_((String)"gui.waystones.waystone_selection.current_location", (Object[])new Object[0]) + " ";
        locationPrefixWidth = fontRenderer.m_92895_(locationPrefix);
        effectiveName = waystone.getName();
        if (effectiveName.isEmpty()) {
            effectiveName = I18n.m_118938_((String)"gui.waystones.waystone_selection.unnamed_waystone", (Object[])new Object[0]);
        }
        locationWidth = fontRenderer.m_92895_(effectiveName);
        fullWidth = locationPrefixWidth + locationWidth;
        startX = x - fullWidth / 2 + locationPrefixWidth;
        startY = y + this.f_97736_;
        if (mouseX < startX || mouseX >= startX + locationWidth + 16 || mouseY < startY) ** GOTO lbl-1000
        Objects.requireNonNull(fontRenderer);
        if (mouseY < startY + 9) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.isLocationHeaderHovered = v0;
        player = Minecraft.m_91087_().f_91074_;
        waystoneEditPermissions = PlayerWaystoneManager.mayEditWaystone((Player)player, player.f_19853_, waystone);
        fullText = locationPrefix + ChatFormatting.WHITE;
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            fullText = fullText + ChatFormatting.UNDERLINE;
        }
        fullText = fullText + effectiveName;
        WaystoneSelectionScreenBase.m_93236_((PoseStack)matrixStack, (Font)fontRenderer, (String)fullText, (int)(x - fullWidth / 2), (int)y, (int)0xFFFFFF);
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)((float)x + (float)fullWidth / 2.0f + 4.0f), (double)y, 0.0);
            scale = 0.5f;
            matrixStack.m_85841_(scale, scale, scale);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            Minecraft.m_91087_().m_91291_().m_115203_(new ItemStack((ItemLike)Items.f_42614_), 0, 0);
            matrixStack.m_85849_();
        }
    }

    protected boolean allowSorting() {
        return true;
    }

    protected boolean allowDeletion() {
        return true;
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (!this.searchBox.m_93696_() || key == 256 && this.m_6913_()) {
            return super.m_7933_(key, scanCode, modifiers);
        }
        return this.searchBox.m_7933_(key, scanCode, modifiers);
    }
}

