/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.zapsconverter.block.entity;

import cy.jdkdigital.zapsconverter.Config;
import cy.jdkdigital.zapsconverter.ZapsConverter;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ConverterBlockEntity
extends BlockEntity {
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(100000));
    private List<EnergyHandler> recipients;
    private boolean hasLoaded = false;

    public ConverterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ZapsConverter.CONVERTER_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public static void serverTicker(Level level, BlockPos blockPos, BlockState blockState, ConverterBlockEntity blockEntity) {
        if (!blockEntity.hasLoaded) {
            blockEntity.refreshConnectedTileEntityCache(blockState);
            blockEntity.hasLoaded = true;
        }
        blockEntity.energyHandler.ifPresent(h -> {
            int drainedPower = blockEntity.outputPower(h.getEnergyStored() / (Integer)Config.SERVER.conversionRate.get());
            h.extractEnergy(drainedPower * (Integer)Config.SERVER.conversionRate.get(), false);
        });
    }

    private int outputPower(int energy) {
        if (energy <= 0) {
            return 0;
        }
        int drainedZaps = 0;
        if (this.recipients.size() > 0) {
            for (EnergyHandler storage : this.recipients) {
                if (storage.isEnergyHandlerInvalid() || storage.getEnergy() == storage.getEnergyCapacity()) continue;
                double a = storage.insertEnergy(Math.min(storage.getMaxInputEnergy(), (double)energy), false);
                if (a > 0.0) {
                    drainedZaps = (int)((double)drainedZaps + a);
                    energy = (int)((double)energy - a);
                    this.m_6596_();
                }
                if (energy != 0) continue;
                break;
            }
        }
        return drainedZaps;
    }

    public void refreshConnectedTileEntityCache(BlockState state) {
        if (this.f_58857_ instanceof ServerLevel) {
            ArrayList<EnergyHandler> recipients = new ArrayList<EnergyHandler>();
            for (Direction direction : FTBICUtils.DIRECTIONS) {
                EnergyHandler handler;
                BlockEntity entity;
                if (direction.equals((Object)state.m_61143_((Property)DirectionalBlock.f_52588_)) || (entity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction))) == null) continue;
                EnergyHandler energyHandler = handler = entity instanceof EnergyHandler ? (EnergyHandler)entity : null;
                if (handler == null || !(handler.getMaxInputEnergy() > 0.0) || handler.isBurnt() || !handler.isValidEnergyInputSide(direction.m_122424_())) continue;
                recipients.add(handler);
            }
            this.recipients = recipients;
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side != null && side.equals((Object)this.m_58900_().m_61143_((Property)DirectionalBlock.f_52588_))) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("energy")) {
            this.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> ((EnergyStorage)handler).deserializeNBT(tag.m_128423_("energy")));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> tag.m_128365_("energy", ((EnergyStorage)handler).serializeNBT()));
    }
}

