/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.entry.creativetab;

import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.ForgeRegistries;
import plus.dragons.createcentralkitchen.CentralKitchen;
import plus.dragons.createcentralkitchen.entry.item.FDItemEntries;
import plus.dragons.createcentralkitchen.entry.item.FRItemEntries;
import plus.dragons.createcentralkitchen.entry.item.MDItemEntries;
import plus.dragons.createcentralkitchen.foundation.utility.Mods;

public class CckCreativeModeTab
extends CreativeModeTab {
    public static final ItemEntry<Item> ICON = CentralKitchen.REGISTRATE.item("creative_tab_icon", Item::new).lang("CreativeTabIcon").properties(prop -> prop.m_41487_(1)).register();

    public CckCreativeModeTab() {
        super("base");
    }

    public Component m_40786_() {
        return Component.m_237113_((String)"CCK");
    }

    public ItemStack m_6976_() {
        return ICON.asStack();
    }

    public void m_6151_(NonNullList<ItemStack> pItems) {
        ArrayList<Item> items = new ArrayList<Item>();
        items.addAll(this.collectItems());
        items.addAll(this.collectBlocks());
        items.addAll(this.collectFluid());
        CckCreativeModeTab.filterAndOutput(pItems, items);
    }

    private List<Item> collectBlocks() {
        ReferenceArrayList items = new ReferenceArrayList();
        for (RegistryEntry entry : CentralKitchen.REGISTRATE.getAll(ForgeRegistries.BLOCKS.getRegistryKey())) {
            Item item = ((Block)entry.get()).m_5456_();
            if (item == Items.f_41852_) continue;
            items.add(item);
        }
        items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
        return items;
    }

    private List<Item> collectItems() {
        ReferenceArrayList items = new ReferenceArrayList();
        for (RegistryEntry entry : CentralKitchen.REGISTRATE.getAll(ForgeRegistries.ITEMS.getRegistryKey())) {
            Item item = (Item)entry.get();
            if (item instanceof BlockItem || item instanceof BucketItem) continue;
            items.add(item);
        }
        return items;
    }

    private List<Item> collectFluid() {
        ReferenceArrayList items = new ReferenceArrayList();
        for (RegistryEntry entry : CentralKitchen.REGISTRATE.getAll(ForgeRegistries.FLUIDS.getRegistryKey())) {
            ForgeFlowingFluid fluid = (ForgeFlowingFluid)entry.get();
            if (fluid.m_6859_() == Items.f_41852_ || items.contains(fluid.m_6859_())) continue;
            items.add(fluid.m_6859_());
        }
        return items;
    }

    private static void filterAndOutput(NonNullList<ItemStack> pItems, List<Item> items) {
        for (Item item : items) {
            String id = ForgeRegistries.ITEMS.getKey((Object)item).toString();
            if (id.contains("incomplete") || id.contains("guide") || id.contains("blaze_burner") || id.contains("creative_tab_icon")) continue;
            pItems.add((Object)item.m_7968_());
        }
        if (Mods.isLoaded("farmersdelight")) {
            pItems.add((Object)FDItemEntries.COOKING_GUIDE.asStack());
        }
        if (Mods.isLoaded("farmersrespite")) {
            pItems.add((Object)FRItemEntries.BREWING_GUIDE.asStack());
        }
        if (Mods.isLoaded("miners_delight")) {
            pItems.add((Object)MDItemEntries.MINERS_COOKING_GUIDE.asStack());
        }
    }
}

