/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import plus.dragons.createcentralkitchen.foundation.data.recipe.builder.ConditionedRecipeBuilder;

public class ConditionedCookingRecipeBuilder
implements ConditionedRecipeBuilder<ConditionedCookingRecipeBuilder> {
    private final Item result;
    private final DataIngredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final SimpleCookingSerializer<?> serializer;
    private final List<ICondition> conditions = new ArrayList<ICondition>();

    private ConditionedCookingRecipeBuilder(ItemLike result, DataIngredient ingredient, float experience, int cookingTime, SimpleCookingSerializer<?> serializer) {
        this.result = result.m_5456_();
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.serializer = serializer;
    }

    public static ConditionedCookingRecipeBuilder cooking(DataIngredient ingredient, ItemLike result, float experience, int cookingTime, SimpleCookingSerializer<?> serializer) {
        return new ConditionedCookingRecipeBuilder(result, ingredient, experience, cookingTime, serializer);
    }

    public static ConditionedCookingRecipeBuilder campfireCooking(DataIngredient ingredient, ItemLike result, float experience, int cookingTime) {
        return ConditionedCookingRecipeBuilder.cooking(ingredient, result, experience, cookingTime, RecipeSerializer.f_44094_);
    }

    public static ConditionedCookingRecipeBuilder blasting(DataIngredient ingredient, ItemLike result, float experience, int cookingTime) {
        return ConditionedCookingRecipeBuilder.cooking(ingredient, result, experience, cookingTime, RecipeSerializer.f_44092_);
    }

    public static ConditionedCookingRecipeBuilder smelting(DataIngredient ingredient, ItemLike result, float experience, int cookingTime) {
        return ConditionedCookingRecipeBuilder.cooking(ingredient, result, experience, cookingTime, RecipeSerializer.f_44091_);
    }

    public static ConditionedCookingRecipeBuilder smoking(DataIngredient ingredient, ItemLike result, float experience, int cookingTime) {
        return ConditionedCookingRecipeBuilder.cooking(ingredient, result, experience, cookingTime, RecipeSerializer.f_44093_);
    }

    public ConditionedCookingRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public ConditionedCookingRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    @Override
    public ConditionedCookingRecipeBuilder withCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, ForgeRegistries.ITEMS.getKey((Object)this.result));
    }

    @Override
    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        id = new ResourceLocation(id.m_135827_(), ForgeRegistries.RECIPE_SERIALIZERS.getKey(this.serializer).m_135815_() + "/" + id.m_135815_());
        if (consumer instanceof RegistrateRecipeProvider) {
            RegistrateRecipeProvider prov = (RegistrateRecipeProvider)consumer;
            this.unlockedBy("has_" + prov.safeName(this.ingredient.getId()), (CriterionTriggerInstance)this.ingredient.getCritereon(prov));
        }
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept((FinishedRecipe)new Result(id, this.group == null ? "" : this.group, (Ingredient)this.ingredient, this.result, this.experience, this.cookingTime, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_()), (RecipeSerializer<? extends AbstractCookingRecipe>)this.serializer, this.conditions));
    }

    public static class Result
    extends SimpleCookingRecipeBuilder.Result {
        private final boolean serializeAdvancement;
        private final List<ICondition> conditions;

        public Result(ResourceLocation id, String group, Ingredient ingredient, Item result, float experience, int cookingTime, Advancement.Builder advancement, ResourceLocation advancementId, RecipeSerializer<? extends AbstractCookingRecipe> serializer, List<ICondition> conditions) {
            super(id, group, ingredient, result, experience, cookingTime, advancement, advancementId, serializer);
            this.serializeAdvancement = !advancement.m_138405_().isEmpty() && conditions.isEmpty();
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            if (!this.conditions.isEmpty()) {
                JsonArray conds = new JsonArray();
                this.conditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
                json.add("conditions", (JsonElement)conds);
            }
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.serializeAdvancement ? super.m_5860_() : null;
        }
    }
}

