/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.be;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.display.FlapDisplayBlock;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.block.AbstractAdvancedDisplayBlock;
import de.mrjulsen.crn.block.be.IColorableBlockEntity;
import de.mrjulsen.crn.block.be.IContraptionBlockEntity;
import de.mrjulsen.crn.block.be.IMultiblockBlockEntity;
import de.mrjulsen.crn.block.display.AdvancedDisplaySource;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.data.CarriageData;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.EDisplayInfo;
import de.mrjulsen.crn.data.EDisplayType;
import de.mrjulsen.crn.data.IBlockEntitySerializable;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.cts.TrainDataRequestPacket;
import de.mrjulsen.mcdragonlib.block.IBERInstance;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class AdvancedDisplayBlockEntity
extends SmartBlockEntity
implements IMultiblockBlockEntity<AdvancedDisplayBlockEntity, AbstractAdvancedDisplayBlock>,
IContraptionBlockEntity<AdvancedDisplayBlockEntity>,
IBERInstance<AdvancedDisplayBlockEntity>,
IBlockEntitySerializable,
IColorableBlockEntity {
    private static final String NBT_XSIZE = "XSize";
    private static final String NBT_YSIZE = "YSize";
    private static final String NBT_CONTROLLER = "IsController";
    private static final String NBT_COLOR = "Color";
    private static final String NBT_GLOWING = "Glowing";
    private static final String NBT_INFO_TYPE = "InfoType";
    private static final String NBT_DISPLAY_TYPE = "DisplayType";
    private static final String NBT_PREDICTIONS = "Predictions";
    private static final String NBT_NEXT_DEPARTURE_STOPOVERS = "NextStopovers";
    private static final String NBT_FILTER = "Filter";
    private static final String NBT_LAST_REFRESH_TIME = "LastRefreshed";
    private static final String NBT_PLATFORM_WIDTH = "PlatformWidth";
    private static final String NBT_TRAIN_NAME_WIDTH = "TrainNameWidth";
    private static final String NBT_TIME_DISPLAY = "TimeDisplay";
    public static final byte MAX_XSIZE = 16;
    public static final byte MAX_YSIZE = 16;
    private static final int REFRESH_FREQUENCY = 100;
    private byte xSize = 1;
    private byte ySize = 1;
    private boolean isController;
    private List<DeparturePrediction.SimpleDeparturePrediction> predictions;
    private List<String> nextDepartureStopovers;
    private String stationNameFilter;
    private TrainStationAlias.StationInfo stationInfo;
    private byte trainNameWidth;
    private byte platformWidth;
    private AdvancedDisplaySource.ETimeDisplay timeDisplay = AdvancedDisplaySource.ETimeDisplay.ABS;
    private int color = DyeColor.WHITE.m_41071_();
    private boolean glowing = false;
    private EDisplayInfo infoType = EDisplayInfo.SIMPLE;
    private EDisplayType displayType = EDisplayType.TRAIN_DESTINATION;
    private long lastRefreshedTime;
    private TrainDataRequestPacket.TrainData trainData = TrainDataRequestPacket.TrainData.empty();
    private CarriageData carriageData = new CarriageData(0, Direction.NORTH, false);
    private int syncTicks = 99;
    private final Cache<IBlockEntityRendererInstance<AdvancedDisplayBlockEntity>> renderer = new Cache(() -> new AdvancedDisplayRenderInstance(this));
    public final Cache<DeparturePrediction.TrainExitSide> relativeExitDirection = new Cache(() -> {
        if (this.getCarriageData() == null || !this.getTrainData().getNextStop().isPresent() || !(this.m_58900_().m_60734_() instanceof AbstractAdvancedDisplayBlock)) {
            return DeparturePrediction.TrainExitSide.UNKNOWN;
        }
        DeparturePrediction.TrainExitSide side = this.getTrainData().getNextStop().get().exitSide();
        Direction blockFacing = (Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (!this.carriageData.isOppositeDirection()) {
            blockFacing = blockFacing.m_122424_();
        }
        DeparturePrediction.TrainExitSide result = side;
        if (this.getCarriageData().assemblyDirection() == blockFacing) {
            result = result.getOpposite();
        } else if (this.getCarriageData().assemblyDirection().m_122424_() != blockFacing) {
            result = DeparturePrediction.TrainExitSide.UNKNOWN;
        }
        return result;
    });
    public final Cache<Tripple<Float, Float, Float>> renderRotation = new Cache(() -> {
        Block patt6212$temp = this.m_58900_().m_60734_();
        if (patt6212$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt6212$temp;
            return block.getRenderRotation(this.f_58857_, this.m_58900_(), this.f_58858_);
        }
        return Tripple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderOffset = new Cache(() -> {
        Block patt6532$temp = this.m_58900_().m_60734_();
        if (patt6532$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt6532$temp;
            return block.getRenderOffset(this.f_58857_, this.m_58900_(), this.f_58858_);
        }
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderZOffset = new Cache(() -> {
        Block patt6842$temp = this.m_58900_().m_60734_();
        if (patt6842$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt6842$temp;
            return block.getRenderZOffset(this.f_58857_, this.m_58900_(), this.f_58858_);
        }
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderAspectRatio = new Cache(() -> {
        Block patt7157$temp = this.m_58900_().m_60734_();
        if (patt7157$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt7157$temp;
            Pair<Float, Float> raw = block.getRenderAspectRatio(this.f_58857_, this.m_58900_(), this.f_58858_);
            float scale = 1.0f / Math.min(((Float)raw.getFirst()).floatValue(), ((Float)raw.getSecond()).floatValue());
            return Pair.of((Object)Float.valueOf(((Float)raw.getFirst()).floatValue() * scale), (Object)Float.valueOf(((Float)raw.getSecond()).floatValue() * scale));
        }
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    });
    public final Cache<Float> renderScale = new Cache(() -> Float.valueOf(1.0f / Math.max(((Float)((Pair)this.renderAspectRatio.get()).getFirst()).floatValue(), ((Float)((Pair)this.renderAspectRatio.get()).getSecond()).floatValue())));

    public AdvancedDisplayBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.reset();
    }

    public TrainDataRequestPacket.TrainData getTrainData() {
        return this.trainData;
    }

    public CarriageData getCarriageData() {
        return this.carriageData;
    }

    public long getLastRefreshedTime() {
        return this.lastRefreshedTime;
    }

    public byte getTrainNameWidth() {
        return this.trainNameWidth;
    }

    public AdvancedDisplaySource.ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    public byte getPlatformWidth() {
        return this.platformWidth;
    }

    public byte getXSize() {
        return this.xSize;
    }

    public byte getXSizeScaled() {
        return (byte)((float)this.getXSize() * ((Float)((Pair)this.renderAspectRatio.get()).getFirst()).floatValue());
    }

    public byte getYSize() {
        return this.ySize;
    }

    public byte getYSizeScaled() {
        return (byte)((float)this.getYSize() * ((Float)((Pair)this.renderAspectRatio.get()).getSecond()).floatValue());
    }

    @Override
    public boolean isController() {
        return this.isController;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean isGlowing() {
        return this.glowing;
    }

    public EDisplayInfo getInfoType() {
        return this.infoType;
    }

    public EDisplayType getDisplayType() {
        return this.displayType;
    }

    @Override
    public byte getMaxWidth() {
        return 16;
    }

    @Override
    public byte getMaxHeight() {
        return 16;
    }

    @Override
    public byte getWidth() {
        return this.xSize;
    }

    @Override
    public byte getHeight() {
        return this.ySize;
    }

    @Override
    public Class<AbstractAdvancedDisplayBlock> getBlockType() {
        return AbstractAdvancedDisplayBlock.class;
    }

    @Override
    public Class<AdvancedDisplayBlockEntity> getBlockEntityType() {
        return AdvancedDisplayBlockEntity.class;
    }

    public List<DeparturePrediction.SimpleDeparturePrediction> getPredictions() {
        return this.predictions;
    }

    public List<String> getNextDepartureStopovers() {
        return this.nextDepartureStopovers;
    }

    public boolean isPlatformFixed() {
        return !this.stationNameFilter.contains("*");
    }

    public TrainStationAlias.StationInfo getStationInfo() {
        return this.stationInfo;
    }

    public String getStationNameFilter() {
        return this.stationNameFilter;
    }

    public boolean isSingleLine() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block2 = (AbstractAdvancedDisplayBlock)block;
            return !(!block2.isSingleLined() && (this.getDisplayType() == EDisplayType.PASSENGER_INFORMATION && this.getInfoType() == EDisplayInfo.INFORMATIVE || this.getDisplayType() == EDisplayType.PLATFORM && this.getInfoType() == EDisplayInfo.DETAILED || this.getDisplayType() == EDisplayType.PLATFORM && this.getInfoType() == EDisplayInfo.INFORMATIVE));
        }
        return false;
    }

    public int getPlatformInfoLinesCount() {
        switch (this.getInfoType()) {
            default: {
                return 32;
            }
            case DETAILED: {
                return this.getYSize() * 3 - 1;
            }
            case INFORMATIVE: 
        }
        return this.getYSize() * 3 - 2;
    }

    public void setColor(int color) {
        this.color = color;
        if (this.f_58857_.f_46443_) {
            this.getRenderer().update(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
        if (this.f_58857_.f_46443_) {
            this.getRenderer().update(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    public void setInfoType(EDisplayInfo type) {
        this.infoType = type;
        if (this.f_58857_.f_46443_) {
            this.getRenderer().update(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    public void setDisplayType(EDisplayType type) {
        this.displayType = type;
        if (this.f_58857_.f_46443_) {
            this.getRenderer().update(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    public void setDepartureData(List<DeparturePrediction.SimpleDeparturePrediction> predictions, List<String> nextDepartureStopovers, String stationNameFilter, TrainStationAlias.StationInfo staionInfo, long lastRefreshedTime, byte platformWidth, byte trainNameWidth, byte timeDisplayId) {
        this.predictions = predictions.stream().sorted(Comparator.comparingInt(x -> x.departureTicks())).toList();
        this.stationNameFilter = stationNameFilter;
        this.stationInfo = staionInfo;
        this.nextDepartureStopovers = nextDepartureStopovers;
        this.lastRefreshedTime = lastRefreshedTime;
        this.platformWidth = platformWidth;
        this.trainNameWidth = trainNameWidth;
        this.timeDisplay = AdvancedDisplaySource.ETimeDisplay.getById(timeDisplayId);
    }

    @Override
    public boolean connectable(BlockGetter getter, BlockPos a, BlockPos b) {
        if (getter == null || a == null || b == null) {
            return false;
        }
        BlockEntity blockEntity = getter.m_7702_(a);
        if (blockEntity instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity be1 = (AdvancedDisplayBlockEntity)blockEntity;
            blockEntity = getter.m_7702_(b);
            if (blockEntity instanceof AdvancedDisplayBlockEntity) {
                AdvancedDisplayBlockEntity be2 = (AdvancedDisplayBlockEntity)blockEntity;
                blockEntity = be1.m_58900_().m_60734_();
                if (blockEntity instanceof AbstractAdvancedDisplayBlock) {
                    AbstractAdvancedDisplayBlock block1 = (AbstractAdvancedDisplayBlock)blockEntity;
                    blockEntity = be2.m_58900_().m_60734_();
                    if (blockEntity instanceof AbstractAdvancedDisplayBlock) {
                        AbstractAdvancedDisplayBlock block2 = (AbstractAdvancedDisplayBlock)blockEntity;
                        return block1 == block2 && be1.getDisplayType() == be2.getDisplayType() && be1.getInfoType() == be2.getInfoType() && block1.canConnectWithBlock(getter, a, b) && block2.canConnectWithBlock(getter, b, a) && (!a.m_7494_().equals((Object)b) || (Boolean)be1.m_58900_().m_61143_((Property)AbstractAdvancedDisplayBlock.UP) != false && !be1.isSingleLine()) && (!a.m_7495_().equals((Object)b) || (Boolean)be1.m_58900_().m_61143_((Property)AbstractAdvancedDisplayBlock.DOWN) != false && !be1.isSingleLine());
                    }
                }
            }
        }
        return false;
    }

    public AdvancedDisplayBlockEntity getController() {
        AdvancedDisplayBlockEntity flap;
        BlockEntity found;
        int i;
        if (this.isController()) {
            return this;
        }
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof AbstractAdvancedDisplayBlock)) {
            return null;
        }
        BlockPos.MutableBlockPos pos = this.m_58899_().m_122032_();
        Direction side = ((Direction)blockState.m_61143_((Property)AbstractAdvancedDisplayBlock.FACING)).m_122427_();
        for (i = 0; i < this.getMaxWidth(); ++i) {
            if (!this.connectable((BlockGetter)this.f_58857_, (BlockPos)pos, pos.m_121945_(side))) {
                found = this.f_58857_.m_7702_((BlockPos)pos);
                if (!(found instanceof AdvancedDisplayBlockEntity)) break;
                flap = (AdvancedDisplayBlockEntity)found;
                if (!flap.isController) break;
                return flap;
            }
            pos.m_122173_(side);
        }
        for (i = 0; i < this.getMaxHeight(); ++i) {
            if (!this.connectable((BlockGetter)this.f_58857_, (BlockPos)pos, pos.m_121945_(Direction.UP))) {
                found = this.f_58857_.m_7702_((BlockPos)pos);
                if (!(found instanceof AdvancedDisplayBlockEntity)) break;
                flap = (AdvancedDisplayBlockEntity)found;
                if (!flap.isController) break;
                return flap;
            }
            pos.m_122173_(Direction.UP);
        }
        return null;
    }

    public void copyFrom(AdvancedDisplayBlockEntity other) {
        if (this.getColor() == other.getColor() && this.getInfoType() == other.getInfoType() && this.getDisplayType() == other.getDisplayType() && this.isGlowing() == other.isGlowing()) {
            return;
        }
        this.color = other.getColor();
        this.glowing = other.isGlowing();
        this.displayType = other.getDisplayType();
        this.infoType = other.getInfoType();
        this.notifyUpdate();
    }

    public void reset() {
        this.predictions = List.of();
        this.nextDepartureStopovers = List.of();
        this.stationNameFilter = "";
        this.platformWidth = (byte)-1;
        this.trainNameWidth = (byte)16;
        this.xSize = 1;
        this.ySize = 1;
        this.isController = false;
        this.stationInfo = TrainStationAlias.StationInfo.empty();
    }

    public void updateControllerStatus() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof AbstractAdvancedDisplayBlock)) {
            return;
        }
        Direction leftDirection = ((Direction)blockState.m_61143_((Property)AbstractAdvancedDisplayBlock.FACING)).m_122427_();
        boolean shouldBeController = !this.connectable((BlockGetter)this.f_58857_, this.f_58858_, this.f_58858_.m_121945_(leftDirection)) && !this.connectable((BlockGetter)this.f_58857_, this.f_58858_, this.f_58858_.m_7494_());
        int newXSize = 1;
        byte newYSize = 1;
        if (shouldBeController) {
            BlockPos relPos;
            for (int xOffset = 1; xOffset < this.getMaxWidth() && this.f_58857_.m_8055_(relPos = this.f_58858_.m_5484_(leftDirection.m_122424_(), xOffset)) == blockState; ++xOffset) {
                newXSize = (byte)(newXSize + 1);
            }
            if (!this.isSingleLine()) {
                for (int yOffset = 0; yOffset < this.getMaxHeight(); ++yOffset) {
                    BlockPos downPos = this.f_58858_.m_5484_(Direction.DOWN, yOffset);
                    for (int i = 0; i < newXSize; ++i) {
                        AdvancedDisplayBlockEntity be;
                        BlockPos relPos2 = downPos.m_5484_(leftDirection.m_122424_(), i);
                        BlockEntity blockEntity = this.f_58857_.m_7702_(relPos2);
                        if (!(blockEntity instanceof AdvancedDisplayBlockEntity) || (be = (AdvancedDisplayBlockEntity)blockEntity) == this) continue;
                        be.copyFrom(this);
                    }
                    if (!this.connectable((BlockGetter)this.f_58857_, downPos, downPos.m_7495_())) break;
                    newYSize = (byte)(newYSize + 1);
                }
            }
        }
        if (this.isController == shouldBeController && newXSize == this.xSize && newYSize == this.ySize) {
            return;
        }
        this.isController = shouldBeController;
        this.xSize = newXSize;
        this.ySize = newYSize;
        if (!this.isController) {
            this.reset();
        }
        this.notifyUpdate();
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            this.getRenderer().tick(this.f_58857_, this.m_58899_(), this.m_58900_(), (BlockEntity)this);
        }
        super.tick();
        if (this.getDisplayType().getSource() != EDisplayType.EDisplayTypeDataSource.PLATFORM) {
            return;
        }
        ++this.syncTicks;
        if ((this.syncTicks %= 100) == 0 && this.f_58857_.f_46443_) {
            boolean shouldUpdate;
            boolean bl = shouldUpdate = this.getPredictions().size() > 0;
            if (shouldUpdate) {
                this.getRenderer().update(this.f_58857_, this.m_58899_(), this.m_58900_(), (BlockEntity)this, IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED);
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.updateControllerStatus();
    }

    @Override
    public void contraptionTick(Level level, BlockPos pos, BlockState state, Contraption contraption) {
        this.getRenderer().tick(level, pos, state, (BlockEntity)this);
        if (!this.isController()) {
            return;
        }
        if (this.getDisplayType().getSource() != EDisplayType.EDisplayTypeDataSource.TRAIN_INFORMATION) {
            return;
        }
        ++this.syncTicks;
        if ((this.syncTicks %= 100) == 0) {
            CarriageContraption carriage = (CarriageContraption)contraption;
            long id = InstanceManager.registerClientTrainDataResponseAction((data, refreshTime) -> {
                if (data == null) {
                    return;
                }
                boolean shouldUpdate = false;
                if (this.trainData != null && this.trainData.getNextStop().isPresent() && data.getNextStop().isPresent()) {
                    DeparturePrediction.SimpleDeparturePrediction prediction = this.trainData.getNextStop().get();
                    shouldUpdate = !this.trainData.trainName().equals(data.trainName()) || !prediction.scheduleTitle().equals(data.predictions().get(0).scheduleTitle()) || !prediction.stationTagName().equals(data.predictions().get(0).stationTagName()) || this.trainData.getNextStop().get().exitSide() != data.getNextStop().get().exitSide() || this.getInfoType() == EDisplayInfo.INFORMATIVE && this.getDisplayType() == EDisplayType.PASSENGER_INFORMATION && (long)this.trainData.getNextStop().get().departureTicks() + this.lastRefreshedTime != (long)data.getNextStop().get().departureTicks() + refreshTime;
                }
                this.lastRefreshedTime = refreshTime;
                this.trainData = data;
                this.carriageData = new CarriageData(((CarriageContraptionEntity)carriage.entity).carriageIndex, carriage.getAssemblyDirection(), data.isOppositeDirection());
                this.relativeExitDirection.clear();
                if (shouldUpdate) {
                    this.getRenderer().update(level, pos, state, (BlockEntity)this, IBlockEntityRendererInstance.EUpdateReason.DATA_CHANGED);
                }
            });
            CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new TrainDataRequestPacket(id, ((CarriageContraptionEntity)carriage.entity).trainId, true));
        }
    }

    protected void write(CompoundTag pTag, boolean clientPacket) {
        super.write(pTag, clientPacket);
        pTag.m_128344_(NBT_XSIZE, this.getXSize());
        pTag.m_128344_(NBT_YSIZE, this.getYSize());
        pTag.m_128405_(NBT_COLOR, this.getColor());
        pTag.m_128379_(NBT_CONTROLLER, this.isController());
        pTag.m_128405_(NBT_INFO_TYPE, this.getInfoType().getId());
        pTag.m_128405_(NBT_DISPLAY_TYPE, this.getDisplayType().getId());
        pTag.m_128359_(NBT_FILTER, this.getStationNameFilter());
        pTag.m_128379_(NBT_GLOWING, this.isGlowing());
        pTag.m_128356_(NBT_LAST_REFRESH_TIME, this.getLastRefreshedTime());
        pTag.m_128344_(NBT_PLATFORM_WIDTH, this.getPlatformWidth());
        pTag.m_128344_(NBT_TRAIN_NAME_WIDTH, this.getTrainNameWidth());
        pTag.m_128344_(NBT_TIME_DISPLAY, this.getTimeDisplay().getId());
        this.getStationInfo().writeNbt(pTag);
        if (this.getPredictions() != null && !this.getPredictions().isEmpty()) {
            ListTag list = new ListTag();
            list.addAll(this.getPredictions().stream().map(x -> x.toNbt()).toList());
            pTag.m_128365_(NBT_PREDICTIONS, (Tag)list);
        }
        if (this.getNextDepartureStopovers() != null && !this.getNextDepartureStopovers().isEmpty()) {
            ListTag stopovers = new ListTag();
            stopovers.addAll(this.getNextDepartureStopovers().stream().map(x -> StringTag.m_129297_((String)x)).toList());
            pTag.m_128365_(NBT_NEXT_DEPARTURE_STOPOVERS, (Tag)stopovers);
        }
    }

    public void read(CompoundTag pTag, boolean clientPacket) {
        boolean updateClient = false;
        if (this.f_58857_ != null && this.m_58900_() != null && this.f_58857_.f_46443_ && (this.isController() != pTag.m_128471_(NBT_CONTROLLER) || this.getXSize() != pTag.m_128445_(NBT_XSIZE) || this.getYSize() != pTag.m_128445_(NBT_YSIZE) || this.getPlatformWidth() != pTag.m_128445_(NBT_PLATFORM_WIDTH) || this.getTrainNameWidth() != pTag.m_128445_(NBT_TRAIN_NAME_WIDTH) || this.getPredictions().isEmpty() ^ !pTag.m_128441_(NBT_PREDICTIONS))) {
            updateClient = true;
        }
        super.read(pTag, clientPacket);
        TrainStationAlias.StationInfo info = TrainStationAlias.StationInfo.fromNbt(pTag);
        this.xSize = pTag.m_128445_(NBT_XSIZE);
        this.ySize = pTag.m_128445_(NBT_YSIZE);
        this.color = pTag.m_128451_(NBT_COLOR);
        this.glowing = pTag.m_128471_(NBT_GLOWING);
        this.isController = pTag.m_128471_(NBT_CONTROLLER);
        this.infoType = EDisplayInfo.getTypeById(pTag.m_128451_(NBT_INFO_TYPE));
        this.displayType = EDisplayType.getTypeById(pTag.m_128451_(NBT_DISPLAY_TYPE));
        this.setDepartureData(pTag.m_128441_(NBT_PREDICTIONS) ? new ArrayList<DeparturePrediction.SimpleDeparturePrediction>(pTag.m_128437_(NBT_PREDICTIONS, 10).stream().map(x -> DeparturePrediction.SimpleDeparturePrediction.fromNbt((CompoundTag)x)).toList()) : new ArrayList(), pTag.m_128441_(NBT_NEXT_DEPARTURE_STOPOVERS) ? pTag.m_128437_(NBT_NEXT_DEPARTURE_STOPOVERS, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList() : new ArrayList(), pTag.m_128461_(NBT_FILTER), info, pTag.m_128454_(NBT_LAST_REFRESH_TIME), pTag.m_128445_(NBT_PLATFORM_WIDTH), pTag.m_128445_(NBT_TRAIN_NAME_WIDTH), pTag.m_128445_(NBT_TIME_DISPLAY));
        if (updateClient) {
            this.getRenderer().update(this.f_58857_, this.f_58858_, this.m_58900_(), (BlockEntity)this, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(NBT_INFO_TYPE, this.getInfoType().getId());
        nbt.m_128405_(NBT_DISPLAY_TYPE, this.getDisplayType().getId());
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.infoType = EDisplayInfo.getTypeById(nbt.m_128451_(NBT_INFO_TYPE));
        this.displayType = EDisplayType.getTypeById(nbt.m_128451_(NBT_DISPLAY_TYPE));
    }

    public AABB getRenderBoundingBox() {
        AABB aabb = new AABB(this.f_58858_);
        if (!this.isController) {
            return aabb;
        }
        Vec3i normal = this.getDirection().m_122427_().m_122436_();
        return aabb.m_82363_((double)(normal.m_123341_() * this.getXSize()), (double)(-this.getYSize()), (double)(normal.m_123343_() * this.getXSize()));
    }

    public Direction getDirection() {
        return this.m_58900_().m_61145_(FlapDisplayBlock.HORIZONTAL_FACING).orElse(Direction.SOUTH).m_122424_();
    }

    public IBlockEntityRendererInstance<AdvancedDisplayBlockEntity> getRenderer() {
        return (IBlockEntityRendererInstance)this.renderer.get();
    }

    protected AABB createRenderBoundingBox() {
        AABB aabb = new AABB(this.f_58858_);
        if (!this.isController) {
            return aabb;
        }
        Vec3i normal = this.getDirection().m_122427_().m_122436_();
        return aabb.m_82363_((double)(normal.m_123341_() * this.xSize), (double)(-this.ySize), (double)(normal.m_123343_() * this.xSize));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 512);
    }
}

