/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.base;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import de.mrjulsen.mcdragonlib.client.util.FontUtils;
import de.mrjulsen.mcdragonlib.mixin.BakedGlyphAccessor;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;

public class BERText {
    private static final byte CHAR_SIZE = 8;
    private final FontUtils fontUtils;
    private final float xOffset;
    private Supplier<List<Component>> textData;
    private float minX = 0.0f;
    private float maxX = Float.MAX_VALUE;
    private float minStretchScale = 1.0f;
    private float maxStretchScale = 1.0f;
    private float maxWidth = Float.MAX_VALUE;
    private boolean forceMaxWidth = false;
    private float scrollSpeed = 0.0f;
    private boolean centered = false;
    private int color = -1;
    private int ticksPerPage = 200;
    private int refreshRate = 0;
    private Consumer<BERText> onUpdate;
    private TextTransformation predefinedTextTransformation = null;
    private TextDataCache cache;
    private float scrollXOffset = 0.0f;
    private int refreshTimer = 0;
    private int currentTicks = 0;
    private int currentIndex = 0;
    private List<Component> texts;

    public BERText(FontUtils fontUtils, Component text, float xOffset) {
        this.fontUtils = fontUtils;
        this.textData = () -> List.of(text);
        this.xOffset = xOffset;
    }

    public BERText(FontUtils fontUtils, Supplier<List<Component>> texts, float xOffset) {
        this.fontUtils = fontUtils;
        this.textData = texts;
        this.xOffset = xOffset;
    }

    public BERText withStencil(float minX, float maxX) {
        this.minX = minX;
        this.maxX = maxX;
        return this;
    }

    public BERText withStretchScale(float minScale, float maxScale) {
        this.minStretchScale = minScale;
        this.maxStretchScale = maxScale;
        return this;
    }

    public BERText withMaxWidth(float maxWidth, boolean force) {
        this.maxWidth = maxWidth;
        this.forceMaxWidth = force;
        return this;
    }

    public BERText withIsCentered(boolean b) {
        this.centered = b;
        return this;
    }

    public BERText withCanScroll(boolean b, float scrollingSpeed) {
        this.scrollSpeed = b ? scrollingSpeed : 0.0f;
        return this;
    }

    public BERText withColor(int color) {
        this.color = color;
        return this;
    }

    public BERText withTicksPerPage(int ticks) {
        this.ticksPerPage = ticks;
        return this;
    }

    public BERText withRefreshRate(int ticks) {
        this.refreshRate = ticks;
        return this;
    }

    public BERText withPredefinedTextTransformation(TextTransformation transformation) {
        this.predefinedTextTransformation = transformation;
        return this;
    }

    public BERText withUpdateFunc(Consumer<BERText> onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    public BERText build() {
        this.fetchCurrentText();
        this.calc(false);
        this.scrollXOffset = this.cache.maxWidthScaled();
        return this;
    }

    public FontUtils getFontUtils() {
        return this.fontUtils;
    }

    private void fetchCurrentText() {
        this.texts = this.textData.get();
    }

    public Component getCurrentText() {
        return this.texts.get(this.currentIndex);
    }

    public List<Component> getTexts() {
        return this.texts;
    }

    public int getTicksPerPage() {
        return this.ticksPerPage;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMinStretchScale() {
        return this.minStretchScale;
    }

    public float getMaxStretchScale() {
        return this.maxStretchScale;
    }

    public float getMaxWidth() {
        return this.maxWidth;
    }

    public boolean forceMaxWidth() {
        return this.forceMaxWidth;
    }

    public boolean canScroll() {
        return this.scrollSpeed > 0.0f;
    }

    public float getScrollSpeed() {
        return this.scrollSpeed;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public float getTextWidth() {
        return this.getFontUtils().font.m_92852_((FormattedText)this.getCurrentText());
    }

    public float getScaledTextWidth() {
        return this.getTextWidth() * this.cache.textXScale();
    }

    public int getColor() {
        return this.color;
    }

    public void recalc() {
        this.calc(false);
    }

    protected void calc(boolean callUpdate) {
        boolean mustScroll;
        float textWidth = this.getFontUtils().font.m_92852_((FormattedText)this.getCurrentText());
        float rawXScale = this.getMaxWidth() / textWidth;
        float finalXScale = MathUtils.clamp((float)rawXScale, (float)this.getMinStretchScale(), (float)this.getMaxStretchScale());
        boolean bl = mustScroll = rawXScale < this.getMinStretchScale();
        if (this.forceMaxWidth() && mustScroll) {
            finalXScale = this.getMaxStretchScale();
        }
        float minX = this.getMinX() / finalXScale;
        float maxWidthScaled = this.getMaxWidth() / finalXScale;
        float maxX = Math.min(this.forceMaxWidth() ? maxWidthScaled : Float.MAX_VALUE, this.getMaxX() / finalXScale);
        float xOffset = this.getXOffset() + (this.isCentered() ? maxWidthScaled / 2.0f - textWidth / 2.0f : 0.0f);
        this.cache = new TextDataCache(finalXScale, minX, maxX, xOffset, maxWidthScaled, textWidth, this.forceMaxWidth() && mustScroll && this.canScroll());
        if (callUpdate && this.onUpdate != null) {
            this.onUpdate.accept(this);
        }
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight) {
        this.getFontUtils().reset();
        pPoseStack.m_85836_();
        if (this.predefinedTextTransformation != null) {
            pPoseStack.m_85837_((double)this.predefinedTextTransformation.x(), (double)this.predefinedTextTransformation.y(), (double)this.predefinedTextTransformation.z());
            pPoseStack.m_85841_(this.predefinedTextTransformation.xScale(), this.predefinedTextTransformation.yScale(), 1.0f);
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(this.cache.textXScale(), 1.0f, 1.0f);
        this.renderTextInBounds(pPoseStack, this.getFontUtils(), pBufferSource, this.getCurrentText(), pPackedLight, this.cache.mustScroll ? this.scrollXOffset : this.cache.xOffset(), this.cache.minX(), this.cache.maxX(), this.getColor());
        pPoseStack.m_85849_();
        pPoseStack.m_85849_();
    }

    private void renderTextInBounds(PoseStack pPoseStack, FontUtils fontUtils, MultiBufferSource pBufferSource, Component text, int pPackedLight, float xOffset, float xLeft, float xRight, int color) {
        if (xRight <= xLeft) {
            return;
        }
        pPoseStack.m_85836_();
        pPoseStack.m_85837_((double)(xLeft + (xOffset > 0.0f ? xOffset : 0.0f)), 0.0, 0.0);
        Font font = fontUtils.font;
        Objects.requireNonNull(font);
        Font.StringRenderOutput sro = new Font.StringRenderOutput(font, pBufferSource, 0.0f, 0.0f, color, false, pPoseStack.m_85850_().m_85861_(), Font.DisplayMode.NORMAL, pPackedLight);
        float newX = xOffset;
        float glyphTranslation = 0.0f;
        float charSize = 8 + (text.m_7383_().m_131154_() ? 1 : 0);
        for (int i = 0; i < text.getString().length(); ++i) {
            float diff;
            char charCode = text.getString().charAt(i);
            GlyphInfo info = fontUtils.fontSet.m_243128_((int)charCode, false);
            float glyphWidth = info.m_83827_(text.m_7383_().m_131154_());
            float oldX = newX;
            if ((newX += glyphWidth) > xLeft && oldX < xLeft) {
                diff = xLeft - oldX;
                BakedGlyphAccessor glyph = fontUtils.getGlyphAccessor((int)charCode);
                float glyphUVDiff = glyph.getU1() - glyph.getU0();
                float scale = 1.0f / charSize * diff;
                float sub = glyphUVDiff * scale;
                fontUtils.pushUV((int)charCode);
                glyph.setU0(glyph.getU0() + sub);
                pPoseStack.m_85836_();
                float invScale = 1.0f - scale;
                pPoseStack.m_85841_(invScale, 1.0f, 1.0f);
                Font font2 = fontUtils.font;
                Objects.requireNonNull(font2);
                Font.StringRenderOutput sro2 = new Font.StringRenderOutput(font2, pBufferSource, 0.0f, 0.0f, color, false, pPoseStack.m_85850_().m_85861_(), Font.DisplayMode.NORMAL, pPackedLight);
                StringDecomposer.m_14346_((String)String.valueOf(charCode), (Style)text.m_7383_(), (FormattedCharSink)sro2);
                pPoseStack.m_85849_();
                fontUtils.popUV((int)charCode);
                pPoseStack.m_85837_((double)(glyphWidth - charSize * scale), 0.0, 0.0);
                continue;
            }
            if (newX > xRight) {
                diff = newX - xRight;
                float charRightSpace = charSize - glyphWidth;
                float totalDiff = diff + charRightSpace;
                BakedGlyphAccessor glyph = fontUtils.getGlyphAccessor((int)charCode);
                float glyphUVDiff = glyph.getU1() - glyph.getU0();
                float scale = 1.0f / charSize * totalDiff;
                float sub = glyphUVDiff * scale;
                fontUtils.pushUV((int)charCode);
                glyph.setU1(glyph.getU1() - sub);
                pPoseStack.m_85836_();
                float invScale = 1.0f - scale;
                pPoseStack.m_85841_(invScale, 1.0f, 1.0f);
                pPoseStack.m_85837_((double)(glyphTranslation / invScale), 0.0, 0.0);
                Font font3 = fontUtils.font;
                Objects.requireNonNull(font3);
                Font.StringRenderOutput sro2 = new Font.StringRenderOutput(font3, pBufferSource, 0.0f, 0.0f, color, false, pPoseStack.m_85850_().m_85861_(), Font.DisplayMode.NORMAL, pPackedLight);
                StringDecomposer.m_14346_((String)String.valueOf(charCode), (Style)text.m_7383_(), (FormattedCharSink)sro2);
                pPoseStack.m_85849_();
                fontUtils.popUV((int)charCode);
                break;
            }
            if (!(oldX >= xLeft) || !(newX <= xRight)) continue;
            StringDecomposer.m_14346_((String)String.valueOf(charCode), (Style)text.m_7383_(), (FormattedCharSink)sro);
            glyphTranslation += glyphWidth;
        }
        pPoseStack.m_85849_();
    }

    public void tick() {
        boolean multiText;
        if (this.refreshRate > 0) {
            ++this.refreshTimer;
            if ((this.refreshTimer %= this.refreshRate) == 0) {
                this.fetchCurrentText();
                this.calc(true);
            }
        }
        boolean bl = multiText = this.getTexts().size() > 1;
        if (this.cache.mustScroll()) {
            this.scrollXOffset -= this.getScrollSpeed() / this.getMaxStretchScale();
            if (this.scrollXOffset < -this.cache.textWidth()) {
                this.scrollXOffset = this.cache.maxWidthScaled();
                if (multiText) {
                    ++this.currentIndex;
                    this.fetchCurrentText();
                    this.currentIndex %= this.getTexts().size();
                    this.calc(true);
                }
            }
        } else if (multiText) {
            ++this.currentTicks;
            if ((this.currentTicks %= this.getTicksPerPage()) == 0) {
                ++this.currentIndex;
                this.fetchCurrentText();
                this.currentIndex %= this.getTexts().size();
                this.calc(true);
            }
        }
    }

    public record TextTransformation(float x, float y, float z, float xScale, float yScale) {
    }

    protected record TextDataCache(float textXScale, float minX, float maxX, float xOffset, float maxWidthScaled, float textWidth, boolean mustScroll) {
    }
}

