/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.RouteDetailsOverlayScreen;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ExpandButton;
import de.mrjulsen.crn.client.lang.ELanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.SimpleRoute;
import de.mrjulsen.crn.event.listeners.IJourneyListenerClient;
import de.mrjulsen.crn.event.listeners.JourneyListener;
import de.mrjulsen.crn.event.listeners.JourneyListenerManager;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.mcdragonlib.client.OverlayManager;
import de.mrjulsen.mcdragonlib.client.gui.DLOverlayScreen;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class RouteDetailsScreen
extends DLScreen
implements IJourneyListenerClient {
    private static final ResourceLocation GUI = new ResourceLocation("createrailwaysnavigator", "textures/gui/route_details.png");
    private static final int GUI_WIDTH = 255;
    private static final int GUI_HEIGHT = 247;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final int ENTRIES_START_Y_OFFSET = 18;
    private static final int ENTRY_WIDTH = 220;
    private static final int ENTRY_TIME_X = 28;
    private static final int ENTRY_DEST_X = 66;
    private final int AREA_X = 16;
    private final int AREA_Y = 53;
    private final int AREA_W = 220;
    private final int AREA_H = 157;
    private int guiLeft;
    private int guiTop;
    private int scrollMax = 0;
    private DLCreateIconButton backButton;
    private DLCreateIconButton saveButton;
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private final ExpandButton[] expandButtons;
    private final WidgetsCollection expandButtonCollection = new WidgetsCollection();
    private final SimpleRoute route;
    private final Screen lastScreen;
    private final Font font;
    private final Font shadowlessFont;
    private final Level level;
    private final MutableComponent textDeparture = ELanguage.translate("gui.createrailwaysnavigator.route_details.departure");
    private final MutableComponent textTransferIn = ELanguage.translate("gui.createrailwaysnavigator.route_details.next_transfer_time");
    private final MutableComponent transferText = ELanguage.translate("gui.createrailwaysnavigator.route_details.transfer");
    private final MutableComponent textJourneyCompleted = ELanguage.translate("gui.createrailwaysnavigator.route_overview.journey_completed");
    private final MutableComponent timeNowText = ELanguage.translate("gui.createrailwaysnavigator.time.now");
    private final MutableComponent textConnectionEndangered = ELanguage.translate("gui.createrailwaysnavigator.route_overview.connection_endangered").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD);
    private final MutableComponent textConnectionMissed = ELanguage.translate("gui.createrailwaysnavigator.route_overview.connection_missed").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD);
    private final MutableComponent textTrainCanceled = ELanguage.translate("gui.createrailwaysnavigator.route_overview.train_canceled").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD);
    private final MutableComponent textSaveRoute = TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.save_route");
    private final String keyTrainCancellationReason = "gui.createrailwaysnavigator.route_overview.train_cancellation_info";
    private final UUID clientId = UUID.randomUUID();

    public RouteDetailsScreen(Screen lastScreen, Level level, SimpleRoute route, UUID listenerId) {
        super((Component)TextUtils.translate((String)"gui.createrailwaysnavigator.route_details.title"));
        this.lastScreen = lastScreen;
        this.route = route;
        this.font = Minecraft.m_91087_().f_91062_;
        this.shadowlessFont = new NoShadowFontWrapper(this.font);
        this.level = level;
        JourneyListenerManager.getInstance().get(listenerId, this);
        int count = route.getParts().size();
        this.expandButtons = new ExpandButton[count];
        for (int i = 0; i < count; ++i) {
            this.expandButtons[i] = new ExpandButton(0, 0, false, btn -> {});
            this.expandButtonCollection.components.add(this.expandButtons[i]);
        }
    }

    @Override
    public UUID getJourneyListenerClientId() {
        return this.clientId;
    }

    public int getCurrentTime() {
        return (int)(this.level.m_46468_() % 24000L);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
        JourneyListenerManager.getInstance().removeClientListenerForAll(this);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 127;
        this.guiTop = this.f_96544_ / 2 - 123;
        final int fWidth = this.f_96543_;
        final int fHeight = this.f_96544_;
        this.backButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 21, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_CONFIG_BACK){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                RouteDetailsScreen.this.m_7379_();
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TOOLTIP_GO_BACK).assignedTo((AbstractWidget)this.backButton));
        this.saveButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 21 + 18 + 4, this.guiTop + 222, 18, 18, (ScreenElement)ModGuiIcons.BOOKMARK.getAsCreateIcon()){

            public void m_5716_(double mouseX, double mouseY) {
                super.m_5716_(mouseX, mouseY);
                if (JourneyListenerManager.getInstance().exists(RouteDetailsScreen.this.route.getListenerId())) {
                    InstanceManager.setRouteOverlay(OverlayManager.add((DLOverlayScreen)new RouteDetailsOverlayScreen(RouteDetailsScreen.this.level, RouteDetailsScreen.this.route, fWidth, fHeight)));
                }
            }
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.textSaveRoute).assignedTo((AbstractWidget)this.saveButton));
    }

    public void m_86600_() {
        super.m_86600_();
        this.scroll.tickChaser();
        this.saveButton.f_93624_ = JourneyListenerManager.getInstance().exists(this.route.getListenerId());
    }

    private Pair<MutableComponent, MutableComponent> getStationInfo(SimpleRoute.StationEntry station) {
        boolean reachable = station.reachable(false);
        MutableComponent timeText = TextUtils.text((String)TimeUtils.parseTime((long)((int)((this.route.getRefreshTime() + 6000L) % 24000L + (long)station.getTicks())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())));
        MutableComponent stationText = TextUtils.text((String)station.getStationName());
        if (!reachable) {
            timeText = timeText.m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.STRIKETHROUGH);
            stationText = stationText.m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.STRIKETHROUGH);
        }
        return Pair.of((Object)timeText, (Object)stationText);
    }

    private int renderRouteStart(Graphics graphics, int x, int y, SimpleRoute.StationEntry stop) {
        int HEIGHT = 30;
        int V = 48;
        GuiUtils.drawTexture((ResourceLocation)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)48, (int)220, (int)30);
        Pair<MutableComponent, MutableComponent> text = this.getStationInfo(stop);
        float scale = this.shadowlessFont.m_92852_((FormattedText)text.getFirst()) > 30 ? 0.75f : 1.0f;
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(scale, 1.0f, 1.0f);
        int pY = y + 15;
        if (stop.shouldRenderRealtime() && stop.reachable(false)) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)((pY -= stop.shouldRenderRealtime() ? 5 : 0) + 10), (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)((int)(stop.getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(stop.getDifferenceTime() > (long)((Integer)ModClientConfig.DEVIATION_THRESHOLD.get()).intValue() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)pY, (FormattedText)((FormattedText)text.getFirst()), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().m_85849_();
        MutableComponent platformText = TextUtils.text((String)stop.getUpdatedInfo().platform());
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 66 + 129 - this.shadowlessFont.m_92852_((FormattedText)platformText)), (int)(y + 15), (FormattedText)platformText, (int)(stop.stationInfoChanged() ? 0xFF4242 : 0xFFFFFF), (EAlignment)EAlignment.LEFT, (boolean)false);
        MutableComponent name = (MutableComponent)text.getSecond();
        int maxTextWidth = 123 - this.shadowlessFont.m_92852_((FormattedText)platformText);
        if (this.shadowlessFont.m_92852_((FormattedText)name) > maxTextWidth) {
            name = TextUtils.text((String)this.shadowlessFont.m_92854_((FormattedText)name, maxTextWidth - 3).getString()).m_7220_(Constants.ELLIPSIS_STRING);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 66), (int)(y + 15), (FormattedText)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        return 30;
    }

    private int renderTrainDetails(Graphics graphics, int x, int y, SimpleRoute.SimpleRoutePart part) {
        int HEIGHT = 43;
        int V = 99;
        float scale = 0.75f;
        float mul = 1.3333334f;
        GuiUtils.drawTexture((ResourceLocation)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)99, (int)220, (int)43);
        part.getTrainIcon().render(-1, graphics.poseStack(), x + 66, y + 7);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(x + 66 + 24) / 0.75f)), (int)((int)((float)(y + 7) / 0.75f)), (FormattedText)TextUtils.text((String)String.format("%s (%s)", part.getTrainName(), part.getTrainID().toString().split("-")[0])), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(x + 66 + 24) / 0.75f)), (int)((int)((float)(y + 17) / 0.75f)), (FormattedText)TextUtils.text((String)String.format("\u2192 %s", part.getScheduleTitle())), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().m_85841_(1.3333334f, 1.3333334f, 1.3333334f);
        graphics.poseStack().m_85849_();
        return 43;
    }

    private int renderStop(Graphics graphics, int x, int y, SimpleRoute.StationEntry stop) {
        int HEIGHT = 21;
        int V = 78;
        GuiUtils.drawTexture((ResourceLocation)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)78, (int)220, (int)21);
        Pair<MutableComponent, MutableComponent> text = this.getStationInfo(stop);
        float scale = this.shadowlessFont.m_92852_((FormattedText)text.getFirst()) > 30 ? 0.75f : 1.0f;
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(scale, 1.0f, 1.0f);
        int pY = y + 6;
        if (stop.shouldRenderRealtime() && stop.reachable(false)) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)((pY -= stop.shouldRenderRealtime() ? 5 : 0) + 10), (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)((int)(stop.getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(stop.getDifferenceTime() > (long)((Integer)ModClientConfig.DEVIATION_THRESHOLD.get()).intValue() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)pY, (FormattedText)((FormattedText)text.getFirst()), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().m_85849_();
        MutableComponent platformText = TextUtils.text((String)stop.getUpdatedInfo().platform());
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 66 + 129 - this.shadowlessFont.m_92852_((FormattedText)platformText)), (int)(y + 6), (FormattedText)platformText, (int)(stop.stationInfoChanged() ? 0xFF4242 : 0xFFFFFF), (EAlignment)EAlignment.LEFT, (boolean)false);
        MutableComponent name = (MutableComponent)text.getSecond();
        int maxTextWidth = 123 - this.shadowlessFont.m_92852_((FormattedText)platformText);
        if (this.shadowlessFont.m_92852_((FormattedText)name) > maxTextWidth) {
            name = TextUtils.text((String)this.shadowlessFont.m_92854_((FormattedText)name, maxTextWidth - 3).getString()).m_7220_(Constants.ELLIPSIS_STRING);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 66), (int)(y + 6), (FormattedText)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        return 21;
    }

    private int renderRouteEnd(Graphics graphics, int x, int y, SimpleRoute.StationEntry stop) {
        int HEIGHT = 44;
        int V = 142;
        GuiUtils.drawTexture((ResourceLocation)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)142, (int)220, (int)44);
        Pair<MutableComponent, MutableComponent> text = this.getStationInfo(stop);
        float scale = this.shadowlessFont.m_92852_((FormattedText)text.getFirst()) > 30 ? 0.75f : 1.0f;
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(scale, 1.0f, 1.0f);
        int pY = y + 21;
        if (stop.shouldRenderRealtime() && stop.reachable(false)) {
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)((pY -= stop.shouldRenderRealtime() ? 5 : 0) + 10), (FormattedText)TextUtils.text((String)TimeUtils.parseTime((long)((int)(stop.getEstimatedTimeWithThreshold() % 24000L + 6000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(stop.getDifferenceTime() > (long)((Integer)ModClientConfig.DEVIATION_THRESHOLD.get()).intValue() ? 0xFF4242 : 1763935), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(x + 28) / scale)), (int)pY, (FormattedText)((FormattedText)text.getFirst()), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().m_85849_();
        MutableComponent platformText = TextUtils.text((String)stop.getUpdatedInfo().platform());
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 66 + 129 - this.shadowlessFont.m_92852_((FormattedText)platformText)), (int)(y + 21), (FormattedText)platformText, (int)(stop.stationInfoChanged() ? 0xFF4242 : 0xFFFFFF), (EAlignment)EAlignment.LEFT, (boolean)false);
        MutableComponent name = (MutableComponent)text.getSecond();
        int maxTextWidth = 123 - this.shadowlessFont.m_92852_((FormattedText)platformText);
        if (this.shadowlessFont.m_92852_((FormattedText)name) > maxTextWidth) {
            name = TextUtils.text((String)this.shadowlessFont.m_92854_((FormattedText)name, maxTextWidth - 3).getString()).m_7220_(Constants.ELLIPSIS_STRING);
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 66), (int)(y + 21), (FormattedText)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        return 44;
    }

    private void renderHeadline(Graphics graphics, int pMouseX, int pMouseY) {
        MutableComponent titleInfo = TextUtils.empty();
        MutableComponent headline = TextUtils.empty();
        JourneyListener listener = JourneyListenerManager.getInstance().get(this.route.getListenerId(), null);
        if (!this.route.isValid()) {
            titleInfo = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.train_cancellation_info", (Object[])new Object[]{this.route.getInvalidationTrainName()}).m_130940_(ChatFormatting.RED);
            headline = this.textTrainCanceled;
        } else if (listener != null && listener.getIndex() > 0) {
            titleInfo = this.textTransferIn;
            long arrivalTime = listener.currentStation().getParent().getEndStation().getEstimatedTimeWithThreshold();
            int time = (int)(arrivalTime % 24000L - (long)this.getCurrentTime());
            headline = time < 0 || listener.currentStation().getTag() == SimpleRoute.StationTag.PART_START ? this.timeNowText : TextUtils.text((String)TimeUtils.parseTime((long)time, (TimeUtils.TimeFormat)TimeUtils.TimeFormat.HOURS_24));
        } else if (listener == null) {
            titleInfo = TextUtils.empty();
            headline = this.textJourneyCompleted.m_130940_(ChatFormatting.GREEN);
        } else {
            titleInfo = this.textDeparture;
            int departureTicks = this.route.getStartStation().getTicks();
            int departureTime = (int)(this.route.getRefreshTime() % 24000L + (long)departureTicks);
            headline = departureTime - this.getCurrentTime() < 0 ? this.timeNowText : TextUtils.text((String)TimeUtils.parseTime((long)(departureTime - this.getCurrentTime()), (TimeUtils.TimeFormat)TimeUtils.TimeFormat.HOURS_24));
        }
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)(this.guiLeft + 127), (int)(this.guiTop + 19), (FormattedText)titleInfo, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
        graphics.poseStack().m_85836_();
        graphics.poseStack().m_85841_(2.0f, 2.0f, 2.0f);
        GuiUtils.drawString((Graphics)graphics, (Font)this.font, (int)((this.guiLeft + 127) / 2), (int)((this.guiTop + 31) / 2), (FormattedText)headline, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
        graphics.poseStack().m_85849_();
    }

    private int renderTransfer(Graphics graphics, int x, int y, long a, long b, SimpleRoute.StationEntry nextStation) {
        int HEIGHT = 24;
        int V = 186;
        GuiUtils.drawTexture((ResourceLocation)Constants.GUI_WIDGETS, (Graphics)graphics, (int)x, (int)y, (int)0, (int)186, (int)220, (int)24);
        long time = -1L;
        time = a < 0L || b < 0L ? -1L : b - a;
        if (nextStation != null && !nextStation.reachable(true)) {
            if (nextStation.isTrainCanceled()) {
                ModGuiIcons.CROSS.render(graphics, x + 28, y + 13 - 8);
                GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 28 + 16 + 4), (int)(y + 8), (FormattedText)this.textTrainCanceled, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
            } else if (nextStation.isDeparted()) {
                ModGuiIcons.CROSS.render(graphics, x + 28, y + 13 - 8);
                GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 28 + 16 + 4), (int)(y + 8), (FormattedText)this.textConnectionMissed, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
            } else {
                ModGuiIcons.WARN.render(graphics, x + 28, y + 13 - 8);
                GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 28 + 16 + 4), (int)(y + 8), (FormattedText)this.textConnectionEndangered, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
            }
        } else {
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(x + 28), (int)(y + 8), (FormattedText)TextUtils.text((String)(this.transferText.getString() + " " + (String)(time < 0L ? "" : "(" + TimeUtils.parseDuration((long)time) + ")"))), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        return 24;
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = Minecraft.m_91087_().m_91296_();
        float scrollOffset = -this.scroll.getValue(pPartialTick);
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)255, (int)247);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 19), (int)(this.guiTop + 4), (FormattedText)this.f_96539_, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.m_46468_() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 255 - 22 - this.shadowlessFont.m_92895_(timeString)), (int)(this.guiTop + 4), (FormattedText)TextUtils.text((String)timeString), (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        this.renderHeadline(graphics, pMouseX, pMouseY);
        GuiUtils.enableScissor((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 53), (int)220, (int)157);
        graphics.poseStack().m_85837_(0.0, (double)scrollOffset, 0.0);
        int yOffs = this.guiTop + 45;
        GuiUtils.drawTexture((ResourceLocation)Constants.GUI_WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16), (int)yOffs, (int)22, (int)18, (int)0, (int)48, (int)22, (int)1, (int)256, (int)256);
        yOffs += 18;
        SimpleRoute.SimpleRoutePart[] partsArray = (SimpleRoute.SimpleRoutePart[])this.route.getParts().toArray(SimpleRoute.SimpleRoutePart[]::new);
        for (int i = 0; i < partsArray.length; ++i) {
            SimpleRoute.SimpleRoutePart part = partsArray[i];
            yOffs += this.renderRouteStart(graphics, this.guiLeft + 16, yOffs, part.getStartStation());
            yOffs += this.renderTrainDetails(graphics, this.guiLeft + 16, yOffs, part);
            ExpandButton btn = this.expandButtons[i];
            boolean bl = btn.f_93623_ = part.getStopovers().size() > 0;
            if (btn.f_93623_) {
                btn.f_93620_ = this.guiLeft + 78;
                btn.f_93621_ = yOffs - 14;
                btn.m_6305_(graphics.poseStack(), pMouseX, (int)((float)pMouseY - scrollOffset), pPartialTick);
            }
            if (btn.isExpanded()) {
                for (SimpleRoute.StationEntry stop : part.getStopovers()) {
                    yOffs += this.renderStop(graphics, this.guiLeft + 16, yOffs, stop);
                }
            }
            yOffs += this.renderRouteEnd(graphics, this.guiLeft + 16, yOffs, part.getEndStation());
            if (i >= partsArray.length - 1) continue;
            SimpleRoute.StationEntry currentStation = part.getEndStation();
            SimpleRoute.StationEntry nextStation = partsArray[i + 1].getStartStation();
            long a = currentStation.shouldRenderRealtime() ? currentStation.getCurrentTime() : currentStation.getScheduleTime();
            long b = nextStation.shouldRenderRealtime() ? nextStation.getCurrentTime() : nextStation.getScheduleTime();
            yOffs += this.renderTransfer(graphics, this.guiLeft + 16, yOffs, a, b, nextStation);
        }
        this.scrollMax = yOffs - this.guiTop - 45;
        GuiUtils.drawTexture((ResourceLocation)Constants.GUI_WIDGETS, (Graphics)graphics, (int)(this.guiLeft + 16), (int)yOffs, (int)22, (int)157, (int)0, (int)48, (int)22, (int)1, (int)256, (int)256);
        GuiUtils.disableScissor((Graphics)graphics);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 53), (int)0, (int)220, (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 53 + 157 - 10), (int)0, (int)220, (int)10, (int)0, (int)0x77000000);
        double maxHeight = this.scrollMax;
        double aH = 158.0;
        if (aH / maxHeight < 1.0) {
            int scrollerHeight = Math.max(10, (int)(aH * (aH / maxHeight)));
            int startY = this.guiTop + 53 + (int)(157.0 * ((double)Math.abs(scrollOffset) / maxHeight));
            GuiUtils.fill((Graphics)graphics, (int)(this.guiLeft + 16 + 220 - 3), (int)startY, (int)3, (int)scrollerHeight, (int)Integer.MAX_VALUE);
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        float chaseTarget = this.scroll.getChaseTarget();
        float max = -157.0f;
        if ((max += (float)this.scrollMax) > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = MathUtils.clamp((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        float scrollOffset = this.scroll.getValue();
        if (pMouseX > (double)(this.guiLeft + 16) && pMouseX < (double)(this.guiLeft + 16 + 220) && pMouseY > (double)(this.guiTop + 53) && pMouseY < (double)(this.guiTop + 53 + 157)) {
            this.expandButtonCollection.performForEach(x -> x.f_93623_, x -> x.m_6375_(pMouseX, pMouseY + (double)scrollOffset, pButton));
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }
}

