/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.mojang.text2speech.Narrator;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.NavigatorToast;
import de.mrjulsen.crn.client.gui.overlay.OverlayPosition;
import de.mrjulsen.crn.client.gui.overlay.RouteDetailsOverlayScreen;
import de.mrjulsen.crn.client.gui.screen.RouteDetailsScreen;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIndicator;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.registry.ModItems;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RouteOverlaySettingsScreen
extends DLScreen {
    private static final Component title = TextUtils.translate((String)"gui.createrailwaysnavigator.overlay_settings.title");
    private static final ResourceLocation GUI = new ResourceLocation("createrailwaysnavigator", "textures/gui/route_overlay_settings.png");
    private static final int GUI_WIDTH = 213;
    private static final int GUI_HEIGHT = 79;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private final Font shadowlessFont;
    private final ItemStack renderedItem = new ItemStack((ItemLike)ModItems.NAVIGATOR.get());
    private int guiLeft;
    private int guiTop;
    private final RouteDetailsOverlayScreen overlay;
    private DLCreateIconButton backButton;
    private DLCreateIconButton detailsButton;
    private IconButton removeOverlayButton;
    private DLCreateIconButton soundButton;
    private DLCreateIconButton notificationsButton;
    private DLCreateIndicator soundIndicator;
    private DLCreateIndicator notificationsIndicator;
    private ScrollInput scaleInput;
    private Component scaleLabel;
    private final Map<IconButton, Pair<Component, Component>> buttonTooltips = new LinkedHashMap<IconButton, Pair<Component, Component>>();
    private final WidgetsCollection positionButtons = new WidgetsCollection();
    private final WidgetsCollection buttons = new WidgetsCollection();
    private static final MutableComponent narratorOn = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.narrator.on");
    private static final MutableComponent narratorOff = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.narrator.off");
    private static final MutableComponent notificationsOn = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.notifications.on");
    private static final MutableComponent notificationsOff = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.notifications.off");
    private static final MutableComponent textScale = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.scale");
    private static final MutableComponent textShowDetails = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.show_details");
    private static final MutableComponent textUnpin = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.unpin");
    private static final MutableComponent textNarrator = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.narrator");
    private static final MutableComponent textNarratorDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.narrator.description").m_130940_(ChatFormatting.GRAY);
    private static final MutableComponent textNotifications = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.notifications");
    private static final MutableComponent textNotificationsDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overlay_settings.notifications.description").m_130940_(ChatFormatting.GRAY);

    public RouteOverlaySettingsScreen(RouteDetailsOverlayScreen overlay) {
        super(title);
        this.shadowlessFont = new NoShadowFontWrapper(Minecraft.m_91087_().f_91062_);
        this.overlay = overlay;
    }

    public void m_7379_() {
        ModClientConfig.SPEC.save();
        ModClientConfig.SPEC.afterReload();
        super.m_7379_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 106;
        this.guiTop = this.f_96544_ / 2 - 39;
        this.positionButtons.clear();
        this.buttons.clear();
        this.backButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 180, this.guiTop + 55, 18, 18, (ScreenElement)AllIcons.I_CONFIRM));
        this.backButton.withCallback(() -> this.m_7379_());
        this.buttons.add((AbstractWidget)this.backButton);
        this.detailsButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 7, this.guiTop + 55, 18, 18, (ScreenElement)AllIcons.I_VIEW_SCHEDULE));
        this.detailsButton.withCallback(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.m_91152_((Screen)new RouteDetailsScreen((Screen)this, (Level)Minecraft.m_91087_().f_91073_, this.overlay.getListener().getListeningRoute(), this.overlay.getListenerId()));
        });
        this.detailsButton.setToolTip((Component)textShowDetails);
        this.buttons.add((AbstractWidget)this.detailsButton);
        this.removeOverlayButton = (IconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 27, this.guiTop + 55, 18, 18, (ScreenElement)AllIcons.I_CONFIG_DISCARD));
        this.removeOverlayButton.withCallback(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.m_91152_((Screen)new RouteDetailsScreen(null, (Level)Minecraft.m_91087_().f_91073_, this.overlay.getListener().getListeningRoute(), this.overlay.getListenerId()));
            InstanceManager.removeRouteOverlay();
        });
        this.removeOverlayButton.setToolTip((Component)textUnpin);
        this.buttons.add((AbstractWidget)this.removeOverlayButton);
        OverlayPosition[] positions = OverlayPosition.values();
        for (int i2 = 0; i2 < positions.length; ++i2) {
            OverlayPosition pos = positions[i2];
            IconButton remOverlayButton = (IconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 123 + 18 * i2, this.guiTop + 23, 18, 18, (ScreenElement)pos.getIcon().getAsCreateIcon()));
            remOverlayButton.withCallback(() -> {
                this.positionButtons.performForEach(x -> {
                    x.f_93623_ = true;
                });
                remOverlayButton.f_93623_ = false;
                ModClientConfig.ROUTE_OVERLAY_POSITION.set((Object)pos);
            });
            remOverlayButton.setToolTip((Component)TextUtils.translate((String)pos.getEnumTranslationKey("createrailwaysnavigator")));
            remOverlayButton.getToolTip().add(TextUtils.translate((String)pos.getValueInfoTranslationKey("createrailwaysnavigator")).m_130940_(ChatFormatting.GRAY));
            remOverlayButton.f_93623_ = pos != ModClientConfig.ROUTE_OVERLAY_POSITION.get();
            this.removeOverlayButton = remOverlayButton;
            this.positionButtons.add((AbstractWidget)remOverlayButton);
            this.buttons.add((AbstractWidget)remOverlayButton);
        }
        this.soundButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 10, this.guiTop + 26, 18, 18, (ScreenElement)ModGuiIcons.SOUND_ON.getAsCreateIcon()));
        this.soundButton.withCallback(() -> {
            ModClientConfig.ROUTE_NARRATOR.set((Object)((Boolean)ModClientConfig.ROUTE_NARRATOR.get() == false ? 1 : 0));
            if (((Boolean)ModClientConfig.ROUTE_NARRATOR.get()).booleanValue()) {
                Narrator.getNarrator().say(narratorOn.getString(), true);
            } else {
                Narrator.getNarrator().say(narratorOff.getString(), true);
            }
        });
        this.buttons.add((AbstractWidget)this.soundButton);
        this.buttonTooltips.put(this.soundButton, (Pair<Component, Component>)Pair.of((Object)textNarrator, (Object)textNarratorDescription));
        this.soundIndicator = (DLCreateIndicator)this.m_142416_((GuiEventListener)new DLCreateIndicator(this.guiLeft + 10, this.guiTop + 20, Components.immutableEmpty()));
        this.notificationsButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 28, this.guiTop + 26, 18, 18, (ScreenElement)ModGuiIcons.INFO.getAsCreateIcon()));
        this.notificationsButton.withCallback(() -> {
            ModClientConfig.ROUTE_NOTIFICATIONS.set((Object)((Boolean)ModClientConfig.ROUTE_NOTIFICATIONS.get() == false ? 1 : 0));
            if (((Boolean)ModClientConfig.ROUTE_NOTIFICATIONS.get()).booleanValue()) {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)NavigatorToast.multiline((Component)notificationsOn, (Component)TextUtils.empty()));
            } else {
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)NavigatorToast.multiline((Component)notificationsOff, (Component)TextUtils.empty()));
            }
        });
        this.buttons.add((AbstractWidget)this.notificationsButton);
        this.buttonTooltips.put(this.notificationsButton, (Pair<Component, Component>)Pair.of((Object)textNotifications, (Object)textNotificationsDescription));
        this.notificationsIndicator = (DLCreateIndicator)this.m_142416_((GuiEventListener)new DLCreateIndicator(this.guiLeft + 28, this.guiTop + 20, Components.immutableEmpty()));
        this.scaleInput = (ScrollInput)this.m_142416_((GuiEventListener)new ScrollInput(this.guiLeft + 63, this.guiTop + 23, 43, 18).withRange(25, 201).withStepFunction(x -> 5 * (x.shift ? 5 : 1)).titled(textScale).calling(i -> {
            double val = (double)i.intValue() / 100.0;
            ModClientConfig.OVERLAY_SCALE.set((Object)((double)i.intValue() / 100.0));
            this.scaleLabel = TextUtils.text((String)(String.format("%.2f", val) + "x"));
        }).setState((int)((Double)ModClientConfig.OVERLAY_SCALE.get() * 100.0)));
        this.scaleInput.onChanged();
        this.buttons.add((AbstractWidget)this.scaleInput);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        this.soundIndicator.state = (Boolean)ModClientConfig.ROUTE_NARRATOR.get() != false ? Indicator.State.ON : Indicator.State.OFF;
        this.notificationsIndicator.state = (Boolean)ModClientConfig.ROUTE_NOTIFICATIONS.get() != false ? Indicator.State.ON : Indicator.State.OFF;
        this.buttons.performForEachOfType(IconButton.class, x -> {
            if (!this.buttonTooltips.containsKey(x)) {
                return;
            }
            x.setToolTip((Component)this.buttonTooltips.get(x).getFirst());
            x.getToolTip().add(TooltipHelper.holdShift((TooltipHelper.Palette)TooltipHelper.Palette.YELLOW, (boolean)RouteOverlaySettingsScreen.m_96638_()));
            if (RouteOverlaySettingsScreen.m_96638_()) {
                x.getToolTip().add((Component)this.buttonTooltips.get(x).getSecond());
            }
        });
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)213, (int)79);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 6), (int)(this.guiTop + 4), (FormattedText)title, (int)-12566464, (EAlignment)EAlignment.LEFT, (boolean)false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(this.guiLeft + 213), (float)(this.guiTop + 79 - 48), -200.0f)).scale(5.0).render(graphics.poseStack());
        CreateDynamicWidgets.renderTextBox(graphics, this.guiLeft + 63, this.guiTop + 23, 43);
        GuiUtils.drawString((Graphics)graphics, (Font)this.f_96547_, (int)(this.guiLeft + 67), (int)(this.guiTop + 28), (FormattedText)this.scaleLabel, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)true);
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderFrontLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.buttons.performForEach(widget -> {
            AbstractSimiWidget simiWidget;
            if (widget instanceof AbstractSimiWidget && (simiWidget = (AbstractSimiWidget)widget).m_198029_()) {
                List tooltip = simiWidget.getToolTip();
                if (tooltip.isEmpty()) {
                    return;
                }
                int ttx = simiWidget.lockedTooltipX == -1 ? pMouseX : simiWidget.lockedTooltipX + simiWidget.f_93620_;
                int tty = simiWidget.lockedTooltipY == -1 ? pMouseY : simiWidget.lockedTooltipY + simiWidget.f_93621_;
                this.m_96597_(graphics.poseStack(), tooltip, ttx, tty);
            }
        });
        super.renderFrontLayer(graphics, pMouseX, pMouseY, pPartialTick);
    }
}

