/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class ModCommandSuggestions {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final Style UNPARSED_STYLE = Style.f_131099_.m_131140_(ChatFormatting.RED);
    private static final Style LITERAL_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    private static final List<Style> ARGUMENT_STYLES = (List)Stream.of(ChatFormatting.AQUA, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE, ChatFormatting.GOLD).map(arg_0 -> ((Style)Style.f_131099_).m_131140_(arg_0)).collect(ImmutableList.toImmutableList());
    final Minecraft minecraft;
    final Screen screen;
    protected final EditBox input;
    final Font font;
    private final boolean commandsOnly;
    private final boolean onlyShowIfCursorPastError;
    final int lineStartOffset;
    final int suggestionLineLimit;
    final boolean anchorToBottom;
    final int fillColor;
    private final List<FormattedCharSequence> commandUsage = Lists.newArrayList();
    private int commandUsagePosition;
    private int commandUsageWidth;
    @Nullable
    private ParseResults<SharedSuggestionProvider> currentParse;
    @Nullable
    private CompletableFuture<Suggestions> pendingSuggestions;
    @Nullable
    protected SuggestionsList suggestions;
    private boolean allowSuggestions;
    boolean keepSuggestions;

    public ModCommandSuggestions(Minecraft pMinecraft, Screen pScreen, EditBox pInput, Font pFont, boolean pCommandsOnly, boolean pOnlyShowIfCursorPastError, int pLineStartOffset, int pSuggestionLineLimit, boolean pAnchorToBottom, int pFillColor) {
        this.minecraft = pMinecraft;
        this.screen = pScreen;
        this.input = pInput;
        this.font = pFont;
        this.commandsOnly = pCommandsOnly;
        this.onlyShowIfCursorPastError = pOnlyShowIfCursorPastError;
        this.lineStartOffset = pLineStartOffset;
        this.suggestionLineLimit = pSuggestionLineLimit;
        this.anchorToBottom = pAnchorToBottom;
        this.fillColor = pFillColor;
        pInput.m_94149_(this::formatChat);
    }

    public void setAllowSuggestions(boolean pAutoSuggest) {
        this.allowSuggestions = pAutoSuggest;
        if (!pAutoSuggest) {
            this.suggestions = null;
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.suggestions != null && this.suggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (this.screen.m_7222_() == this.input && pKeyCode == 258) {
            this.showSuggestions(true);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta) {
        return this.suggestions != null && this.suggestions.mouseScrolled((int)pMouseX, (int)pMouseY, Mth.m_14008_((double)pDelta, (double)-1.0, (double)1.0));
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pMouseButton) {
        return this.suggestions != null && this.suggestions.mouseClicked((int)pMouseX, (int)pMouseY, pMouseButton);
    }

    public void showSuggestions(boolean pNarrateFirstSuggestion) {
        Suggestions suggestions;
        if (this.pendingSuggestions != null && this.pendingSuggestions.isDone() && !(suggestions = this.pendingSuggestions.join()).isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                i = Math.max(i, this.font.m_92895_(suggestion.getText()));
            }
            int j = Mth.m_14045_((int)this.input.m_94211_(suggestions.getRange().getStart()), (int)0, (int)(this.input.m_94211_(0) + this.input.m_94210_() - i));
            int k = this.anchorToBottom ? this.screen.f_96544_ - 12 : 72;
            this.suggestions = new SuggestionsList(j, k, i, this.sortSuggestions(suggestions), pNarrateFirstSuggestion);
        }
    }

    private List<Suggestion> sortSuggestions(Suggestions pSuggestions) {
        String s = this.input.m_94155_().substring(0, this.input.m_94207_());
        int i = ModCommandSuggestions.getLastWordIndex(s);
        String s1 = s.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (Suggestion suggestion : pSuggestions.getList()) {
            if (!suggestion.getText().startsWith(s1) && !suggestion.getText().startsWith("minecraft:" + s1)) {
                list1.add(suggestion);
                continue;
            }
            list.add(suggestion);
        }
        list.addAll(list1);
        return list;
    }

    public void updateCommandInfo() {
        boolean flag;
        String s = this.input.m_94155_();
        if (this.currentParse != null && !this.currentParse.getReader().getString().equals(s)) {
            this.currentParse = null;
        }
        if (!this.keepSuggestions) {
            this.input.m_94167_((String)null);
            this.suggestions = null;
        }
        this.commandUsage.clear();
        StringReader stringreader = new StringReader(s);
        boolean bl = flag = stringreader.canRead() && stringreader.peek() == '/';
        if (flag) {
            stringreader.skip();
        }
        boolean flag1 = this.commandsOnly || flag;
        int i = this.input.m_94207_();
        if (flag1) {
            int j;
            CommandDispatcher commanddispatcher = this.minecraft.f_91074_.f_108617_.m_105146_();
            if (this.currentParse == null) {
                this.currentParse = commanddispatcher.parse(stringreader, (Object)this.minecraft.f_91074_.f_108617_.m_105137_());
            }
            int n = j = this.onlyShowIfCursorPastError ? stringreader.getCursor() : 1;
            if (!(i < j || this.suggestions != null && this.keepSuggestions)) {
                this.pendingSuggestions = commanddispatcher.getCompletionSuggestions(this.currentParse, i);
                this.pendingSuggestions.thenRun(() -> {
                    if (this.pendingSuggestions.isDone()) {
                        this.updateUsageInfo();
                    }
                });
            }
        } else {
            String s1 = s.substring(0, i);
            int k = ModCommandSuggestions.getLastWordIndex(s1);
            Collection collection = this.minecraft.f_91074_.f_108617_.m_105137_().m_5982_();
            this.pendingSuggestions = SharedSuggestionProvider.m_82970_((Iterable)collection, (SuggestionsBuilder)new SuggestionsBuilder(s1, k));
        }
    }

    private static int getLastWordIndex(String pText) {
        if (Strings.isNullOrEmpty((String)pText)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(pText);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    private static FormattedCharSequence getExceptionMessage(CommandSyntaxException pException) {
        Component component = ComponentUtils.m_130729_((Message)pException.getRawMessage());
        String s = pException.getContext();
        return s == null ? component.m_7532_() : TextUtils.translate((String)"command.context.parse_error", (Object[])new Object[]{component, pException.getCursor(), s}).m_7532_();
    }

    private void updateUsageInfo() {
        if (this.input.m_94207_() == this.input.m_94155_().length()) {
            if (this.pendingSuggestions.join().isEmpty() && !this.currentParse.getExceptions().isEmpty()) {
                int i = 0;
                for (Map.Entry entry : this.currentParse.getExceptions().entrySet()) {
                    CommandSyntaxException commandsyntaxexception = (CommandSyntaxException)entry.getValue();
                    if (commandsyntaxexception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                        ++i;
                        continue;
                    }
                    this.commandUsage.add(ModCommandSuggestions.getExceptionMessage(commandsyntaxexception));
                }
                if (i > 0) {
                    this.commandUsage.add(ModCommandSuggestions.getExceptionMessage(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create()));
                }
            } else if (this.currentParse.getReader().canRead()) {
                this.commandUsage.add(ModCommandSuggestions.getExceptionMessage(Commands.m_82097_(this.currentParse)));
            }
        }
        this.commandUsagePosition = 0;
        this.commandUsageWidth = this.screen.f_96543_;
        if (this.commandUsage.isEmpty()) {
            this.fillNodeUsage(ChatFormatting.GRAY);
        }
        this.suggestions = null;
        if (this.allowSuggestions && ((Boolean)this.minecraft.f_91066_.m_231813_().m_231551_()).booleanValue()) {
            this.showSuggestions(false);
        }
    }

    private void fillNodeUsage(ChatFormatting pFormatting) {
        CommandContextBuilder commandcontextbuilder = this.currentParse.getContext();
        SuggestionContext suggestioncontext = commandcontextbuilder.findSuggestionContext(this.input.m_94207_());
        Map map = this.minecraft.f_91074_.f_108617_.m_105146_().getSmartUsage(suggestioncontext.parent, (Object)this.minecraft.f_91074_.f_108617_.m_105137_());
        ArrayList list = Lists.newArrayList();
        int i = 0;
        Style style = Style.f_131099_.m_131140_(pFormatting);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            list.add(FormattedCharSequence.m_13714_((String)((String)entry.getValue()), (Style)style));
            i = Math.max(i, this.font.m_92895_((String)entry.getValue()));
        }
        if (!list.isEmpty()) {
            this.commandUsage.addAll(list);
            this.commandUsagePosition = Mth.m_14045_((int)this.input.m_94211_(suggestioncontext.startPos), (int)0, (int)(this.input.m_94211_(0) + this.input.m_94210_() - i));
            this.commandUsageWidth = i;
        }
    }

    private FormattedCharSequence formatChat(String p_93915_, int p_93916_) {
        return this.currentParse != null ? ModCommandSuggestions.formatText(this.currentParse, p_93915_, p_93916_) : FormattedCharSequence.m_13714_((String)p_93915_, (Style)Style.f_131099_);
    }

    @Nullable
    static String calculateSuggestionSuffix(String pInputText, String pSuggestionText) {
        return pSuggestionText.startsWith(pInputText) ? pSuggestionText.substring(pInputText.length()) : null;
    }

    private static FormattedCharSequence formatText(ParseResults<SharedSuggestionProvider> pProvider, String pCommand, int pMaxLength) {
        int i1;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        int j = -1;
        CommandContextBuilder commandcontextbuilder = pProvider.getContext().getLastChild();
        for (ParsedArgument parsedargument : commandcontextbuilder.getArguments().values()) {
            int k;
            if (++j >= ARGUMENT_STYLES.size()) {
                j = 0;
            }
            if ((k = Math.max(parsedargument.getRange().getStart() - pMaxLength, 0)) >= pCommand.length()) break;
            int l = Math.min(parsedargument.getRange().getEnd() - pMaxLength, pCommand.length());
            if (l <= 0) continue;
            list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(i, k), (Style)LITERAL_STYLE));
            list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(k, l), (Style)ARGUMENT_STYLES.get(j)));
            i = l;
        }
        if (pProvider.getReader().canRead() && (i1 = Math.max(pProvider.getReader().getCursor() - pMaxLength, 0)) < pCommand.length()) {
            int j1 = Math.min(i1 + pProvider.getReader().getRemainingLength(), pCommand.length());
            list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(i, i1), (Style)LITERAL_STYLE));
            list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(i1, j1), (Style)UNPARSED_STYLE));
            i = j1;
        }
        list.add(FormattedCharSequence.m_13714_((String)pCommand.substring(i), (Style)LITERAL_STYLE));
        return FormattedCharSequence.m_13722_((List)list);
    }

    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        if (this.suggestions != null) {
            this.suggestions.render(pPoseStack, pMouseX, pMouseY);
        } else {
            int i = 0;
            for (FormattedCharSequence formattedcharsequence : this.commandUsage) {
                int j = this.anchorToBottom ? this.screen.f_96544_ - 14 - 13 - 12 * i : 72 + 12 * i;
                GuiComponent.m_93172_((PoseStack)pPoseStack, (int)(this.commandUsagePosition - 1), (int)j, (int)(this.commandUsagePosition + this.commandUsageWidth + 1), (int)(j + 12), (int)this.fillColor);
                this.font.m_92744_(pPoseStack, formattedcharsequence, (float)this.commandUsagePosition, (float)(j + 2), -1);
                ++i;
            }
        }
    }

    public String getNarrationMessage() {
        return this.suggestions != null ? "\n" + this.suggestions.getNarrationMessage() : "";
    }

    public class SuggestionsList {
        private final Rect2i rect;
        private final String originalContents;
        private final List<Suggestion> suggestionList;
        private int offset;
        private int current;
        private Vec2 lastMouse = Vec2.f_82462_;
        private boolean tabCycles;
        private int lastNarratedEntry;

        SuggestionsList(int pXPos, int pYPos, int pWidth, List<Suggestion> pSuggestionList, boolean pNarrateFirstSuggestion) {
            int i = pXPos - 1;
            int j = ModCommandSuggestions.this.anchorToBottom ? pYPos - 3 - Math.min(pSuggestionList.size(), ModCommandSuggestions.this.suggestionLineLimit) * 12 : pYPos;
            this.rect = new Rect2i(i, j, pWidth + 1, Math.min(pSuggestionList.size(), ModCommandSuggestions.this.suggestionLineLimit) * 12);
            this.originalContents = ModCommandSuggestions.this.input.m_94155_();
            this.lastNarratedEntry = pNarrateFirstSuggestion ? -1 : 0;
            this.suggestionList = pSuggestionList;
            this.select(0);
        }

        public void render(PoseStack pPoseStack, int pMouseX, int pMouseY) {
            Message message;
            boolean flag3;
            int i = Math.min(this.suggestionList.size(), ModCommandSuggestions.this.suggestionLineLimit);
            boolean flag = this.offset > 0;
            boolean flag1 = this.suggestionList.size() > this.offset + i;
            boolean flag2 = flag || flag1;
            boolean bl = flag3 = this.lastMouse.f_82470_ != (float)pMouseX || this.lastMouse.f_82471_ != (float)pMouseY;
            if (flag3) {
                this.lastMouse = new Vec2((float)pMouseX, (float)pMouseY);
            }
            if (flag2) {
                GuiComponent.m_93172_((PoseStack)pPoseStack, (int)this.rect.m_110085_(), (int)(this.rect.m_110086_() - 1), (int)(this.rect.m_110085_() + this.rect.m_110090_()), (int)this.rect.m_110086_(), (int)ModCommandSuggestions.this.fillColor);
                GuiComponent.m_93172_((PoseStack)pPoseStack, (int)this.rect.m_110085_(), (int)(this.rect.m_110086_() + this.rect.m_110091_()), (int)(this.rect.m_110085_() + this.rect.m_110090_()), (int)(this.rect.m_110086_() + this.rect.m_110091_() + 1), (int)ModCommandSuggestions.this.fillColor);
                if (flag) {
                    for (int k = 0; k < this.rect.m_110090_(); ++k) {
                        if (k % 2 != 0) continue;
                        GuiComponent.m_93172_((PoseStack)pPoseStack, (int)(this.rect.m_110085_() + k), (int)(this.rect.m_110086_() - 1), (int)(this.rect.m_110085_() + k + 1), (int)this.rect.m_110086_(), (int)-1);
                    }
                }
                if (flag1) {
                    for (int i1 = 0; i1 < this.rect.m_110090_(); ++i1) {
                        if (i1 % 2 != 0) continue;
                        GuiComponent.m_93172_((PoseStack)pPoseStack, (int)(this.rect.m_110085_() + i1), (int)(this.rect.m_110086_() + this.rect.m_110091_()), (int)(this.rect.m_110085_() + i1 + 1), (int)(this.rect.m_110086_() + this.rect.m_110091_() + 1), (int)-1);
                    }
                }
            }
            boolean flag4 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestionList.get(l + this.offset);
                GuiComponent.m_93172_((PoseStack)pPoseStack, (int)this.rect.m_110085_(), (int)(this.rect.m_110086_() + 12 * l), (int)(this.rect.m_110085_() + this.rect.m_110090_()), (int)(this.rect.m_110086_() + 12 * l + 12), (int)ModCommandSuggestions.this.fillColor);
                if (pMouseX > this.rect.m_110085_() && pMouseX < this.rect.m_110085_() + this.rect.m_110090_() && pMouseY > this.rect.m_110086_() + 12 * l && pMouseY < this.rect.m_110086_() + 12 * l + 12) {
                    if (flag3) {
                        this.select(l + this.offset);
                    }
                    flag4 = true;
                }
                ModCommandSuggestions.this.font.m_92750_(pPoseStack, suggestion.getText(), (float)(this.rect.m_110085_() + 1), (float)(this.rect.m_110086_() + 2 + 12 * l), l + this.offset == this.current ? -256 : -5592406);
            }
            if (flag4 && (message = this.suggestionList.get(this.current).getTooltip()) != null) {
                ModCommandSuggestions.this.screen.m_96602_(pPoseStack, ComponentUtils.m_130729_((Message)message), pMouseX, pMouseY);
            }
        }

        public boolean mouseClicked(int pMouseX, int pMouseY, int pMouseButton) {
            if (!this.rect.m_110087_(pMouseX, pMouseY)) {
                return false;
            }
            int i = (pMouseY - this.rect.m_110086_()) / 12 + this.offset;
            if (i >= 0 && i < this.suggestionList.size()) {
                this.select(i);
                this.useSuggestion();
            }
            return true;
        }

        public boolean mouseScrolled(int pMouseX, int pMouseY, double pDelta) {
            if (this.rect.m_110087_(pMouseX, pMouseY)) {
                this.offset = Mth.m_14045_((int)((int)((double)this.offset - pDelta)), (int)0, (int)Math.max(this.suggestionList.size() - ModCommandSuggestions.this.suggestionLineLimit, 0));
                return true;
            }
            return false;
        }

        public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (pKeyCode == 265) {
                this.cycle(-1);
                this.tabCycles = false;
                return true;
            }
            if (pKeyCode == 264) {
                this.cycle(1);
                this.tabCycles = false;
                return true;
            }
            if (pKeyCode == 258) {
                if (this.tabCycles) {
                    this.cycle(Screen.m_96638_() ? -1 : 1);
                }
                this.useSuggestion();
                return true;
            }
            if (pKeyCode == 256) {
                this.hide();
                return true;
            }
            return false;
        }

        public void cycle(int pChange) {
            this.select(this.current + pChange);
            int i = this.offset;
            int j = this.offset + ModCommandSuggestions.this.suggestionLineLimit - 1;
            if (this.current < i) {
                this.offset = Mth.m_14045_((int)this.current, (int)0, (int)Math.max(this.suggestionList.size() - ModCommandSuggestions.this.suggestionLineLimit, 0));
            } else if (this.current > j) {
                this.offset = Mth.m_14045_((int)(this.current + ModCommandSuggestions.this.lineStartOffset - ModCommandSuggestions.this.suggestionLineLimit), (int)0, (int)Math.max(this.suggestionList.size() - ModCommandSuggestions.this.suggestionLineLimit, 0));
            }
        }

        public void select(int pIndex) {
            this.current = pIndex;
            if (this.current < 0) {
                this.current += this.suggestionList.size();
            }
            if (this.current >= this.suggestionList.size()) {
                this.current -= this.suggestionList.size();
            }
            Suggestion suggestion = this.suggestionList.get(this.current);
            ModCommandSuggestions.this.input.m_94167_(ModCommandSuggestions.calculateSuggestionSuffix(ModCommandSuggestions.this.input.m_94155_(), suggestion.apply(this.originalContents)));
            if (this.lastNarratedEntry != this.current) {
                // empty if block
            }
        }

        public void useSuggestion() {
            Suggestion suggestion = this.suggestionList.get(this.current);
            ModCommandSuggestions.this.keepSuggestions = true;
            ModCommandSuggestions.this.input.m_94144_(suggestion.apply(this.originalContents));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            ModCommandSuggestions.this.input.m_94196_(i);
            ModCommandSuggestions.this.input.m_94208_(i);
            this.select(this.current);
            ModCommandSuggestions.this.keepSuggestions = false;
            this.tabCycles = true;
        }

        Component getNarrationMessage() {
            this.lastNarratedEntry = this.current;
            Suggestion suggestion = this.suggestionList.get(this.current);
            Message message = suggestion.getTooltip();
            return message != null ? TextUtils.translate((String)"narration.suggestion.tooltip", (Object[])new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText(), message}) : TextUtils.translate((String)"narration.suggestion", (Object[])new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText()});
        }

        public void hide() {
            ModCommandSuggestions.this.suggestions = null;
        }
    }
}

