/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.AliasName;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.network.packets.cts.GlobalSettingsUpdatePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class GlobalSettings {
    private static final String NBT_ALIAS_REGISTRY = "RegisteredAliasData";
    private static final String NBT_BLACKLIST = "StationBlacklist";
    private static final String NBT_TRAIN_BLACKLIST = "TrainBlacklist";
    private static final String NBT_TRAIN_GROUP_REGISTRY = "RegisteredTrainGroups";
    private final Collection<TrainStationAlias> registeredAlias = new CopyOnWriteArrayList<TrainStationAlias>();
    private final Collection<TrainGroup> registeredTrainGroups = new CopyOnWriteArrayList<TrainGroup>();
    private final Collection<String> blacklist = new CopyOnWriteArrayList<String>();
    private final Collection<String> trainsBlacklist = new CopyOnWriteArrayList<String>();

    protected GlobalSettings() {
    }

    public CompoundTag toNbt(CompoundTag pCompoundTag) {
        ListTag blacklistTag;
        ListTag aliasTag;
        if (this.registeredAlias != null && !this.registeredAlias.isEmpty()) {
            aliasTag = new ListTag();
            aliasTag.addAll(this.registeredAlias.stream().map(x -> x.toNbt()).toList());
            pCompoundTag.m_128365_(NBT_ALIAS_REGISTRY, (Tag)aliasTag);
        }
        if (this.registeredTrainGroups != null && !this.registeredTrainGroups.isEmpty()) {
            aliasTag = new ListTag();
            aliasTag.addAll(this.registeredTrainGroups.stream().map(x -> x.toNbt()).toList());
            pCompoundTag.m_128365_(NBT_TRAIN_GROUP_REGISTRY, (Tag)aliasTag);
        }
        if (this.blacklist != null && !this.blacklist.isEmpty()) {
            blacklistTag = new ListTag();
            blacklistTag.addAll(this.blacklist.stream().map(x -> StringTag.m_129297_((String)x)).toList());
            pCompoundTag.m_128365_(NBT_BLACKLIST, (Tag)blacklistTag);
        }
        if (this.trainsBlacklist != null && !this.trainsBlacklist.isEmpty()) {
            blacklistTag = new ListTag();
            blacklistTag.addAll(this.trainsBlacklist.stream().map(x -> StringTag.m_129297_((String)x)).toList());
            pCompoundTag.m_128365_(NBT_TRAIN_BLACKLIST, (Tag)blacklistTag);
        }
        return pCompoundTag;
    }

    public static GlobalSettings fromNbt(CompoundTag tag) {
        List<Object> aliasData = new ArrayList();
        List<Object> trainGroupData = new ArrayList();
        List<Object> blacklistData = new ArrayList();
        List<Object> trainBlacklistData = new ArrayList();
        if (tag.m_128441_(NBT_ALIAS_REGISTRY)) {
            aliasData = tag.m_128437_(NBT_ALIAS_REGISTRY, 10).stream().map(x -> TrainStationAlias.fromNbt((CompoundTag)x)).toList();
        }
        if (tag.m_128441_(NBT_TRAIN_GROUP_REGISTRY)) {
            trainGroupData = tag.m_128437_(NBT_TRAIN_GROUP_REGISTRY, 10).stream().map(x -> TrainGroup.fromNbt((CompoundTag)x)).toList();
        }
        if (tag.m_128441_(NBT_BLACKLIST)) {
            blacklistData = tag.m_128437_(NBT_BLACKLIST, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList();
        }
        if (tag.m_128441_(NBT_TRAIN_BLACKLIST)) {
            trainBlacklistData = tag.m_128437_(NBT_TRAIN_BLACKLIST, 8).stream().map(x -> ((StringTag)x).m_7916_()).toList();
        }
        GlobalSettings instance = new GlobalSettings();
        instance.registeredAlias.addAll(aliasData);
        instance.blacklist.addAll(blacklistData);
        instance.trainsBlacklist.addAll(trainBlacklistData);
        instance.registeredTrainGroups.addAll(trainGroupData);
        return instance;
    }

    public boolean registerAlias(TrainStationAlias alias, Runnable then) {
        GlobalSettingsUpdatePacket.send(alias, GlobalSettingsUpdatePacket.EGlobalSettingsAction.REGISTER_ALIAS, then);
        return true;
    }

    public boolean updateAlias(AliasName name, TrainStationAlias newData, Runnable then) {
        GlobalSettingsUpdatePacket.send(new Object[]{name.get(), newData}, GlobalSettingsUpdatePacket.EGlobalSettingsAction.UPDATE_ALIAS, then);
        return true;
    }

    public boolean unregisterAlias(String name, Runnable then) {
        GlobalSettingsUpdatePacket.send(name, GlobalSettingsUpdatePacket.EGlobalSettingsAction.UNREGISTER_ALIAS_STRING, then);
        return true;
    }

    public boolean unregisterAlias(TrainStationAlias alias, Runnable then) {
        GlobalSettingsUpdatePacket.send(alias, GlobalSettingsUpdatePacket.EGlobalSettingsAction.UNREGISTER_ALIAS, then);
        return true;
    }

    public boolean registerTrainGroup(TrainGroup group, Runnable then) {
        GlobalSettingsUpdatePacket.send(group, GlobalSettingsUpdatePacket.EGlobalSettingsAction.REGISTER_TRAIN_GROUP, then);
        return true;
    }

    public boolean updateTrainGroup(String name, TrainGroup newData, Runnable then) {
        GlobalSettingsUpdatePacket.send(new Object[]{name, newData}, GlobalSettingsUpdatePacket.EGlobalSettingsAction.UPDATE_TRAIN_GROUP, then);
        return true;
    }

    public boolean unregisterTrainGroupTrain(String trainName, Runnable then) {
        GlobalSettingsUpdatePacket.send(trainName, GlobalSettingsUpdatePacket.EGlobalSettingsAction.UNREGISTER_TRAIN_GROUP_TRAIN, then);
        return true;
    }

    public boolean unregisterTrainGroup(TrainGroup group, Runnable then) {
        GlobalSettingsUpdatePacket.send(group, GlobalSettingsUpdatePacket.EGlobalSettingsAction.UNREGISTER_TRAIN_GROUP, then);
        return true;
    }

    public boolean addToBlacklist(String station, Runnable then) {
        GlobalSettingsUpdatePacket.send(station, GlobalSettingsUpdatePacket.EGlobalSettingsAction.ADD_TO_BLACKLIST, then);
        return true;
    }

    public boolean removeFromBlacklist(String name, Runnable then) {
        GlobalSettingsUpdatePacket.send(name, GlobalSettingsUpdatePacket.EGlobalSettingsAction.REMOVE_FROM_BLACKLIST, then);
        return true;
    }

    public boolean addTrainToBlacklist(String trainName, Runnable then) {
        GlobalSettingsUpdatePacket.send(trainName, GlobalSettingsUpdatePacket.EGlobalSettingsAction.ADD_TRAIN_TO_BLACKLIST, then);
        return true;
    }

    public boolean removeTrainFromBlacklist(String name, Runnable then) {
        GlobalSettingsUpdatePacket.send(name, GlobalSettingsUpdatePacket.EGlobalSettingsAction.REMOVE_TRAIN_FROM_BLACKLIST, then);
        return true;
    }

    public boolean registerAliasForStationNames(String name, Collection<String> stations, Runnable then) {
        return this.registerAlias(new TrainStationAlias(AliasName.of(name), stations.stream().collect(Collectors.toMap(x -> x, x -> TrainStationAlias.StationInfo.empty()))), then);
    }

    public boolean registerAlias(String name, Collection<GlobalStation> stations, Runnable then) {
        return this.registerAlias(new TrainStationAlias(AliasName.of(name), stations.stream().collect(Collectors.toMap(x -> x.name, x -> TrainStationAlias.StationInfo.empty()))), then);
    }

    public boolean registerAliasServer(TrainStationAlias alias) {
        if (!this.registeredAlias.contains(alias)) {
            this.registeredAlias.add(alias);
            return true;
        }
        return false;
    }

    public boolean updateAliasServer(AliasName name, TrainStationAlias newData) {
        if (!this.registeredAlias.stream().anyMatch(x -> x.getAliasName().equals(name))) {
            return false;
        }
        this.registeredAlias.stream().filter(x -> x.getAliasName().equals(name)).forEach(x -> x.update(newData));
        return true;
    }

    public boolean unregisterAliasServer(String name) {
        boolean b = this.registeredAlias.removeIf(x -> this.compareAliasAndString((TrainStationAlias)x, name));
        return b;
    }

    public boolean unregisterAliasServer(TrainStationAlias alias) {
        boolean b = this.registeredAlias.removeIf(x -> x.equals(alias));
        return b;
    }

    public boolean registerAliasForStationNamesServer(String name, Collection<String> stations) {
        return this.registerAliasServer(new TrainStationAlias(AliasName.of(name), stations.stream().collect(Collectors.toMap(x -> x, x -> TrainStationAlias.StationInfo.empty()))));
    }

    public boolean registerAliasServer(String name, Collection<GlobalStation> stations) {
        return this.registerAliasServer(new TrainStationAlias(AliasName.of(name), stations.stream().collect(Collectors.toMap(x -> x.name, x -> TrainStationAlias.StationInfo.empty()))));
    }

    public boolean registerTrainGroupServer(TrainGroup group) {
        if (!this.registeredTrainGroups.contains(group)) {
            this.registeredTrainGroups.add(group);
            return true;
        }
        return false;
    }

    public boolean updateTrainGroupServer(String name, TrainGroup newData) {
        if (!this.registeredTrainGroups.stream().anyMatch(x -> x.getGroupName().equals(name))) {
            return false;
        }
        this.registeredTrainGroups.stream().filter(x -> x.getGroupName().equals(name)).forEach(x -> x.update(newData));
        return true;
    }

    public boolean unregisterTrainGroupServer(String name) {
        boolean b = this.registeredTrainGroups.removeIf(x -> x.getGroupName().equals(name));
        return b;
    }

    public boolean unregisterAliasServer(TrainGroup group) {
        boolean b = this.registeredTrainGroups.removeIf(x -> x.equals(group));
        return b;
    }

    public boolean addToBlacklistServer(String station) {
        if (!this.blacklist.contains(station)) {
            this.blacklist.add(station);
            return true;
        }
        return false;
    }

    public boolean removeFromBlacklistServer(String name) {
        boolean b = this.blacklist.removeIf(x -> x.equals(name));
        return b;
    }

    public boolean addTrainToBlacklistServer(String trainName) {
        if (!this.trainsBlacklist.contains(trainName)) {
            this.trainsBlacklist.add(trainName);
            return true;
        }
        return false;
    }

    public boolean removeTrainFromBlacklistServer(String trainName) {
        boolean b = this.trainsBlacklist.removeIf(x -> x.equals(trainName));
        return b;
    }

    public boolean isAliasRegistered(String stationName) {
        return this.registeredAlias.stream().anyMatch(x -> x.contains(stationName));
    }

    public boolean isAliasRegistered(GlobalStation station) {
        return this.isAliasRegistered(station.name);
    }

    private TrainStationAlias getOrCreateAliasFor(String stationName) {
        if (stationName.contains("*")) {
            return this.getOrCreateAliasForWildcard(stationName);
        }
        Optional<TrainStationAlias> a = this.registeredAlias.stream().filter(x -> x.contains(stationName)).findFirst();
        if (a.isPresent()) {
            return a.get();
        }
        return new TrainStationAlias(AliasName.of(stationName), Map.of(stationName, TrainStationAlias.StationInfo.empty()));
    }

    private TrainStationAlias getOrCreateAliasForWildcard(String stationName) {
        String regex = stationName.isBlank() ? stationName : "\\Q" + stationName.replace("*", "\\E.*\\Q") + "\\E";
        Optional<TrainStationAlias> a = this.registeredAlias.stream().filter(x -> x.getAllStationNames().stream().anyMatch(y -> y.matches(regex))).findFirst();
        if (a.isPresent()) {
            return a.get();
        }
        return new TrainStationAlias(AliasName.of(stationName), Map.of(stationName, TrainStationAlias.StationInfo.empty()));
    }

    private Optional<TrainStationAlias> getAlias(String stationName) {
        Optional<TrainStationAlias> a = this.registeredAlias.stream().filter(x -> x.getAliasName().equals(AliasName.of(stationName))).findFirst();
        return a;
    }

    public Collection<TrainStationAlias> getAliasList() {
        return this.registeredAlias;
    }

    public Collection<TrainGroup> getTrainGroupsList() {
        return this.registeredTrainGroups;
    }

    public TrainStationAlias getAliasFor(String stationName) {
        Optional<TrainStationAlias> a = this.getAlias(stationName);
        if (!a.isPresent()) {
            return this.getOrCreateAliasFor(stationName);
        }
        return a.get();
    }

    private boolean compareAliasAndString(TrainStationAlias alias, String name) {
        return alias.getAliasName().get().equals(name);
    }

    public boolean isBlacklisted(String stationName) {
        return this.blacklist.stream().anyMatch(x -> x.contains(stationName));
    }

    public boolean isBlacklisted(TrainStationAlias station) {
        return station.getAllStationNames().stream().allMatch(x -> this.isBlacklisted((String)x));
    }

    public Collection<String> getBlacklist() {
        return this.blacklist;
    }

    public boolean isTrainBlacklisted(Train train) {
        return this.trainsBlacklist.stream().anyMatch(x -> x.equals(train.name.getString()));
    }

    public boolean isTrainBlacklisted(String trainName) {
        return this.trainsBlacklist.stream().anyMatch(x -> x.equals(trainName));
    }

    public Collection<String> getTrainBlacklist() {
        return this.trainsBlacklist;
    }
}

