/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.TrainStationAlias;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;

public class NearestTrackStationResult {
    public final double distance;
    public final Optional<TrainStationAlias> aliasName;

    public NearestTrackStationResult(Optional<GlobalStation> station, double distance) {
        this(station.isPresent() ? GlobalSettingsManager.getInstance().getSettingsData().getAliasFor(station.get().name) : null, distance);
    }

    private NearestTrackStationResult(TrainStationAlias station, double distance) {
        this.distance = distance;
        this.aliasName = station != null ? Optional.of(station) : Optional.empty();
    }

    public static NearestTrackStationResult empty() {
        return new NearestTrackStationResult(Optional.empty(), 0.0);
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.aliasName.isPresent());
        if (this.aliasName.isPresent()) {
            buffer.m_130079_(this.aliasName.get().toNbt());
        }
        buffer.writeDouble(this.distance);
    }

    public static NearestTrackStationResult deserialize(FriendlyByteBuf buffer) {
        boolean valid = buffer.readBoolean();
        TrainStationAlias alias = null;
        if (valid) {
            alias = TrainStationAlias.fromNbt(buffer.m_130260_());
        }
        double distance = buffer.readDouble();
        return new NearestTrackStationResult(alias, distance);
    }
}

