/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Iterate;
import de.mrjulsen.crn.block.be.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.registry.ModBlockEntities;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.ticks.LevelTickAccess;

public abstract class AbstractAdvancedDisplayBlock
extends Block
implements IWrenchable,
IBE<AdvancedDisplayBlockEntity> {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");

    public AbstractAdvancedDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{UP, DOWN, FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        BlockPos clickedPos = context.m_8083_();
        BlockPos placedOnPos = clickedPos.m_121945_(face.m_122424_());
        Level level = context.m_43725_();
        BlockState otherState = level.m_8055_(placedOnPos);
        BlockState stateForPlacement = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        stateForPlacement = otherState.m_60734_() != this || context.m_43723_() != null && context.m_43723_().m_6144_() ? this.getDefaultPlacementState(context, stateForPlacement, otherState) : this.appendOnPlace(context, stateForPlacement, otherState);
        return this.updateColumn(level, clickedPos, stateForPlacement, true);
    }

    public BlockState appendOnPlace(BlockPlaceContext context, BlockState state, BlockState other) {
        Direction otherFacing = (Direction)other.m_61143_((Property)FACING);
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)otherFacing);
        return state;
    }

    public BlockState getDefaultPlacementState(BlockPlaceContext context, BlockState state, BlockState other) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected BlockState updateColumn(Level level, BlockPos pos, BlockState state, boolean present) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        Direction.Axis axis = this.getConnectionAxis(state);
        for (Direction connection : Iterate.directionsInAxis((Direction.Axis)Direction.Axis.Y)) {
            boolean connect = true;
            block1: for (Direction movement : Iterate.directionsInAxis((Direction.Axis)axis)) {
                currentPos.m_122190_((Vec3i)pos);
                for (int i = 0; i < 1000 && level.m_46749_((BlockPos)currentPos); ++i) {
                    BlockPos otherPos = currentPos.m_121945_(connection);
                    BlockState other1 = currentPos.equals((Object)pos) ? state : level.m_8055_((BlockPos)currentPos);
                    BlockState other2 = level.m_8055_(otherPos);
                    boolean col1 = this.canConnect((LevelAccessor)level, pos, state, other1);
                    boolean col2 = this.canConnect((LevelAccessor)level, pos, state, other2);
                    currentPos.m_122173_(movement);
                    if (!col1 && !col2) continue block1;
                    if (col1 && col2) continue;
                    connect = false;
                    break block1;
                }
            }
            state = AbstractAdvancedDisplayBlock.setConnection(state, connection, connect);
        }
        return state;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.m_60734_() == this) {
            return;
        }
        LevelTickAccess blockTicks = pLevel.m_183326_();
        if (!blockTicks.m_183582_(pPos, (Object)this)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
        this.updateNeighbours(pState, pLevel, pPos);
        if (pLevel.f_46443_) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> be.getController().getRenderer().update(pLevel, pPos, pState, (BlockEntity)be, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED));
        }
    }

    public <T extends Comparable<T>> BlockState getPropertyFromNeighbours(BlockState pState, Level pLevel, BlockPos pPos, Property<T> property) {
        Direction leftDirection = ((Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122427_();
        BlockState newState = null;
        BlockPos relPos = pPos.m_121945_(leftDirection);
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        relPos = pPos.m_121945_(Direction.UP);
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        relPos = pPos.m_121945_(leftDirection.m_122424_());
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        relPos = pPos.m_121945_(Direction.DOWN);
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        return pState;
    }

    public <T extends Comparable<T>> BlockState getPropertyFromNeighbour(BlockState pState, Level pLevel, BlockPos pPos, BlockPos relPos, Property<T> property) {
        if (this.canConnectWithBlock((BlockGetter)pLevel, pState, pLevel.m_8055_(relPos))) {
            return (BlockState)pState.m_61124_(property, pLevel.m_8055_(relPos).m_61143_(property));
        }
        return null;
    }

    public void updateNeighbours(BlockState pState, Level pLevel, BlockPos pPos) {
        Direction leftDirection = ((Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122427_();
        BlockPos relPos = pPos.m_121945_(leftDirection);
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
        relPos = pPos.m_121945_(Direction.UP);
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
        relPos = pPos.m_121945_(leftDirection.m_122424_());
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
        relPos = pPos.m_121945_(Direction.DOWN);
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pState.m_60734_() != this) {
            return;
        }
        BlockPos belowPos = pPos.m_121945_(Direction.m_122387_((Direction.Axis)this.getConnectionAxis(pState), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
        BlockState belowState = pLevel.m_8055_(belowPos);
        if (!this.canConnect((LevelAccessor)pLevel, pPos, pState, belowState)) {
            KineticBlockEntity.switchToBlockState((Level)pLevel, (BlockPos)pPos, (BlockState)this.updateColumn((Level)pLevel, pPos, pState, true));
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, AdvancedDisplayBlockEntity::updateControllerStatus);
    }

    public BlockState m_7417_(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        return this.updatedShapeInner(state, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private BlockState updatedShapeInner(BlockState state, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (!this.canConnect(pLevel, pCurrentPos, state, pNeighborState)) {
            return AbstractAdvancedDisplayBlock.setConnection(state, pDirection, false);
        }
        if (pDirection.m_122434_() == this.getConnectionAxis(state)) {
            return this.applyPropertiesOf(state, pNeighborState);
        }
        return AbstractAdvancedDisplayBlock.setConnection(state, pDirection, AbstractAdvancedDisplayBlock.getConnection(pNeighborState, pDirection.m_122424_()));
    }

    public BlockState applyPropertiesOf(BlockState current, BlockState state) {
        BlockState blockState = this.m_49966_();
        for (Property property : state.m_60734_().m_49965_().m_61092_()) {
            if (!blockState.m_61138_(property)) continue;
            if (this.getExcludedProperties().contains(property)) {
                blockState = AbstractAdvancedDisplayBlock.copyPropertyOf(current, blockState, property);
                continue;
            }
            blockState = AbstractAdvancedDisplayBlock.copyPropertyOf(state, blockState, property);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState copyPropertyOf(BlockState sourceState, BlockState targetState, Property<T> property) {
        return (BlockState)targetState.m_61124_(property, sourceState.m_61143_(property));
    }

    protected boolean canConnect(LevelAccessor level, BlockPos pos, BlockState state, BlockState other) {
        return other.m_60734_() == this && state.m_61143_((Property)FACING) == other.m_61143_((Property)FACING);
    }

    public boolean canConnectWithBlock(BlockGetter level, BlockState selfState, BlockState otherState) {
        return selfState.m_60734_() instanceof AbstractAdvancedDisplayBlock && otherState.m_60734_() instanceof AbstractAdvancedDisplayBlock && selfState.m_60734_() == otherState.m_60734_() && selfState.m_61143_((Property)FACING) == otherState.m_61143_((Property)FACING);
    }

    protected Direction.Axis getConnectionAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122427_().m_122434_();
    }

    public static boolean getConnection(BlockState state, Direction side) {
        BooleanProperty property = side == Direction.DOWN ? DOWN : (side == Direction.UP ? UP : null);
        return property != null && (Boolean)state.m_61143_((Property)property) != false;
    }

    public static BlockState setConnection(BlockState state, Direction side, boolean connect) {
        BooleanProperty property;
        Object object = side == Direction.DOWN ? DOWN : (property = side == Direction.UP ? UP : null);
        if (property != null) {
            state = (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(connect));
        }
        return state;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        if (pIsMoving || pNewState.m_60734_() == this) {
            return;
        }
        for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.getConnectionAxis(pState))) {
            BlockPos relative = pPos.m_121945_(d);
            BlockState adjacent = pLevel.m_8055_(relative);
            if (!this.canConnect((LevelAccessor)pLevel, pPos, pState, adjacent)) continue;
            KineticBlockEntity.switchToBlockState((Level)pLevel, (BlockPos)relative, (BlockState)this.updateColumn(pLevel, relative, adjacent, false));
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        DyeItem dyeItem;
        DyeColor dye;
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        AdvancedDisplayBlockEntity blockEntity = ((AdvancedDisplayBlockEntity)pLevel.m_7702_(pPos)).getController();
        Item item = heldItem.m_41720_();
        if (item instanceof DyeItem && (dye = (dyeItem = (DyeItem)item).m_41089_()) != null) {
            pLevel.m_5594_(null, pPos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockEntity.applyToAll(be -> {
                be.setColor(dye == DyeColor.ORANGE ? 0xFF9900 : dye.m_41069_().f_76396_);
                be.notifyUpdate();
            });
            if (pLevel.f_46443_) {
                blockEntity.getRenderer().update(pLevel, pPos, pState, (BlockEntity)blockEntity, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
            }
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_150930_(Items.f_151056_)) {
            pLevel.m_5594_(null, pPos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockEntity.applyToAll(be -> {
                be.setGlowing(true);
                be.notifyUpdate();
            });
            if (pLevel.f_46443_) {
                blockEntity.getRenderer().update(pLevel, pPos, pState, (BlockEntity)blockEntity, IBlockEntityRendererInstance.EUpdateReason.BLOCK_CHANGED);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected boolean updateNeighbour(BlockState pState, Level pLevel, BlockPos pPos, BlockPos neighbourPos) {
        BlockEntity blockEntity;
        if (pLevel.m_8055_(neighbourPos).m_60713_((Block)this) && (blockEntity = pLevel.m_7702_(neighbourPos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity otherBe = (AdvancedDisplayBlockEntity)blockEntity;
            blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof AdvancedDisplayBlockEntity) {
                AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)blockEntity;
                be.copyFrom(otherBe);
                return true;
            }
        }
        return false;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        AdvancedDisplayBlockEntity be;
        AdvancedDisplayBlockEntity controller;
        BlockEntity blockEntity;
        Level level = context.m_43725_();
        if (level.f_46443_ && (blockEntity = level.m_7702_(context.m_8083_())) instanceof AdvancedDisplayBlockEntity && (controller = (be = (AdvancedDisplayBlockEntity)blockEntity).getController()) != null) {
            ClientWrapper.showAdvancedDisplaySettingsScreen(controller);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public Class<AdvancedDisplayBlockEntity> getBlockEntityClass() {
        return AdvancedDisplayBlockEntity.class;
    }

    public BlockEntityType<? extends AdvancedDisplayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModBlockEntities.ADVANCED_DISPLAY_BLOCK_ENTITY.get();
    }

    public abstract boolean isSingleLined();

    public abstract Tripple<Float, Float, Float> getRenderRotation(Level var1, BlockState var2, BlockPos var3);

    public abstract Pair<Float, Float> getRenderOffset(Level var1, BlockState var2, BlockPos var3);

    public abstract Pair<Float, Float> getRenderZOffset(Level var1, BlockState var2, BlockPos var3);

    public abstract Pair<Float, Float> getRenderAspectRatio(Level var1, BlockState var2, BlockPos var3);

    public Collection<Property<?>> getExcludedProperties() {
        return List.of();
    }
}

