/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.widgets.AbstractEntryListOptionWidget;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.WidgetContainerCollection;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.WidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public abstract class AbstractEntryListSettingsScreen<D, W extends AbstractEntryListOptionWidget>
extends DLScreen {
    private static final ResourceLocation GUI = new ResourceLocation("createrailwaysnavigator", "textures/gui/settings.png");
    private static final int GUI_WIDTH = 255;
    private static final int GUI_HEIGHT = 247;
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private static final int ENTRIES_START_Y_OFFSET = 10;
    private final int ENTRY_SPACING = 4;
    private final int AREA_X = 16;
    private final int AREA_Y = 34;
    private final int AREA_W = 220;
    private final int AREA_H = 176;
    private int guiLeft;
    private int guiTop;
    private boolean initialized = false;
    private final Level level;
    private final Font shadowlessFont;
    private final Screen lastScreen;
    private boolean initEntries = false;
    private boolean renderingEntries = false;
    private final WidgetContainerCollection entriesCollection = new WidgetContainerCollection();
    private final WidgetsCollection newEntryCollection = new WidgetsCollection();
    private DLEditBox newEntryInputBox;
    private DLCreateIconButton backButton;
    private DLCreateIconButton addButton;
    private DLEditBox searchBox;
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private final MutableComponent tooltipAdd = TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.add.tooltip");
    private final MutableComponent textEnterName = TextUtils.translate((String)"gui.createrailwaysnavigator.alias_settings.enter_name");
    private boolean cancelFocus = false;

    public AbstractEntryListSettingsScreen(Level level, Screen lastScreen, Component title) {
        super(title);
        this.level = level;
        this.lastScreen = lastScreen;
        this.shadowlessFont = new NoShadowFontWrapper(Minecraft.m_91087_().f_91062_);
    }

    protected abstract D[] getData(String var1);

    protected abstract W createWidget(WidgetCreationData<D, AbstractEntryListSettingsScreen<D, W>> var1, D var2);

    protected void m_7856_() {
        this.initialized = false;
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 127;
        this.guiTop = this.f_96544_ / 2 - 123;
        this.backButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)((DLCreateIconButton)new DLCreateIconButton(this.guiLeft + 21, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_CONFIG_BACK).withCallback((x, y) -> this.m_7379_())));
        this.addTooltip(DLTooltip.of((FormattedText)Constants.TOOLTIP_GO_BACK).assignedTo((AbstractWidget)this.backButton));
        this.addButton = (DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 43, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_ADD));
        this.addButton.withCallback((x, y) -> {
            this.addButton.f_93624_ = false;
            this.newEntryCollection.setVisible(true);
            this.newEntryInputBox.m_94144_("");
        });
        this.addTooltip(DLTooltip.of((FormattedText)this.tooltipAdd).assignedTo((AbstractWidget)this.addButton));
        this.searchBox = this.addEditBox(this.guiLeft + 16 + 1, this.guiTop + 16 + 1, 218, 16, "", Constants.TEXT_SEARCH, true, b -> this.refreshEntries(), this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        this.newEntryCollection.add((AbstractWidget)((DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 145, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_CONFIRM))).withCallback((x, y) -> {
            if (this.newEntryInputBox.m_94155_().isBlank()) {
                return;
            }
            this.onCreateNewEntry(this.newEntryInputBox.m_94155_(), () -> {
                this.refreshEntries();
                this.scroll.chase((double)this.getScrollMax(), (double)0.7f, LerpedFloat.Chaser.EXP);
            });
            this.cancelNewEntryCreation(null);
        }));
        this.newEntryCollection.add((AbstractWidget)((DLCreateIconButton)this.m_142416_((GuiEventListener)new DLCreateIconButton(this.guiLeft + 145 + 18, this.guiTop + 222, 18, 18, (ScreenElement)AllIcons.I_DISABLE))).withCallback((x, y) -> this.cancelNewEntryCreation(null)));
        this.newEntryInputBox = this.addEditBox(this.guiLeft + 44, this.guiTop + 223, 100, 16, "", (Component)this.textEnterName, true, b -> {}, (box, focus) -> {}, null);
        this.newEntryCollection.add((AbstractWidget)this.newEntryInputBox);
        this.initialized = true;
        this.newEntryCollection.setVisible(false);
        this.refreshEntries();
    }

    protected abstract void onCreateNewEntry(String var1, Runnable var2);

    private void cancelNewEntryCreation(DLEditBox excluded) {
        if (this.cancelFocus) {
            return;
        }
        this.cancelFocus = true;
        this.addButton.f_93624_ = true;
        this.newEntryCollection.setVisible(false);
        this.cancelFocus = false;
    }

    protected void refreshEntries() {
        if (!this.initialized) {
            return;
        }
        this.initEntries = true;
        while (this.renderingEntries) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int startY = this.guiTop + 16 + 10;
        ArrayList<WidgetContainer> previousComponents = new ArrayList<WidgetContainer>(this.entriesCollection.components);
        this.entriesCollection.components.forEach(x -> this.m_169411_((GuiEventListener)x));
        this.entriesCollection.components.clear();
        D[] data = this.getData(this.searchBox.m_94155_());
        for (int i = 0; i < data.length; ++i) {
            W w = this.createWidget(new WidgetCreationData(this, this.guiLeft + 16 + 10, startY, previousComponents), data[i]);
            this.entriesCollection.components.add((WidgetContainer)w);
            w.calcHeight();
        }
        this.initEntries = false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public void m_86600_() {
        this.searchBox.m_94120_();
        this.scroll.tickChaser();
        float scrollMax = this.getScrollMax();
        if (this.scroll.getValue() > 0.0f && this.scroll.getValue() > scrollMax) {
            this.scroll.chase((double)Math.max(0.0f, this.getScrollMax()), (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        this.entriesCollection.performForEachOfType(AbstractEntryListOptionWidget.class, x -> x.m_94120_());
        this.newEntryCollection.performForEachOfType(DLEditBox.class, x -> x.m_94120_());
    }

    public int getScrollOffset(float pPartialTicks) {
        return (int)this.scroll.getValue(pPartialTicks);
    }

    private float getScrollMax() {
        float max = -156.0f;
        for (WidgetContainer w : this.entriesCollection.components) {
            max += (float)(4 + w.getHeight());
        }
        return max;
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = Minecraft.m_91087_().m_91296_();
        float scrollOffset = -this.scroll.getValue(pPartialTick);
        this.renderScreenBackground(graphics);
        GuiUtils.drawTexture((ResourceLocation)GUI, (Graphics)graphics, (int)this.guiLeft, (int)this.guiTop, (int)0, (int)0, (int)255, (int)247);
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 19), (int)(this.guiTop + 4), (FormattedText)this.f_96539_, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.m_46468_() + 6000L) % 24000L)), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.guiLeft + 255 - 22 - this.shadowlessFont.m_92895_(timeString)), (int)(this.guiTop + 4), (FormattedText)TextUtils.text((String)timeString), (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.enableScissor((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 34), (int)220, (int)176);
        graphics.poseStack().m_85837_(0.0, (double)scrollOffset, 0.0);
        this.renderingEntries = true;
        while (this.initEntries) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int currentY = this.guiTop + 34 + 10;
        for (int i = 0; i < this.entriesCollection.components.size(); ++i) {
            WidgetContainer widgetContainer = this.entriesCollection.components.get(i);
            if (!(widgetContainer instanceof AbstractEntryListOptionWidget)) continue;
            AbstractEntryListOptionWidget widget = (AbstractEntryListOptionWidget)widgetContainer;
            widget.setYPos(currentY);
            widget.calcHeight();
            if ((float)currentY < (float)(this.guiTop + 34 + 176) - scrollOffset && (float)(currentY + widget.getHeight()) > (float)(this.guiTop + 34) - scrollOffset) {
                widget.m_6305_(graphics.poseStack(), pMouseX, (int)((float)pMouseY - scrollOffset), pPartialTick);
            }
            currentY += widget.getHeight() + 4;
        }
        this.renderingEntries = false;
        GuiUtils.disableScissor((Graphics)graphics);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 34), (int)0, (int)220, (int)10, (int)0x77000000, (int)0);
        GuiUtils.fillGradient((Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 34 + 176 - 10), (int)0, (int)220, (int)10, (int)0, (int)0x77000000);
        int componentHeight = this.entriesCollection.components.stream().mapToInt(x -> x.getHeight() + 4).sum();
        double maxHeight = 20 + componentHeight;
        double aH = 177.0;
        if (aH / maxHeight < 1.0) {
            int scrollerHeight = Math.max(10, (int)(aH * (aH / maxHeight)));
            int startY = this.guiTop + 34 + (int)(176.0 * ((double)Math.abs(scrollOffset) / maxHeight));
            GuiUtils.fill((Graphics)graphics, (int)(this.guiLeft + 16 + 220 - 3), (int)startY, (int)3, (int)scrollerHeight, (int)Integer.MAX_VALUE);
        }
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderFrontLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTicks) {
        this.entriesCollection.performForEachOfType(AbstractEntryListOptionWidget.class, x -> {
            if (pMouseX > this.guiLeft + 16 && pMouseX < this.guiLeft + 16 + 220 && pMouseY > this.guiTop + 34 && pMouseY < this.guiTop + 34 + 176) {
                x.renderFrontLayer(graphics, pMouseX, pMouseY, pPartialTicks);
            }
            x.renderSuggestions(graphics.poseStack(), pMouseX, pMouseY, pPartialTicks);
        });
        super.renderFrontLayer(graphics, pMouseX, pMouseY, pPartialTicks);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        float scrollOffset = this.scroll.getValue();
        for (WidgetContainer w : this.entriesCollection.components) {
            AbstractEntryListOptionWidget entry;
            if (!(pMouseX > (double)(this.guiLeft + 16) && pMouseX < (double)(this.guiLeft + 16 + 220) && pMouseY > (double)(this.guiTop + 34) && pMouseY < (double)(this.guiTop + 34 + 176) && w.m_6375_(pMouseX, pMouseY + (double)scrollOffset, pButton)) && (!(w instanceof AbstractEntryListOptionWidget) || !(entry = (AbstractEntryListOptionWidget)w).mouseClickedLoop(pMouseX, pMouseY + (double)scrollOffset, pButton))) continue;
            break;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        float scrollOffset = this.scroll.getValue();
        for (WidgetContainer w : this.entriesCollection.components) {
            AbstractEntryListOptionWidget entry;
            if (w instanceof AbstractEntryListOptionWidget && (entry = (AbstractEntryListOptionWidget)w).mouseScrolledLoop(pMouseX, pMouseY + (double)scrollOffset, pDelta)) {
                return true;
            }
            if (!(pMouseX > (double)(this.guiLeft + 16)) || !(pMouseX < (double)(this.guiLeft + 16 + 220)) || !(pMouseY > (double)(this.guiTop + 34)) || !(pMouseY < (double)(this.guiTop + 34 + 176)) || !w.m_6050_(pMouseX, pMouseY + (double)scrollOffset, pDelta)) continue;
            return true;
        }
        float chaseTarget = this.scroll.getChaseTarget();
        float max = this.getScrollMax();
        if (max > 0.0f) {
            chaseTarget = (float)((double)chaseTarget - pDelta * 12.0);
            chaseTarget = MathUtils.clamp((float)chaseTarget, (float)0.0f, (float)max);
            this.scroll.chase((double)((int)chaseTarget), (double)0.7f, LerpedFloat.Chaser.EXP);
        } else {
            this.scroll.chase(0.0, (double)0.7f, LerpedFloat.Chaser.EXP);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        for (WidgetContainer w : this.entriesCollection.components) {
            if (!w.m_7933_(pKeyCode, pScanCode, pModifiers)) continue;
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        for (WidgetContainer w : this.entriesCollection.components) {
            if (!w.m_5534_(pCodePoint, pModifiers)) continue;
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    public record WidgetCreationData<D, W extends AbstractEntryListSettingsScreen<D, ?>>(W parent, int x, int y, List<?> previousEntries) {
    }
}

