/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.AbstractEntryListSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.AbstractEntryListOptionWidget;
import de.mrjulsen.crn.client.gui.widgets.ModStationSuggestions;
import de.mrjulsen.crn.data.ClientTrainStationSnapshot;
import de.mrjulsen.crn.data.GlobalSettingsManager;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TrainGroupEntryWidget
extends AbstractEntryListOptionWidget {
    private static final ResourceLocation GUI_WIDGETS = new ResourceLocation("createrailwaysnavigator", "textures/gui/settings_widgets.png");
    public static final int WIDTH = 200;
    public static final int HEIGHT = 48;
    private static final int STATION_ENTRY_HEIGHT = 20;
    private final AbstractEntryListSettingsScreen<TrainGroup, TrainGroupEntryWidget> parent;
    private final Font shadowlessFont;
    private final Minecraft minecraft;
    private final Runnable onUpdate;
    private TrainGroup trainGroup;
    private boolean expanded = false;
    private final DLEditBox titleBox;
    private final DLEditBox newEntryBox;
    private final Map<String, GuiAreaDefinition> removeStationButtons = new HashMap<String, GuiAreaDefinition>();
    private final Map<String, GuiAreaDefinition> trainGroupNames = new HashMap<String, GuiAreaDefinition>();
    private GuiAreaDefinition titleBarArea;
    private GuiAreaDefinition deleteButton;
    private GuiAreaDefinition expandButton;
    private GuiAreaDefinition addButton;
    private ModStationSuggestions suggestions;
    private final MutableComponent tooltipDeleteAlias = TextUtils.translate((String)"gui.createrailwaysnavigator.train_group_settings.delete_alias.tooltip");
    private final MutableComponent tooltipDeleteStation = TextUtils.translate((String)"gui.createrailwaysnavigator.train_group_settings.delete_station.tooltip");
    private final MutableComponent tooltipAddStation = TextUtils.translate((String)"gui.createrailwaysnavigator.train_group_settings.add_station.tooltip");

    public TrainGroupEntryWidget(AbstractEntryListSettingsScreen<TrainGroup, TrainGroupEntryWidget> parent, int pX, int pY, TrainGroup trainGroup, Runnable onUpdate, boolean expanded) {
        super(pX, pY, 200, 48);
        Minecraft minecraft = Minecraft.m_91087_();
        this.shadowlessFont = new NoShadowFontWrapper(minecraft.f_91062_);
        this.minecraft = Minecraft.m_91087_();
        this.parent = parent;
        this.trainGroup = trainGroup;
        this.expanded = expanded;
        this.onUpdate = onUpdate;
        this.titleBox = new DLEditBox(minecraft.f_91062_, pX + 30, pY + 10, 129, 12, (Component)TextUtils.empty());
        this.titleBox.m_94182_(false);
        this.titleBox.m_94199_(32);
        this.titleBox.m_94202_(0xFFFFFF);
        this.titleBox.m_94144_(trainGroup.getGroupName());
        this.titleBox.withOnFocusChanged((box, focused) -> {
            if (!focused.booleanValue() && !this.setGroupName(box.m_94155_())) {
                this.titleBox.m_94144_(trainGroup.getGroupName());
            }
        });
        this.titleBox.f_93624_ = expanded;
        this.addRenderableWidget((GuiEventListener)this.titleBox);
        this.newEntryBox = new DLEditBox(minecraft.f_91062_, pX + 30, pY + 30, 129, 12, (Component)TextUtils.empty());
        this.newEntryBox.m_94182_(false);
        this.newEntryBox.m_94199_(32);
        this.newEntryBox.m_94202_(0xFFFFFF);
        this.newEntryBox.f_93624_ = expanded;
        this.newEntryBox.m_94151_(x -> this.updateEditorSubwidgets(this.newEntryBox));
        this.addRenderableWidget((GuiEventListener)this.newEntryBox);
        this.setYPos(pY);
    }

    public TrainGroup getTrainGroup() {
        return this.trainGroup;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    private void initStationDeleteButtons() {
        this.removeStationButtons.clear();
        this.trainGroupNames.clear();
        String[] names = (String[])this.trainGroup.getTrainNames().toArray(String[]::new);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            this.removeStationButtons.put(name, new GuiAreaDefinition(this.x + 165, this.y + 26 + i * 20 + 2, 16, 16));
            this.trainGroupNames.put(name, new GuiAreaDefinition(this.x + 25, this.y + 26 + i * 20 + 2, 129, 16));
        }
        this.titleBarArea = new GuiAreaDefinition(this.x + 25, this.y + 6, 129, 16);
    }

    @Override
    public void m_94120_() {
        super.m_94120_();
        if (this.suggestions != null) {
            this.suggestions.tick();
            if (!this.newEntryBox.m_94204_()) {
                this.clearSuggestions();
            }
        }
    }

    private void toggleExpanded() {
        this.titleBox.f_93624_ = this.expanded = !this.expanded;
        this.newEntryBox.f_93624_ = this.expanded;
    }

    private void deleteTrainGroup() {
        GlobalSettingsManager.getInstance().getSettingsData().unregisterTrainGroup(this.trainGroup, this.onUpdate);
    }

    private void addTrain(String name) {
        String prevName = this.trainGroup.getGroupName();
        if (ClientTrainStationSnapshot.getInstance().getAllTrainNames().stream().noneMatch(x -> x.equals(name)) || this.newEntryBox.m_94155_().isBlank()) {
            return;
        }
        this.trainGroup.add(name);
        this.trainGroup.updateLastEdited(this.minecraft.f_91074_.m_7755_().getString());
        GlobalSettingsManager.getInstance().getSettingsData().updateTrainGroup(prevName, this.trainGroup, () -> {
            this.onUpdate.run();
            this.initStationDeleteButtons();
        });
        this.newEntryBox.m_94144_("");
        this.newEntryBox.m_94178_(false);
    }

    private boolean setGroupName(String name) {
        String prevName = this.trainGroup.getGroupName();
        if (name == null || name.isBlank()) {
            return false;
        }
        if (GlobalSettingsManager.getInstance().getSettingsData().getTrainGroupsList().stream().anyMatch(x -> x.getGroupName().equals(name))) {
            return false;
        }
        this.trainGroup.setGroupName(name);
        this.trainGroup.updateLastEdited(this.minecraft.f_91074_.m_7755_().getString());
        GlobalSettingsManager.getInstance().getSettingsData().updateTrainGroup(prevName, this.trainGroup, this.onUpdate);
        return true;
    }

    private void removeTrain(String name) {
        String prevName = this.trainGroup.getGroupName();
        this.trainGroup.remove(name);
        this.trainGroup.updateLastEdited(this.minecraft.f_91074_.m_7755_().getString());
        GlobalSettingsManager.getInstance().getSettingsData().updateTrainGroup(prevName, this.trainGroup, () -> {
            this.onUpdate.run();
            this.initStationDeleteButtons();
        });
        this.initStationDeleteButtons();
        this.onUpdate.run();
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public int calcHeight() {
        this.height = this.expanded ? 20 * this.trainGroup.getTrainNames().size() + 50 : 48;
        return this.height;
    }

    @Override
    public void setYPos(int y) {
        this.y = y;
        this.deleteButton = new GuiAreaDefinition(this.x + 165, y + 6, 16, 16);
        this.expandButton = new GuiAreaDefinition(this.x + 182, y + 6, 16, 16);
        this.addButton = new GuiAreaDefinition(this.x + 165, y + 26 + this.trainGroup.getTrainNames().size() * 20 + 2, 16, 16);
        this.titleBox.f_93621_ = y + 10;
        this.initStationDeleteButtons();
    }

    @Override
    public void renderSuggestions(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.suggestions != null) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, (double)(-this.parent.getScrollOffset(partialTicks)), 500.0);
            this.suggestions.render(poseStack, mouseX, mouseY + this.parent.getScrollOffset(partialTicks));
            poseStack.m_85849_();
        }
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_WIDGETS);
        GuiUtils.drawTexture((ResourceLocation)GUI_WIDGETS, (Graphics)graphics, (int)this.x, (int)this.y, (int)0, (int)0, (int)200, (int)48);
        GuiUtils.drawTexture((ResourceLocation)GUI_WIDGETS, (Graphics)graphics, (int)this.deleteButton.getX(), (int)this.deleteButton.getY(), (int)232, (int)0, (int)16, (int)16);
        GuiUtils.drawTexture((ResourceLocation)GUI_WIDGETS, (Graphics)graphics, (int)this.expandButton.getX(), (int)this.expandButton.getY(), (int)(this.expanded ? 216 : 200), (int)0, (int)16, (int)16);
        if (this.expanded) {
            Set<String> names = this.trainGroup.getTrainNames();
            GuiUtils.drawTexture((ResourceLocation)GUI_WIDGETS, (Graphics)graphics, (int)(this.x + 25), (int)(this.y + 5), (int)0, (int)92, (int)139, (int)18);
            this.newEntryBox.f_93621_ = this.y + 26 + names.size() * 20 + 6;
            for (int i = 0; i < names.size(); ++i) {
                GuiUtils.drawTexture((ResourceLocation)GUI_WIDGETS, (Graphics)graphics, (int)this.x, (int)(this.y + 26 + i * 20), (int)0, (int)48, (int)200, (int)20);
            }
            GuiUtils.drawTexture((ResourceLocation)GUI_WIDGETS, (Graphics)graphics, (int)this.x, (int)(this.y + 26 + names.size() * 20), (int)0, (int)68, (int)200, (int)24);
            CreateDynamicWidgets.renderTextBox(graphics, this.x + 25, this.y + 26 + names.size() * 20 + 1, 139);
            GuiUtils.drawTexture((ResourceLocation)GUI_WIDGETS, (Graphics)graphics, (int)this.addButton.getX(), (int)this.addButton.getY(), (int)200, (int)16, (int)16, (int)16);
            for (GuiAreaDefinition guiAreaDefinition : this.removeStationButtons.values()) {
                GuiUtils.drawTexture((ResourceLocation)GUI_WIDGETS, (Graphics)graphics, (int)guiAreaDefinition.getX(), (int)guiAreaDefinition.getY(), (int)232, (int)0, (int)16, (int)16);
            }
            int i = 0;
            for (String entry : names) {
                GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.x + 30), (int)(this.y + 26 + i * 20 + 6), (FormattedText)TextUtils.text((String)entry), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
                ++i;
            }
        } else {
            MutableComponent name = TextUtils.text((String)this.trainGroup.getGroupName());
            int maxTextWidth = 129;
            if (this.shadowlessFont.m_92852_((FormattedText)name) > maxTextWidth) {
                name = TextUtils.text((String)this.shadowlessFont.m_92854_((FormattedText)name, maxTextWidth).getString()).m_7220_(Constants.ELLIPSIS_STRING);
            }
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)(this.x + 30), (int)(this.y + 10), (FormattedText)name, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
            graphics.poseStack().m_85841_(0.75f, 0.75f, 0.75f);
            GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(this.x + 5) / 0.75f)), (int)((int)((float)(this.y + 30) / 0.75f)), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.train_group_settings.summary", (Object[])new Object[]{this.trainGroup.getTrainNames().size()}), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
            if (this.trainGroup.getLastEditorName() != null && !this.trainGroup.getLastEditorName().isBlank()) {
                GuiUtils.drawString((Graphics)graphics, (Font)this.shadowlessFont, (int)((int)((float)(this.x + 5) / 0.75f)), (int)((int)((float)(this.y + 38) / 0.75f)), (FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.train_group_settings.editor", (Object[])new Object[]{this.trainGroup.getLastEditorName(), this.trainGroup.getLastEditedTimeFormatted()}), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
            }
            float f = 1.3333334f;
            graphics.poseStack().m_85841_(f, f, f);
        }
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.deleteButton.isInBounds((double)pMouseX, (double)pMouseY)) {
            GuiUtils.fill((Graphics)graphics, (int)this.deleteButton.getX(), (int)this.deleteButton.getY(), (int)this.deleteButton.getWidth(), (int)this.deleteButton.getHeight(), (int)0x1AFFFFFF);
        } else if (this.expandButton.isInBounds((double)pMouseX, (double)pMouseY)) {
            GuiUtils.fill((Graphics)graphics, (int)this.expandButton.getX(), (int)this.expandButton.getY(), (int)this.expandButton.getWidth(), (int)this.expandButton.getHeight(), (int)0x1AFFFFFF);
        } else if (this.expanded && this.addButton.isInBounds((double)pMouseX, (double)pMouseY)) {
            GuiUtils.fill((Graphics)graphics, (int)this.addButton.getX(), (int)this.addButton.getY(), (int)this.addButton.getWidth(), (int)this.addButton.getHeight(), (int)0x1AFFFFFF);
        } else if (this.expanded && this.removeStationButtons.values().stream().anyMatch(x -> x.isInBounds((double)pMouseX, (double)pMouseY))) {
            for (Map.Entry<String, GuiAreaDefinition> entry : this.removeStationButtons.entrySet()) {
                if (!entry.getValue().isInBounds((double)pMouseX, (double)pMouseY)) continue;
                GuiUtils.fill((Graphics)graphics, (int)entry.getValue().getX(), (int)entry.getValue().getY(), (int)entry.getValue().getWidth(), (int)entry.getValue().getHeight(), (int)0x1AFFFFFF);
            }
        }
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.suggestions != null) {
            graphics.poseStack().m_85836_();
            graphics.poseStack().m_85837_(0.0, (double)(-this.parent.getScrollOffset(partialTicks)), 500.0);
            this.suggestions.render(graphics.poseStack(), mouseX, mouseY + this.parent.getScrollOffset(partialTicks));
            graphics.poseStack().m_85849_();
        }
        GuiUtils.renderTooltipWithOffset(this.parent, (GuiAreaDefinition)this.deleteButton, List.of(this.tooltipDeleteAlias), (int)this.width, (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
        GuiUtils.renderTooltipWithOffset(this.parent, (GuiAreaDefinition)this.expandButton, List.of(this.expanded ? Constants.TOOLTIP_COLLAPSE : Constants.TOOLTIP_EXPAND), (int)this.width, (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
        if (this.expanded) {
            GuiUtils.renderTooltipWithOffset(this.parent, (GuiAreaDefinition)this.addButton, List.of(this.tooltipAddStation), (int)this.width, (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
            for (Map.Entry<String, GuiAreaDefinition> entry : this.removeStationButtons.entrySet()) {
                if (GuiUtils.renderTooltipWithOffset(this.parent, (GuiAreaDefinition)entry.getValue(), List.of(this.tooltipDeleteStation), (int)this.width, (Graphics)graphics, (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks))) break;
            }
            for (Map.Entry<String, GuiAreaDefinition> entry : this.trainGroupNames.entrySet()) {
                if (this.shadowlessFont.m_92895_(entry.getKey()) > 129 && GuiUtils.renderTooltipAt(this.parent, (GuiAreaDefinition)entry.getValue(), List.of(TextUtils.text((String)entry.getKey())), (int)this.width, (Graphics)graphics, (int)(entry.getValue().getLeft() + 1), (int)(entry.getValue().getTop() - this.parent.getScrollOffset(partialTicks)), (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks))) break;
            }
        } else if (this.titleBarArea.isInBounds((double)mouseX, (double)(mouseY + this.parent.getScrollOffset(partialTicks))) && this.shadowlessFont.m_92895_(this.trainGroup.getGroupName()) > 129) {
            GuiUtils.renderTooltipAt(this.parent, (GuiAreaDefinition)this.titleBarArea, List.of(TextUtils.text((String)this.trainGroup.getGroupName())), (int)this.width, (Graphics)graphics, (int)(this.titleBarArea.getLeft() + 1), (int)(this.titleBarArea.getTop() - this.parent.getScrollOffset(partialTicks)), (int)mouseX, (int)mouseY, (int)0, (int)this.parent.getScrollOffset(partialTicks));
        }
    }

    @Override
    public boolean mouseClickedLoop(double pMouseX, double pMouseY, int pButton) {
        if (this.suggestions != null && this.suggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        return false;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.suggestions != null && this.suggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        if (this.deleteButton.isInBounds(pMouseX, pMouseY)) {
            this.deleteTrainGroup();
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        if (this.expandButton.isInBounds(pMouseX, pMouseY)) {
            this.toggleExpanded();
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        if (this.expanded && this.addButton.isInBounds(pMouseX, pMouseY)) {
            this.addTrain(this.newEntryBox.m_94155_());
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        if (this.expanded && this.removeStationButtons.values().stream().anyMatch(x -> x.isInBounds(pMouseX, pMouseY))) {
            for (Map.Entry<String, GuiAreaDefinition> entry : this.removeStationButtons.entrySet()) {
                if (!entry.getValue().isInBounds(pMouseX, pMouseY)) continue;
                this.removeTrain(entry.getKey());
                return super.m_6375_(pMouseX, pMouseY, pButton);
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean mouseScrolledLoop(double pMouseX, double pMouseY, double pDelta) {
        return this.suggestions != null && this.suggestions.mouseScrolled(pMouseX, pMouseY, MathUtils.clamp((double)pDelta, (double)-1.0, (double)1.0));
    }

    private void clearSuggestions() {
        if (this.suggestions != null) {
            this.suggestions.getEditBox().m_94167_("");
        }
        this.suggestions = null;
    }

    protected void updateEditorSubwidgets(DLEditBox field) {
        this.clearSuggestions();
        this.suggestions = new ModStationSuggestions(this.minecraft, (Screen)this.parent, (EditBox)field, this.minecraft.f_91062_, this.getViableTrains(field), field.m_93694_() + 2 + field.f_93621_);
        this.suggestions.setAllowSuggestions(true);
        this.suggestions.updateCommandInfo();
    }

    private List<String> getViableTrains(DLEditBox field) {
        return ClientTrainStationSnapshot.getInstance().getAllTrainNames().stream().distinct().filter(x -> !GlobalSettingsManager.getInstance().getSettingsData().isTrainBlacklisted((String)x) && !this.trainGroup.contains((String)x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

