/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.data.GlobalSettings;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.crn.network.packets.cts.GlobalSettingsRequestPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class GlobalSettingsManager
extends SavedData {
    private static final String FILE_ID = "createrailwaysnavigator_global_settings";
    private static volatile GlobalSettingsManager instance;
    private GlobalSettings settingsData;

    private GlobalSettingsManager() {
        this.settingsData = new GlobalSettings();
        CreateRailwaysNavigator.LOGGER.info("Created new Create Railways Navigator settings instance.");
    }

    private GlobalSettingsManager(GlobalSettings settings) {
        instance = this;
        this.settingsData = settings;
    }

    public static GlobalSettingsManager createClientInstance() {
        if (instance == null) {
            instance = new GlobalSettingsManager();
        }
        return instance;
    }

    public static GlobalSettingsManager getInstance() {
        if (instance == null) {
            MinecraftServer server = CRNPlatformSpecific.getServer();
            if (server == null) {
                instance = new GlobalSettingsManager();
            } else {
                CreateRailwaysNavigator.LOGGER.debug("Create Instance");
                ServerLevel level = server.m_129783_();
                instance = (GlobalSettingsManager)level.m_8895_().m_164861_(GlobalSettingsManager::load, GlobalSettingsManager::new, FILE_ID);
            }
        }
        return instance;
    }

    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        return this.settingsData.toNbt(pCompoundTag);
    }

    private static GlobalSettingsManager load(CompoundTag tag) {
        GlobalSettings settings = GlobalSettings.fromNbt(tag);
        return new GlobalSettingsManager(settings);
    }

    public final GlobalSettings getSettingsData() {
        return this.settingsData;
    }

    public void updateSettingsData(GlobalSettings settings) {
        this.settingsData = settings;
        this.m_77762_();
    }

    public static void syncToClient(Runnable then) {
        long id = InstanceManager.registerClientResponseReceievedAction(then);
        CreateRailwaysNavigator.net().CHANNEL.sendToServer((Object)new GlobalSettingsRequestPacket(id));
    }

    public static void close() {
        instance = null;
        CreateRailwaysNavigator.LOGGER.info("Closed current Create Railways Navigator settings instance.");
    }
}

