/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.GlobalTrainData;
import de.mrjulsen.crn.data.TrainStationAlias;
import de.mrjulsen.crn.data.TrainStop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.level.Level;

public class RoutePart {
    private Train train;
    private TrainStop start;
    private TrainStop end;
    private Collection<TrainStop> stops;

    public RoutePart(Level level, Train train, TrainStationAlias start, TrainStationAlias end, int startTicks) {
        this.train = train;
        ArrayList<TrainStop> stops = new ArrayList<TrainStop>(GlobalTrainData.getInstance().getAllStopoversOfTrainSortedNew(train, start, end, true, true));
        TrainStop startStop = (TrainStop)stops.get(0);
        if (startStop.getPrediction().getTicks() < startTicks && startStop.getPrediction().getTrainCycleDuration() > 0) {
            int diffTicks = startTicks - startStop.getPrediction().getTicks();
            int mul = diffTicks / startStop.getPrediction().getTrainCycleDuration() + 1;
            stops = new ArrayList<TrainStop>(stops.stream().map(x -> new TrainStop(x.getStationAlias(), DeparturePrediction.withCycleTicks(x.getPrediction(), mul))).toList());
        }
        this.end = (TrainStop)stops.remove(stops.size() - 1);
        this.start = (TrainStop)stops.remove(0);
        this.stops = stops;
    }

    public Train getTrain() {
        return this.train;
    }

    public TrainStop getStartStation() {
        return this.start;
    }

    public TrainStop getEndStation() {
        return this.end;
    }

    public Collection<TrainStop> getStopovers() {
        return this.stops;
    }

    public int arrivesAtStartStationIn() {
        Optional<DeparturePrediction> data = GlobalTrainData.getInstance().getNextTrainStopDataAt(this.getTrain(), this.getStartStation().getStationAlias());
        if (data.isPresent()) {
            return data.get().getTicks();
        }
        return 0;
    }

    public int arrivesAtEndStationIn() {
        Optional<DeparturePrediction> data = GlobalTrainData.getInstance().getNextTrainStopDataAt(this.getTrain(), this.getEndStation().getStationAlias());
        if (data.isPresent()) {
            return data.get().getTicks();
        }
        return 0;
    }

    public int getStationCount(boolean includeStartEnd) {
        return this.getStopovers().size() + (includeStartEnd ? 2 : 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RoutePart) {
            RoutePart other = (RoutePart)obj;
            return this.getStartStation().equals(other.getStartStation()) && this.getEndStation().equals(other.getEndStation()) && this.getStopovers().size() == other.getStopovers().size() && this.getStopovers().stream().allMatch(x -> other.getStopovers().stream().anyMatch(y -> y.equals(x)));
        }
        return false;
    }

    public boolean exactEquals(Object obj, boolean respectTrains) {
        if (obj instanceof RoutePart) {
            RoutePart other = (RoutePart)obj;
            if (!this.getStartStation().equals(other.getStartStation()) || !this.getEndStation().equals(other.getEndStation()) || this.getStopovers().size() != other.getStopovers().size()) {
                return false;
            }
            TrainStop[] a = (TrainStop[])this.getStopovers().toArray(TrainStop[]::new);
            TrainStop[] b = (TrainStop[])other.getStopovers().toArray(TrainStop[]::new);
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals(b[i])) continue;
                return false;
            }
            return !respectTrains || this.train.equals(other.train);
        }
        return false;
    }

    public String toString() {
        return String.format("%s, From: %s (%s), To: %s (%s), via: %s", this.getTrain().name.getString(), this.getStartStation().getStationAlias().getAliasName(), this.arrivesAtStartStationIn(), this.getEndStation().getStationAlias().getAliasName(), this.arrivesAtEndStationIn(), Arrays.toString(this.stops.toArray()));
    }

    public String getString() {
        return String.format("Train: %s, From: %s in %st, To: %s in %s, Stops: %s", this.getTrain().name.getString(), this.getStartStation().getStationAlias().getAliasName(), this.arrivesAtStartStationIn(), this.getEndStation().getStationAlias().getAliasName(), this.arrivesAtEndStationIn(), Arrays.toString(this.stops.toArray()));
    }
}

