/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class TrainGroup {
    private static final String NBT_NAME = "Name";
    private static final String NBT_TRAIN_NAMES = "Trains";
    private static final String NBT_LAST_EDITOR = "LastEditor";
    private static final String NBT_LAST_EDITED_TIME = "LastEditedTimestamp";
    private String name;
    private Set<String> trainNames = new HashSet<String>();
    protected String lastEditorName = null;
    protected long lastEditedTime = 0L;

    public TrainGroup(String name) {
        this.name = name;
    }

    public TrainGroup(String name, Set<String> initialValues) {
        this.name = name;
        this.trainNames = initialValues;
    }

    public void addTrain(Train train) {
        this.addTrain(train.name.getString());
    }

    public void addTrain(String trainName) {
        this.trainNames.add(trainName);
    }

    public Set<String> getTrainNames() {
        return this.trainNames;
    }

    public boolean contains(Train train) {
        return this.trainNames.stream().anyMatch(x -> x.equals(train.name.getString()));
    }

    public boolean contains(String trainName) {
        return this.trainNames.stream().anyMatch(x -> x.equals(trainName));
    }

    public void setGroupName(String name) {
        this.name = name;
    }

    public String getGroupName() {
        return this.name;
    }

    public void update(TrainGroup newData) {
        this.name = newData.name;
        this.trainNames = newData.trainNames;
        this.lastEditedTime = newData.lastEditedTime;
        this.lastEditorName = newData.lastEditorName;
    }

    public void add(String trainName) {
        this.trainNames.add(trainName);
    }

    public void addAll(Set<String> trainNames) {
        this.trainNames.addAll(trainNames);
    }

    public void add(Train train) {
        this.add(train.name.getString());
    }

    public void addAllTrains(Set<Train> trains) {
        this.trainNames.addAll(trains.stream().map(x -> x.name.getString()).toList());
    }

    public void remove(Train train) {
        this.remove(train.name.getString());
    }

    public void remove(String trainName) {
        this.trainNames.removeIf(x -> x.equals(trainName));
    }

    public String getLastEditorName() {
        return this.lastEditorName;
    }

    public void updateLastEdited(String name) {
        this.lastEditorName = name;
        this.lastEditedTime = new Date().getTime();
    }

    public Date getLastEditedTime() {
        return new Date(this.lastEditedTime);
    }

    public String getLastEditedTimeFormatted() {
        return DragonLib.DATE_FORMAT.format(this.getLastEditedTime());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.trainNames);
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        if (this.lastEditorName != null) {
            nbt.m_128359_(NBT_LAST_EDITOR, this.getLastEditorName());
        }
        nbt.m_128356_(NBT_LAST_EDITED_TIME, this.lastEditedTime);
        nbt.m_128359_(NBT_NAME, this.getGroupName());
        ListTag tag = new ListTag();
        tag.addAll(this.getTrainNames().stream().map(x -> StringTag.m_129297_((String)x)).toList());
        nbt.m_128365_(NBT_TRAIN_NAMES, (Tag)tag);
        return nbt;
    }

    public static TrainGroup fromNbt(CompoundTag nbt) {
        String groupName = nbt.m_128461_(NBT_NAME);
        HashSet<String> trainNames = new HashSet<String>(nbt.m_128437_(NBT_TRAIN_NAMES, 8).stream().map(x -> ((StringTag)x).m_7916_()).collect(Collectors.toSet()));
        String lastEditorName = nbt.m_128441_(NBT_LAST_EDITOR) ? nbt.m_128461_(NBT_LAST_EDITOR) : null;
        long lastEditedTime = nbt.m_128454_(NBT_LAST_EDITED_TIME);
        TrainGroup group = new TrainGroup(groupName, trainNames);
        group.lastEditedTime = lastEditedTime;
        group.lastEditorName = lastEditorName;
        return group;
    }
}

