/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.data.TrainStationAlias;
import java.util.Objects;

public class TrainStop {
    private TrainStationAlias station;
    private DeparturePrediction prediction;

    public TrainStop(TrainStationAlias station, DeparturePrediction prediction) {
        this.station = station;
        this.prediction = prediction;
    }

    public TrainStop copy() {
        return new TrainStop(this.getStationAlias().copy(), this.getPrediction().copy());
    }

    public TrainStationAlias getStationAlias() {
        return this.station;
    }

    public DeparturePrediction getPrediction() {
        return this.prediction;
    }

    public boolean isStation(GlobalStation station) {
        return this.getStationAlias().contains(station.name);
    }

    public boolean isStationAlias(TrainStationAlias alias) {
        return this.getStationAlias().equals(alias);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrainStop) {
            TrainStop other = (TrainStop)obj;
            return this.getStationAlias().equals(other.getStationAlias());
        }
        return false;
    }

    public boolean identical(TrainStop other) {
        return this.getStationAlias().equals(other.getStationAlias()) && this.prediction.getTicks() == other.getPrediction().getTicks();
    }

    public int hashCode() {
        return 13 * Objects.hash(this.station);
    }

    public String toString() {
        return String.format("%s (%s)", this.getStationAlias(), this.prediction.getTicks());
    }
}

