/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.stc;

import de.mrjulsen.crn.data.DeparturePrediction;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class RealtimeResponsePacket
implements IPacketBase<RealtimeResponsePacket> {
    public long id;
    public Collection<DeparturePrediction.SimpleDeparturePrediction> departure;
    public long time;

    public RealtimeResponsePacket() {
    }

    public RealtimeResponsePacket(long id, Collection<DeparturePrediction.SimpleDeparturePrediction> departure, long time) {
        this.id = id;
        this.departure = departure;
        this.time = time;
    }

    public void encode(RealtimeResponsePacket packet, FriendlyByteBuf buffer) {
        buffer.writeLong(packet.id);
        buffer.writeLong(packet.time);
        buffer.writeInt(packet.departure.size());
        for (DeparturePrediction.SimpleDeparturePrediction s : packet.departure) {
            buffer.m_130079_(s.toNbt());
        }
    }

    public RealtimeResponsePacket decode(FriendlyByteBuf buffer) {
        long id = buffer.readLong();
        long time = buffer.readLong();
        int count = buffer.readInt();
        ArrayList<DeparturePrediction.SimpleDeparturePrediction> departure = new ArrayList<DeparturePrediction.SimpleDeparturePrediction>(count);
        for (int i = 0; i < count; ++i) {
            departure.add(DeparturePrediction.SimpleDeparturePrediction.fromNbt(buffer.m_130260_()));
        }
        return new RealtimeResponsePacket(id, departure, time);
    }

    public void handle(RealtimeResponsePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> RealtimeResponsePacket.lambda$handle$2((Supplier)contextSupplier, packet));
    }

    private static /* synthetic */ void lambda$handle$2(Supplier contextSupplier, RealtimeResponsePacket packet) {
        ((NetworkManager.PacketContext)contextSupplier.get()).queue(() -> new Thread(() -> InstanceManager.runClientRealtimeResponseAction(packet.id, packet.departure, packet.time), "Realtime Processor").run());
    }
}

