/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.stc;

import de.mrjulsen.crn.data.ClientTrainStationSnapshot;
import de.mrjulsen.crn.network.InstanceManager;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class TrackStationResponsePacket
implements IPacketBase<TrackStationResponsePacket> {
    public long id;
    public Collection<String> stationNames;
    public Collection<String> trainNames;
    public int listingTrainCount;
    public int totalTrainCount;

    public TrackStationResponsePacket() {
    }

    public TrackStationResponsePacket(long id, Collection<String> stationNames, Collection<String> trainNames, int listingTrainCount, int totalTrainCount) {
        this.id = id;
        this.stationNames = stationNames;
        this.trainNames = trainNames;
        this.listingTrainCount = listingTrainCount;
        this.totalTrainCount = totalTrainCount;
    }

    public void encode(TrackStationResponsePacket packet, FriendlyByteBuf buffer) {
        buffer.writeLong(packet.id);
        buffer.writeInt(packet.listingTrainCount);
        buffer.writeInt(packet.totalTrainCount);
        buffer.writeInt(packet.stationNames.size());
        for (String s : packet.stationNames) {
            buffer.m_130070_(s);
        }
        buffer.writeInt(packet.trainNames.size());
        for (String s : packet.trainNames) {
            buffer.m_130070_(s);
        }
    }

    public TrackStationResponsePacket decode(FriendlyByteBuf buffer) {
        long id = buffer.readLong();
        int listingTrainCount = buffer.readInt();
        int totalTrainCount = buffer.readInt();
        int count = buffer.readInt();
        ArrayList<String> stationNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            stationNames.add(buffer.m_130277_());
        }
        count = buffer.readInt();
        ArrayList<String> trainNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            trainNames.add(buffer.m_130277_());
        }
        return new TrackStationResponsePacket(id, stationNames, trainNames, listingTrainCount, totalTrainCount);
    }

    public void handle(TrackStationResponsePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> TrackStationResponsePacket.lambda$handle$1((Supplier)contextSupplier, packet));
    }

    private static /* synthetic */ void lambda$handle$1(Supplier contextSupplier, TrackStationResponsePacket packet) {
        ((NetworkManager.PacketContext)contextSupplier.get()).queue(() -> {
            ClientTrainStationSnapshot.makeNew(packet.stationNames == null || packet.stationNames.isEmpty() ? new ArrayList<String>() : new ArrayList<String>(packet.stationNames), packet.trainNames == null || packet.trainNames.isEmpty() ? new ArrayList<String>() : new ArrayList<String>(packet.trainNames), packet.listingTrainCount, packet.totalTrainCount);
            InstanceManager.runClientResponseReceievedAction(packet.id);
        });
    }
}

