/*
 * Decompiled with CFR 0.152.
 */
package daripher.autoleveling.saveddata;

import daripher.autoleveling.data.DimensionsLevelingSettingsReloader;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="autoleveling")
public class WorldLevelingData
extends SavedData {
    private float levelBonus;
    public int tickCount;

    private static WorldLevelingData create() {
        return new WorldLevelingData();
    }

    @SubscribeEvent
    public static void tick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.level.f_46443_) {
            return;
        }
        WorldLevelingData levelingData = WorldLevelingData.get((ServerLevel)event.level);
        levelingData.tick(event.level);
    }

    private static WorldLevelingData load(CompoundTag tag) {
        WorldLevelingData data = WorldLevelingData.create();
        data.levelBonus = tag.m_128457_("LevelBonus");
        data.tickCount = tag.m_128451_("TickCount");
        return data;
    }

    public static WorldLevelingData get(ServerLevel level) {
        return (WorldLevelingData)level.m_8895_().m_164861_(WorldLevelingData::load, WorldLevelingData::create, "world_leveling");
    }

    private void tick(Level world) {
        ++this.tickCount;
        if (this.tickCount >= 24000) {
            this.levelBonus += DimensionsLevelingSettingsReloader.getSettingsForDimension((ResourceKey<Level>)world.m_46472_()).levelsPerDay();
            this.tickCount -= 24000;
        }
        this.m_77762_();
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128350_("LevelBonus", this.levelBonus);
        tag.m_128405_("TickCount", this.tickCount);
        return tag;
    }

    public int getLevelBonus() {
        return (int)this.levelBonus;
    }
}

