/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.modifier;

import com.momosoftworks.coldsweat.api.event.common.TempModifierEvent;
import com.momosoftworks.coldsweat.api.registry.TempModifierRegistry;
import com.momosoftworks.coldsweat.api.util.Temperature;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class TempModifier {
    private CompoundTag nbt = new CompoundTag();
    private int expireTicks = -1;
    private int ticksExisted = 0;
    private int tickRate = 1;
    private double lastInput = 0.0;
    private double lastOutput = 0.0;
    private Function<Double, Double> function = temp -> temp;

    protected abstract Function<Double, Double> calculate(LivingEntity var1, Temperature.Trait var2);

    public final double update(double temp, LivingEntity entity, Temperature.Trait trait) {
        TempModifierEvent.Calculate.Pre pre = new TempModifierEvent.Calculate.Pre(this, entity, temp);
        MinecraftForge.EVENT_BUS.post((Event)pre);
        if (pre.isCanceled()) {
            return pre.getTemperature();
        }
        this.function = this.calculate(entity, trait);
        TempModifierEvent.Calculate.Post post = new TempModifierEvent.Calculate.Post(this, entity, this.getResult(pre.getTemperature()));
        MinecraftForge.EVENT_BUS.post((Event)post);
        return post.getTemperature();
    }

    public final double getResult(double temp) {
        this.lastInput = temp;
        this.lastOutput = this.function.apply(temp);
        return this.lastOutput;
    }

    public final TempModifier expires(int ticks) {
        this.expireTicks = ticks;
        return this;
    }

    public final int getExpireTime() {
        return this.expireTicks;
    }

    public final int getTicksExisted() {
        return this.ticksExisted;
    }

    public final int setTicksExisted(int ticks) {
        this.ticksExisted = ticks;
        return this.ticksExisted;
    }

    public final TempModifier tickRate(int ticks) {
        this.tickRate = Math.max(1, ticks);
        return this;
    }

    public final int getTickRate() {
        return this.tickRate;
    }

    public final double getLastInput() {
        return this.lastInput;
    }

    public final double getLastOutput() {
        return this.lastOutput;
    }

    public final CompoundTag getNBT() {
        return this.nbt;
    }

    public void setNBT(CompoundTag data) {
        this.nbt = data;
    }

    public String toString() {
        return TempModifierRegistry.getKey(this).toString();
    }

    public boolean equals(Object obj) {
        TempModifier mod;
        return obj instanceof TempModifier && TempModifierRegistry.getKey(mod = (TempModifier)obj).equals((Object)TempModifierRegistry.getKey(this)) && mod.getNBT().equals((Object)this.getNBT());
    }
}

